/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens.core.functions;

import com.hekta.chcitizens.abstraction.CHCitizensStaticLayer;
import com.hekta.chcitizens.abstraction.MCCitizensEntityTarget;
import com.hekta.chcitizens.abstraction.MCCitizensNPC;
import com.hekta.chcitizens.abstraction.MCCitizensNavigator;
import com.hekta.chcitizens.abstraction.MCCitizensTalkable;
import com.hekta.chcitizens.abstraction.enums.MCCitizensTargetType;
import com.hekta.chcitizens.core.CHCitizensStatic;
import com.hekta.chcitizens.core.functions.CitizensFunctions;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Collection;
import java.util.HashSet;

public abstract class CitizensAI
extends CitizensFunctions {
    public static String docs() {
        return "This class allows to interact with the AI of the NPCs.";
    }

    @api
    public static final class ctz_npc_speak
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class, CREBadEntityException.class};
        }

        public String docs() {
            return "void {npcID, message, [recipients]} Makes the given NPC speak a message to the given recipients. recipients can take an array of player names and/or UUIDs, or a single player name or UUID.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t);
            if (args.length == 2) {
                Collection p = Static.getServer().getOnlinePlayers();
                MCCitizensTalkable[] recipients = new MCCitizensTalkable[p.size()];
                int i = 0;
                for (MCPlayer player : p) {
                    recipients[i] = CHCitizensStaticLayer.newTalkableEntity((MCEntity)player);
                    ++i;
                }
                npc.getDefaultSpeechController().speak(CHCitizensStaticLayer.newSpeechContext(npc, args[1].val(), recipients));
            } else if (args[2] instanceof CArray) {
                CArray array = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
                if (array.inAssociativeMode()) {
                    throw new CRECastException("The array of recipients must not be associative.", t);
                }
                HashSet<MCCitizensTalkable> recipients = new HashSet<MCCitizensTalkable>();
                for (Mixed recipient : array.asList()) {
                    recipients.add(CHCitizensStaticLayer.newTalkableEntity((MCEntity)Static.GetPlayer((Mixed)recipient, (Target)t)));
                }
                npc.getDefaultSpeechController().speak(CHCitizensStaticLayer.newSpeechContext(npc, args[1].val(), recipients));
            } else {
                npc.getDefaultSpeechController().speak(CHCitizensStaticLayer.newSpeechContext(npc, args[1].val(), CHCitizensStaticLayer.newTalkableEntity((MCEntity)Static.GetPlayer((Mixed)args[2], (Target)t))));
            }
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_set_npc_stationary_ticks
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, int} Sets the stationary ticks of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            int ticks = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setStationaryTicks(ticks);
            navigator.getLocalParameters().setStationaryTicks(ticks);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_stationary_ticks
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "int {npcID} Returns the stationary ticks of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble((double)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getStationaryTicks(), t);
        }
    }

    @api
    public static final class ctz_set_npc_range
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, double} Sets the range of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            float range = (float)ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setRange(range);
            navigator.getLocalParameters().setRange(range);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_range
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "double {npcID} Returns the range of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble((double)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getRange(), t);
        }
    }

    @api
    public static final class ctz_set_npc_distance_margin
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, double} Sets the distance margin of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            double distanceMargin = ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setDistanceMargin(distanceMargin);
            navigator.getLocalParameters().setDistanceMargin(distanceMargin);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_distance_margin
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "double {npcID} Returns the distance margin of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble(CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getDistanceMargin(), t);
        }
    }

    @api
    public static final class ctz_set_npc_speed_modifier
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, double} Sets the speed modifier of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            float speedModifier = (float)ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setSpeedModifier(speedModifier);
            navigator.getLocalParameters().setSpeedModifier(speedModifier);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_speed_modifier
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "double {npcID} Returns the speed modifier of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble((double)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getSpeedModifier(), t);
        }
    }

    @api
    public static final class ctz_set_npc_base_speed
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, double} Sets the base speed of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            float baseSpeed = (float)ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setBaseSpeed(baseSpeed);
            navigator.getLocalParameters().setBaseSpeed(baseSpeed);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_base_speed
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "double {npcID} Returns the base speed of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble((double)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getBaseSpeed(), t);
        }
    }

    @api
    public static final class ctz_npc_speed
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "double {npcID} Returns the speed of the given NPC.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble((double)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getSpeed(), t);
        }
    }

    @api
    public static final class ctz_set_npc_avoid_water
    extends CitizensFunctions.CitizensNPCSetterFunction {
        public String docs() {
            return "void {npcID, boolean} Sets if the given NPC has to avoid water.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator();
            boolean avoidWater = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            navigator.getDefaultParameters().setAvoidWater(avoidWater);
            navigator.getLocalParameters().setAvoidWater(avoidWater);
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_avoid_water
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "boolean {npcID} Returns if the given NPC has to avoid water.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getLocalParameters().getAvoidWater());
        }
    }

    @api
    public static final class ctz_cancel_npc_navigation
    extends CitizensFunctions.CitizensNPCSetterFunction {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {npcID} Cancels the current navigation of the given NPC towards a target.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().cancelNavigation();
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_is_navigating
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "boolean {npcID} Returns if the given NPC is navigating.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().isNavigating());
        }
    }

    @api
    public static final class ctz_npc_is_aggressive
    extends CitizensFunctions.CitizensNPCGetterFunction {
        public String docs() {
            return "boolean {npcID} Returns if the given NPC is aggressive.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensEntityTarget target = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getEntityTarget();
            if (target != null) {
                return CBoolean.get((boolean)target.isAggressive());
            }
            return CBoolean.FALSE;
        }
    }

    @api
    public static final class ctz_set_npc_target
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRECastException.class, CRENotFoundException.class, CREPluginInternalException.class};
        }

        public String docs() {
            return "void {npcID, target, [isAggressive]} Sets the target of the given NPC. target can be a location array or an entityID. If target is an entityID, isAggressive (a boolean) will specify if the NPC will attack the targeted entity, defaut to false.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t);
            if (!npc.isSpawned()) {
                throw new CREPluginInternalException("The NPC is not spawned.", t);
            }
            if (args[1] instanceof CArray) {
                npc.getNavigator().setTarget(ObjectGenerator.GetGenerator().location(args[1], npc.getStoredLocation().getWorld(), t));
            } else {
                boolean isAggressive = args.length == 2 ? false : ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
                npc.getNavigator().setTarget((MCEntity)Static.getLivingEntity((Mixed)args[1], (Target)t), isAggressive);
            }
            CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).setProtected(ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_target
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRECastException.class, CRENotFoundException.class, CREFormatException.class};
        }

        public String docs() {
            return "mixed {npcID, [field]} Returns the target of the given NPC. Field can be one of 'location', 'entity' or 'type', default to 'type'. If field is 'location', the function will returns a location array, else if field is 'entity', the function fill return the entity id, else if field is 'type', the function will return the target type (can be " + StringUtils.Join((Object[])MCCitizensTargetType.values(), (String)", ", (String)", or ", (String)" or ") + "). The function will return null if the NPC has not a target, or if the field is 'entity' and that the target type is a location.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args.length == 1 || args[1].val().equalsIgnoreCase("LOCATION")) {
                MCLocation location = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getTargetAsLocation();
                if (location != null) {
                    return ObjectGenerator.GetGenerator().location(location);
                }
                return CNull.NULL;
            }
            if (args[1].val().equalsIgnoreCase("ENTITY")) {
                MCCitizensEntityTarget target = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getEntityTarget();
                if (target != null) {
                    return new CString(target.getTarget().getUniqueId().toString(), t);
                }
                return CNull.NULL;
            }
            if (args[1].val().equalsIgnoreCase("TYPE")) {
                return new CString(CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t).getNavigator().getTargetType().toString(), t);
            }
            throw new CREFormatException("Invalid field:'" + args[1].val() + "'.", t);
        }
    }
}

