/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens.abstraction.bukkit;

import com.hekta.chcitizens.abstraction.MCCitizensNPC;
import com.hekta.chcitizens.abstraction.MCCitizensNPCRegistry;
import com.hekta.chcitizens.abstraction.bukkit.BukkitMCCitizensNPC;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.enums.MCEntityType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.entity.EntityType;

public class BukkitMCCitizensNPCRegistry
implements MCCitizensNPCRegistry {
    private final NPCRegistry _registry;

    public BukkitMCCitizensNPCRegistry(NPCRegistry registry) {
        this._registry = registry;
    }

    public NPCRegistry getHandle() {
        return this._registry;
    }

    @Override
    public MCCitizensNPC createNPC(MCEntityType.MCVanillaEntityType type, UUID uuid, int id, String name) {
        NPC npc = this._registry.createNPC((EntityType)MCEntityType.valueOfVanillaType((MCEntityType.MCVanillaEntityType)type).getConcrete(), uuid, id, name);
        return npc != null ? new BukkitMCCitizensNPC(npc) : null;
    }

    @Override
    public MCCitizensNPC createNPC(MCEntityType.MCVanillaEntityType type, int id, String name) {
        return this.createNPC(type, UUID.randomUUID(), id, name);
    }

    @Override
    public MCCitizensNPC createNPC(MCEntityType.MCVanillaEntityType type, String name) {
        NPC npc = this._registry.createNPC((EntityType)MCEntityType.valueOfVanillaType((MCEntityType.MCVanillaEntityType)type).getConcrete(), name);
        return npc != null ? new BukkitMCCitizensNPC(npc) : null;
    }

    @Override
    public void deregisterNPC(MCCitizensNPC npc) {
        this._registry.deregister(((BukkitMCCitizensNPC)npc).getHandle());
    }

    @Override
    public Set<MCCitizensNPC> getNPCs() {
        HashSet<MCCitizensNPC> npcs = new HashSet<MCCitizensNPC>();
        for (NPC npc : this._registry) {
            npcs.add(new BukkitMCCitizensNPC(npc));
        }
        return npcs;
    }

    @Override
    public MCCitizensNPC getNPC(MCEntity entity) {
        NPC npc = this._registry.getNPC(((BukkitMCEntity)entity).getHandle());
        if (npc != null) {
            return new BukkitMCCitizensNPC(npc);
        }
        return null;
    }

    @Override
    public boolean isNPC(MCEntity entity) {
        return this._registry.isNPC(((BukkitMCEntity)entity).getHandle());
    }

    @Override
    public MCCitizensNPC getNPC(int id) {
        NPC npc = this._registry.getById(id);
        if (npc != null) {
            return new BukkitMCCitizensNPC(npc);
        }
        return null;
    }

    @Override
    public MCCitizensNPC getNPC(UUID uuid) {
        NPC npc = this._registry.getByUniqueId(uuid);
        if (npc != null) {
            return new BukkitMCCitizensNPC(npc);
        }
        return null;
    }
}

