/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens.core.functions;

import com.hekta.chcitizens.abstraction.MCCitizensNPC;
import com.hekta.chcitizens.abstraction.traits.MCCitizensOwner;
import com.hekta.chcitizens.core.CHCitizensStatic;
import com.hekta.chcitizens.core.functions.CitizensFunctions;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Iterator;

public abstract class CitizensTraits
extends CitizensFunctions {
    public static String docs() {
        return "This class allows to manage the traits of the NPCs.";
    }

    @api
    public static final class ctz_npc_has_trait
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRENotFoundException.class};
        }

        public String docs() {
            return "array {npcID, traitName} Returns if the NPC has a trait with the given name.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t);
            String trait = args[1].val();
            if (trait.equalsIgnoreCase("owner")) {
                return CBoolean.get((boolean)npc.hasTrait("owner"));
            }
            throw new CREIndexOverflowException("Unknown or unsupported trait: " + trait + ".", t);
        }
    }

    @api
    public static final class ctz_set_npc_trait
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRENotFoundException.class, CREIndexOverflowException.class, CRECastException.class};
        }

        public String docs() {
            return "array {npcID, traitName, array} Sets a NPC trait. The trait must be an associative array, in the same format that it is returned by ctz_npc_traits";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t);
            String trait = args[1].val();
            CArray array = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            if (!trait.equalsIgnoreCase("owner")) throw new CREIndexOverflowException("Unknown or unsupported trait: " + trait + ".", t);
            if (!npc.hasTrait("owner")) throw new CRENotFoundException("The NPC does not have the given trait:" + args[1].val() + ".", t);
            for (String key : array.stringKeySet()) {
                if (!key.equals("owner")) throw new CREIndexOverflowException("Invalid key:" + key + ".", t);
                ((MCCitizensOwner)npc.getTrait("owner")).setOwner(Static.GetUser((Mixed)array.get(key, t), (Target)t));
            }
            return CVoid.VOID;
        }
    }

    @api
    public static final class ctz_npc_traits
    extends CitizensFunctions.CitizensNPCFunction {
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRENotFoundException.class, CREIndexOverflowException.class};
        }

        public String docs() {
            return "array {npcID, [traitName]} Returns an associative array representing the traits the NPC has, or representing the trait with the given name. a trait is an associative array of one or more values, or null if the NOC does not have the trait. Actually, supported traits are OWNER.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)args[0], (Target)t), t);
            String trait = args.length == 1 ? null : args[1].val();
            CArray traitArray = new CArray(t);
            if (trait == null || trait.equalsIgnoreCase("owner")) {
                if (npc.hasTrait("owner")) {
                    CArray ownerArray = new CArray(t);
                    ownerArray.set("owner", (Mixed)new CString(((MCCitizensOwner)npc.getTrait("owner")).getOwner().getName(), t), t);
                    traitArray.set("owner", (Mixed)ownerArray, t);
                } else {
                    traitArray.set("owner", (Mixed)CNull.NULL, t);
                }
            }
            if (trait == null) {
                return traitArray;
            }
            Iterator iterator = traitArray.stringKeySet().iterator();
            if (iterator.hasNext()) {
                String key = (String)iterator.next();
                return traitArray.get(key, t);
            }
            throw new CREIndexOverflowException("Unknown or unsupported trait: " + args[1].val() + ".", t);
        }
    }
}

