/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens;

import com.hekta.chcitizens.abstraction.CHCitizensStaticLayer;
import com.hekta.chcitizens.abstraction.MCCitizensNPCRegistry;
import com.hekta.chcitizens.abstraction.MCCitizensPlugin;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.MSExtension;

@MSExtension(value="CHCitizens")
public class CHCitizens
extends AbstractExtension {
    private static final Version VERSION = new SimpleVersion(1, 2, 0);
    private static MCCitizensPlugin _citizens;
    private static MCCitizensNPCRegistry _registry;

    public Version getVersion() {
        return VERSION;
    }

    public void onStartup() {
        _citizens = CHCitizensStaticLayer.getCitizens();
        if (_citizens != null) {
            _registry = _citizens.getNPCRegistry();
            CHCitizensStaticLayer.startup();
            Static.getLogger().info(String.format("%s %s enabled.", this.getName(), VERSION));
        } else {
            Static.getLogger().severe(String.format("Plugin %s seems to be missing, none of the %s functions will work.", "Citizens", this.getName()));
        }
    }

    public void onShutdown() {
        if (_citizens != null) {
            CHCitizensStaticLayer.shutdown();
            _citizens = null;
            _registry = null;
            Static.getLogger().info(String.format("%s disabled.", this.getName()));
        }
    }

    public static MCCitizensPlugin getCitizensPlugin() {
        return _citizens;
    }

    public static MCCitizensNPCRegistry getNPCRegistry() {
        if (_registry == null && _citizens != null) {
            _registry = _citizens.getNPCRegistry();
        }
        return _registry;
    }
}

