/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens.abstraction.bukkit;

import com.hekta.chcitizens.abstraction.CHCitizensStaticLayer;
import com.hekta.chcitizens.abstraction.MCCitizensGoalController;
import com.hekta.chcitizens.abstraction.MCCitizensNPC;
import com.hekta.chcitizens.abstraction.MCCitizensNavigator;
import com.hekta.chcitizens.abstraction.MCCitizensSpeechController;
import com.hekta.chcitizens.abstraction.MCCitizensTrait;
import com.hekta.chcitizens.abstraction.bukkit.BukkitMCCitizensGoalController;
import com.hekta.chcitizens.abstraction.bukkit.BukkitMCCitizensNavigator;
import com.hekta.chcitizens.abstraction.bukkit.BukkitMCCitizensSpeechController;
import com.hekta.chcitizens.abstraction.bukkit.BukkitMCCitizensTrait;
import com.hekta.chcitizens.abstraction.enums.MCCitizensDespawnReason;
import com.hekta.chcitizens.abstraction.enums.bukkit.BukkitMCCitizensDespawnReason;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitMCCitizensNPC
implements MCCitizensNPC {
    private final NPC _npc;

    public BukkitMCCitizensNPC(NPC npc) {
        this._npc = npc;
    }

    public NPC getHandle() {
        return this._npc;
    }

    @Override
    public Set<MCCitizensTrait> getTraits() {
        HashSet<MCCitizensTrait> traits = new HashSet<MCCitizensTrait>();
        for (Trait trait : this._npc.getTraits()) {
            traits.add(CHCitizensStaticLayer.getCorrectTrait(new BukkitMCCitizensTrait(trait)));
        }
        return traits;
    }

    @Override
    public MCCitizensTrait getTrait(String name) {
        for (Trait trait : this._npc.getTraits()) {
            if (!trait.getName().equals(name)) continue;
            return CHCitizensStaticLayer.getCorrectTrait(new BukkitMCCitizensTrait(trait));
        }
        return null;
    }

    @Override
    public boolean hasTrait(String name) {
        for (Trait trait : this._npc.getTraits()) {
            if (!trait.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean spawn(MCLocation location) {
        return this._npc.spawn(((BukkitMCLocation)location).asLocation());
    }

    @Override
    public boolean despawn(MCCitizensDespawnReason reason) {
        return this._npc.despawn((DespawnReason)BukkitMCCitizensDespawnReason.getConvertor().getConcreteEnum(reason));
    }

    @Override
    public boolean isSpawned() {
        return this._npc.isSpawned();
    }

    @Override
    public void destroy() {
        this._npc.destroy();
    }

    @Override
    public void faceLocation(MCLocation location) {
        this._npc.faceLocation(((BukkitMCLocation)location).asLocation());
    }

    @Override
    public MCLocation getStoredLocation() {
        Location location = this._npc.getStoredLocation();
        if (location != null) {
            return new BukkitMCLocation(location);
        }
        return null;
    }

    @Override
    public MCEntity getEntity() {
        Entity entity = this._npc.getEntity();
        if (entity == null) {
            return null;
        }
        return BukkitConvertor.BukkitGetCorrectEntity((Entity)entity);
    }

    @Override
    public void setEntityType(MCEntityType type) {
        this._npc.setBukkitEntityType((EntityType)((BukkitMCEntityType)type).getConcrete());
    }

    @Override
    public MCCitizensGoalController getDefaultGoalController() {
        return new BukkitMCCitizensGoalController(this._npc.getDefaultGoalController());
    }

    @Override
    public MCCitizensNavigator getNavigator() {
        return new BukkitMCCitizensNavigator(this._npc.getNavigator());
    }

    @Override
    public MCCitizensSpeechController getDefaultSpeechController() {
        return new BukkitMCCitizensSpeechController(this._npc.getDefaultSpeechController());
    }

    @Override
    public int getId() {
        return this._npc.getId();
    }

    @Override
    public UUID getUniqueId() {
        return this._npc.getUniqueId();
    }

    @Override
    public String getName() {
        return this._npc.getName();
    }

    @Override
    public void setName(String name) {
        this._npc.setName(name);
    }

    @Override
    public String getFullName() {
        return this._npc.getFullName();
    }

    @Override
    public boolean isProtected() {
        return this._npc.isProtected();
    }

    @Override
    public void setProtected(boolean isProtected) {
        this._npc.setProtected(isProtected);
    }
}

