/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chdiscord;

import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import me.pseudoknight.chdiscord.abstraction.events.DiscordGuildMessageReceivedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordGuildMessageUpdatedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordMemberJoinEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordMemberLeaveEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordPrivateMessageReceivedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordReactionAddedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordReactionRemovedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordVoiceJoinedEvent;
import me.pseudoknight.chdiscord.abstraction.events.DiscordVoiceLeftEvent;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;

public class Events {
    public static String docs() {
        return "This provides hooks for Discord events.";
    }

    private static void EvaluateMessage(Message msg, Map<String, Mixed> map) {
        Target t = Target.UNKNOWN;
        map.put("message", (Mixed)new CString(msg.getContentDisplay(), t));
        map.put("id", (Mixed)new CInt(msg.getIdLong(), t));
        CArray attachments = new CArray(t);
        for (Message.Attachment msgAttachment : msg.getAttachments()) {
            CArray attachment = CArray.GetAssociativeArray((Target)t);
            attachment.set("url", (Mixed)new CString(msgAttachment.getUrl(), t), t);
            attachment.set("filename", (Mixed)new CString(msgAttachment.getFileName(), t), t);
            attachment.set("description", (Mixed)new CString(msgAttachment.getDescription(), t), t);
            attachments.push((Mixed)attachment, t);
        }
        map.put("attachments", (Mixed)attachments);
        if (msg.getReferencedMessage() != null) {
            CArray reference = CArray.GetAssociativeArray((Target)t);
            Message referencedMsg = msg.getReferencedMessage();
            reference.set("id", (Mixed)new CInt(referencedMsg.getIdLong(), t), t);
            reference.set("username", (Mixed)new CString(referencedMsg.getAuthor().getName(), t), t);
            reference.set("userid", (Mixed)new CInt(referencedMsg.getAuthor().getIdLong(), t), t);
            reference.set("message", (Mixed)new CString(referencedMsg.getContentDisplay(), t), t);
            map.put("reference", (Mixed)reference);
        } else {
            map.put("reference", (Mixed)CNull.NULL);
        }
    }

    @api
    public static class discord_member_left
    extends DiscordEvent {
        public String getName() {
            return "discord_member_left";
        }

        public String docs() {
            return "{} This event is called when a user left the Discord server, including kick/ban.{username: The Discord username | nickname: The effective display name in this guild server | userid: The Discord user's unique id | serverid: The guild server left } {} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof DiscordMemberLeaveEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordMemberLeaveEvent event = (DiscordMemberLeaveEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Member mem = event.getMember();
            User user = event.getUser();
            map.put("username", (Mixed)new CString(user.getName(), t));
            map.put("userid", (Mixed)new CInt(user.getIdLong(), t));
            if (mem != null) {
                map.put("nickname", (Mixed)new CString(mem.getEffectiveName(), t));
            } else {
                map.put("nickname", (Mixed)new CString(user.getName(), t));
            }
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            return map;
        }
    }

    @api
    public static class discord_member_joined
    extends DiscordEvent {
        public String getName() {
            return "discord_member_joined";
        }

        public String docs() {
            return "{} This event is called when a user joined the Discord server.{username: The Discord username | nickname: The effective display name in this guild server | userid: The Discord user's unique id | serverid: The guild server joined } {} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof DiscordMemberJoinEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordMemberJoinEvent event = (DiscordMemberJoinEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("username", (Mixed)new CString(event.getMember().getUser().getName(), t));
            map.put("userid", (Mixed)new CInt(event.getMember().getUser().getIdLong(), t));
            map.put("nickname", (Mixed)new CString(event.getMember().getEffectiveName(), t));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            return map;
        }
    }

    @api
    public static class discord_voice_left
    extends DiscordEvent {
        public String getName() {
            return "discord_voice_left";
        }

        public String docs() {
            return "{} This event is called when a user leaves a voice channel on the Discord server.{username: The Discord username | nickname: The effective display name in this guild server | userid: The Discord user's unique id | serverid: The guild server in which this event occurred | channel: The name of the channel the user left | channelid: The unique id for the channel.}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof DiscordVoiceLeftEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordVoiceLeftEvent event = (DiscordVoiceLeftEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("username", (Mixed)new CString(event.getMember().getUser().getName(), t));
            map.put("userid", (Mixed)new CInt(event.getMember().getUser().getIdLong(), t));
            map.put("nickname", (Mixed)new CString(event.getMember().getEffectiveName(), t));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            return map;
        }
    }

    @api
    public static class discord_voice_joined
    extends DiscordEvent {
        public String getName() {
            return "discord_voice_joined";
        }

        public String docs() {
            return "{} This event is called when a user joins a voice channel on the Discord server.{username: The Discord username | nickname: The effective display name in this guild server | userid: The Discord user's unique id | serverid: The guild server in which this event occurred | channel: The name of the channel the user joined | channelid: The unique id for the channel.}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof DiscordVoiceJoinedEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordVoiceJoinedEvent event = (DiscordVoiceJoinedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("username", (Mixed)new CString(event.getMember().getUser().getName(), t));
            map.put("userid", (Mixed)new CInt(event.getMember().getUser().getIdLong(), t));
            map.put("nickname", (Mixed)new CString(event.getMember().getEffectiveName(), t));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            return map;
        }
    }

    @api
    public static class discord_reaction_removed
    extends DiscordEvent {
        public String getName() {
            return "discord_reaction_removed";
        }

        public String docs() {
            return "{channel: <string match> Channel's name} This event is called when a user removes a reaction on a message.{username: The username of the reactor | nickname: The effective display name of the reactor in this guild server | userid: The reactor's unique user id | bot: If the reactor is a bot | serverid: The guild server in which the message exists | channel: The name of the channel in which the message exists | channelid: The unique id for the channel | messageid: The unique id of the message being reacted to | emoji: The unicode character or custom code}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof DiscordReactionRemovedEvent) {
                DiscordReactionRemovedEvent event = (DiscordReactionRemovedEvent)e;
                return !prefilter.containsKey("channel") || event.getChannel().getName().equals(prefilter.get("channel").val());
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordReactionRemovedEvent event = (DiscordReactionRemovedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Member mem = event.getReactor();
            map.put("nickname", (Mixed)new CString(mem.getEffectiveName(), t));
            map.put("username", (Mixed)new CString(mem.getUser().getName(), t));
            map.put("userid", (Mixed)new CInt(mem.getIdLong(), t));
            map.put("bot", (Mixed)CBoolean.get((boolean)mem.getUser().isBot()));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            map.put("messageid", (Mixed)new CInt(event.getMessageId(), t));
            map.put("emoji", (Mixed)new CString(event.getEmoji().getFormatted(), t));
            return map;
        }
    }

    @api
    public static class discord_reaction_added
    extends DiscordEvent {
        public String getName() {
            return "discord_reaction_added";
        }

        public String docs() {
            return "{channel: <string match> Channel's name} This event is called when a user adds a reaction to a message.{username: The username of the reactor | nickname: The effective display name of the reactor in this guild server | userid: The reactor's unique user id | bot: If the reactor is a bot | serverid: The guild server in which the message exists | channel: The name of the channel in which the message exists | channelid: The unique id for the channel | messageid: The unique id of the message being reacted to | messageuserid: The unique id of the author of the message being reacted to | emoji: The unicode character or custom code}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof DiscordReactionAddedEvent) {
                DiscordReactionAddedEvent event = (DiscordReactionAddedEvent)e;
                return !prefilter.containsKey("channel") || event.getChannel().getName().equals(prefilter.get("channel").val());
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordReactionAddedEvent event = (DiscordReactionAddedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Member mem = event.getReactor();
            map.put("nickname", (Mixed)new CString(mem.getEffectiveName(), t));
            map.put("username", (Mixed)new CString(mem.getUser().getName(), t));
            map.put("userid", (Mixed)new CInt(mem.getIdLong(), t));
            map.put("bot", (Mixed)CBoolean.get((boolean)mem.getUser().isBot()));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            map.put("messageid", (Mixed)new CInt(event.getMessageId(), t));
            map.put("messageuserid", (Mixed)new CInt(event.getMessageAuthorId(), t));
            map.put("emoji", (Mixed)new CString(event.getEmoji().getFormatted(), t));
            return map;
        }
    }

    @api
    public static class discord_private_message_received
    extends DiscordEvent {
        public String getName() {
            return "discord_private_message_received";
        }

        public String docs() {
            return "{} This event is called when a user sends a private message to the bot.{username: The Discord username | userid: The Discord user's unique id | displayname: The Discord user's display name | message: The message the user sent. | id: The message id. | attachments: An array of attachment arrays, each with the keys 'url', 'filename', and 'description'. | reference: An associative array representing the message this was a reply to, with the keys 'id', 'userid', 'username', and 'message'. Will be null if the message was not a reply.}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof DiscordPrivateMessageReceivedEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordPrivateMessageReceivedEvent event = (DiscordPrivateMessageReceivedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("username", (Mixed)new CString(event.getAuthor().getName(), t));
            map.put("displayname", (Mixed)new CString(event.getAuthor().getEffectiveName(), t));
            map.put("userid", (Mixed)new CInt(event.getAuthor().getIdLong(), t));
            Events.EvaluateMessage(event.getMessage(), map);
            return map;
        }
    }

    @api
    public static class discord_message_updated
    extends DiscordEvent {
        public String getName() {
            return "discord_message_updated";
        }

        public String docs() {
            return "{channel: <string match> Channel's name} This event is called when a user edits a message in a Discord server.{username: The username of the author | nickname: The effective display name of the author in this guild server | userid: The author's unique id | bot: If the author is a bot | serverid: The guild server in which this the message was sent | channel: The name of the channel in which the message was sent | channelid: The unique id for the channel. | channeltype: The type of channel. (TEXT, VOICE, NEWS, GUILD_NEWS_THREAD, GUILD_PUBLIC_THREAD, or GUILD_PRIVATE_THREAD) | message: The message the author edited. | id: The message id. | attachments: An array of attachment arrays, each with the keys 'url', 'filename', and 'description'. | reference: An associative array representing the message this was a reply to, with the keys 'id', 'userid', 'username', and 'message'. Will be null if the message was not a reply.}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof DiscordGuildMessageUpdatedEvent) {
                DiscordGuildMessageUpdatedEvent event = (DiscordGuildMessageUpdatedEvent)e;
                return !prefilter.containsKey("channel") || event.getChannel().getName().equals(prefilter.get("channel").val());
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordGuildMessageUpdatedEvent event = (DiscordGuildMessageUpdatedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Member mem = event.getMember();
            map.put("nickname", (Mixed)new CString(mem != null ? mem.getEffectiveName() : event.getAuthor().getEffectiveName(), t));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            map.put("channeltype", (Mixed)new CString(event.getChannel().getType().name(), t));
            map.put("bot", (Mixed)CBoolean.get((boolean)event.getAuthor().isBot()));
            map.put("username", (Mixed)new CString(event.getAuthor().getName(), t));
            map.put("userid", (Mixed)new CInt(event.getAuthor().getIdLong(), t));
            Events.EvaluateMessage(event.getMessage(), map);
            return map;
        }
    }

    @api
    public static class discord_message_received
    extends DiscordEvent {
        public String getName() {
            return "discord_message_received";
        }

        public String docs() {
            return "{username: <string match> Sender's name | channel: <string match> Channel's name} This event is called when a user sends a message in a Discord server.{username: The username of the sender | nickname: The effective display name of the sender in this guild server | userid: The sender's unique id | bot: If the user is a bot | serverid: The guild server in which this the message was sent | channel: The name of the channel in which the message was sent | channelid: The unique id for the channel. | channeltype: The type of channel. (TEXT, VOICE, NEWS, GUILD_NEWS_THREAD, GUILD_PUBLIC_THREAD, or GUILD_PRIVATE_THREAD) | message: The message the user sent. | id: The message id. | attachments: An array of attachment arrays, each with the keys 'url', 'filename', and 'description'. | reference: An associative array representing the message this was a reply to, with the keys 'id', 'userid', 'username', and 'message'. Will be null if the message was not a reply.}{} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof DiscordGuildMessageReceivedEvent) {
                DiscordGuildMessageReceivedEvent event = (DiscordGuildMessageReceivedEvent)e;
                if (prefilter.containsKey("username") && !event.getMember().getUser().getName().equals(prefilter.get("username").val())) {
                    return false;
                }
                return !prefilter.containsKey("channel") || event.getChannel().getName().equals(prefilter.get("channel").val());
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            DiscordGuildMessageReceivedEvent event = (DiscordGuildMessageReceivedEvent)e;
            Target t = Target.UNKNOWN;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Member mem = event.getMember();
            map.put("nickname", (Mixed)new CString(mem != null ? mem.getEffectiveName() : event.getAuthor().getEffectiveName(), t));
            map.put("username", (Mixed)new CString(event.getAuthor().getName(), t));
            map.put("userid", (Mixed)new CInt(event.getAuthor().getIdLong(), t));
            map.put("bot", (Mixed)CBoolean.get((boolean)event.getAuthor().isBot()));
            map.put("serverid", (Mixed)new CInt(event.getGuild().getIdLong(), t));
            map.put("channel", (Mixed)new CString(event.getChannel().getName(), t));
            map.put("channelid", (Mixed)new CInt(event.getChannel().getIdLong(), t));
            map.put("channeltype", (Mixed)new CString(event.getChannel().getType().name(), t));
            Events.EvaluateMessage(event.getMessage(), map);
            return map;
        }
    }

    public static abstract class DiscordEvent
    extends AbstractEvent {
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray cArray, Target target) {
            return null;
        }

        public boolean modifyEvent(String s, Mixed construct, BindableEvent bindableEvent) {
            return false;
        }
    }
}

