/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chdiscord;

import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientPermissionException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.awt.Color;
import java.time.Instant;
import me.pseudoknight.chdiscord.Discord;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public class MemberFunctions {
    static final String MEMBER_ARGUMENT = " The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist.";

    public static String docs() {
        return "Functions for managing Discord users/members.";
    }

    @api
    public static class discord_member_info
    extends Discord.Function {
        public String getName() {
            return "discord_member_info";
        }

        public String docs() {
            return "array {[server], member} Gets an array of data for Discord user. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. Array contains 'userid', 'username', 'displayname', and 'bot' (boolean). For this guild server it also contains: 'nickname' (empty if not set), 'color' array (null if none), 'joined_at' timestamp, and 'avatar' effective url.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            CArray ret = CArray.GetAssociativeArray((Target)t);
            Member member = args.length == 2 ? Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t) : Discord.GetMember(args[0], Discord.GetGuild(environment), t);
            ret.set("nickname", member.getNickname());
            Color color = member.getColor();
            if (color != null) {
                CArray colorArray = CArray.GetAssociativeArray((Target)t);
                colorArray.set("r", (Mixed)new CInt((long)color.getRed(), t), t);
                colorArray.set("g", (Mixed)new CInt((long)color.getGreen(), t), t);
                colorArray.set("b", (Mixed)new CInt((long)color.getBlue(), t), t);
                ret.set("color", (Mixed)colorArray, t);
            } else {
                ret.set("color", (Mixed)CNull.NULL, t);
            }
            ret.set("avatar", member.getEffectiveAvatarUrl());
            ret.set("joined_at", (Mixed)new CInt(Instant.from(member.getTimeJoined()).toEpochMilli(), t), t);
            User user = member.getUser();
            ret.set("userid", (Mixed)new CInt(user.getIdLong(), t), t);
            ret.set("username", user.getName());
            ret.set("displayname", user.getEffectiveName());
            ret.set("bot", (Mixed)CBoolean.get((boolean)user.isBot()), t);
            return ret;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_member_set_muted
    extends Discord.Function {
        public String getName() {
            return "discord_member_set_muted";
        }

        public String docs() {
            return "void {[server], member, boolean} Set a user's server muted state. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. Throws IllegalArgumentException if member is not connected to a voice channel. Requires the 'Mute Members' permission.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean muteState;
            Member member;
            Discord.CheckConnection(t);
            if (args.length == 3) {
                member = Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t);
                muteState = ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
            } else {
                member = Discord.GetMember(args[0], Discord.GetGuild(environment), t);
                muteState = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            }
            try {
                member.mute(muteState).queue(null, ex -> Discord.HandleFailure(ex, t));
            }
            catch (PermissionException ex2) {
                throw new CREInsufficientPermissionException(ex2.getMessage(), t);
            }
            catch (IllegalStateException ex3) {
                throw new CREIllegalArgumentException(ex3.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_member_is_muted
    extends Discord.Function {
        public String getName() {
            return "discord_member_is_muted";
        }

        public String docs() {
            return "boolean {[server], member} Check if a user is muted, either self muted or server muted. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            Member member = args.length == 2 ? Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t) : Discord.GetMember(args[0], Discord.GetGuild(environment), t);
            try {
                GuildVoiceState voiceState = member.getVoiceState();
                if (voiceState == null) {
                    return CBoolean.FALSE;
                }
                return CBoolean.get((boolean)voiceState.isMuted());
            }
            catch (PermissionException ex) {
                throw new CREInsufficientPermissionException(ex.getMessage(), t);
            }
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class};
        }
    }

    @api
    public static class discord_member_get_voice_channel
    extends Discord.Function {
        public String getName() {
            return "discord_member_get_voice_channel";
        }

        public String docs() {
            return "string {[server], member} Get the ID of the member's current voice channel. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. If the member is not connected to a voice channel, null is returned.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            Member member = args.length == 2 ? Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t) : Discord.GetMember(args[0], Discord.GetGuild(environment), t);
            try {
                GuildVoiceState voiceState = member.getVoiceState();
                if (voiceState == null) {
                    return CNull.NULL;
                }
                AudioChannelUnion channel = voiceState.getChannel();
                if (channel == null) {
                    return CNull.NULL;
                }
                return new CString(channel.getId(), t);
            }
            catch (PermissionException ex) {
                throw new CREInsufficientPermissionException(ex.getMessage(), t);
            }
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class};
        }
    }

    @api
    public static class discord_member_set_nickname
    extends Discord.Function {
        public String getName() {
            return "discord_member_set_nickname";
        }

        public String docs() {
            return "void {[server], member, string} Set the server nickname for a member. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. Requires the `Manage Nicknames` permission and a role higher than the target member.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String newNickname;
            Member member;
            Discord.CheckConnection(t);
            if (args.length == 3) {
                member = Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t);
                newNickname = args[2].val();
            } else {
                member = Discord.GetMember(args[0], Discord.GetGuild(environment), t);
                newNickname = args[1].val();
            }
            try {
                member.modifyNickname(newNickname).queue(null, ex -> Discord.HandleFailure(ex, t));
            }
            catch (PermissionException ex2) {
                throw new CREInsufficientPermissionException(ex2.getMessage(), t);
            }
            catch (IllegalArgumentException ex3) {
                throw new CREIllegalArgumentException(ex3.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIllegalArgumentException.class, CREInsufficientPermissionException.class};
        }
    }

    @api
    public static class discord_member_get_nickname
    extends Discord.Function {
        public String getName() {
            return "discord_member_get_nickname";
        }

        public String docs() {
            return "string {[server], member} Get the server nickname for a member. (empty if not set) The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            Member member = args.length == 2 ? Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t) : Discord.GetMember(args[0], Discord.GetGuild(environment), t);
            return new CString(member.getNickname(), t);
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_private_message
    extends Discord.Function {
        public String getName() {
            return "discord_private_message";
        }

        public String docs() {
            return "void {user, message} Sends a private message to the specified Discord user. See discord_broadcast() for message format. Will fail if the user is not cached from one of the servers. Messages have a 2000-character limit.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            long referenceId;
            MessageCreateData data;
            Discord.CheckConnection(t);
            User usr = Discord.GetUser(args[0], t);
            Mixed message = args[1];
            try {
                if (message.isInstanceOf(CArray.TYPE)) {
                    CArray messageArray = (CArray)message;
                    data = Discord.CreateMessage(messageArray, null, t);
                    referenceId = messageArray.containsKey("reference_id") ? ArgumentValidation.getInt((Mixed)messageArray.get("reference_id", t), (Target)t) : 0L;
                } else {
                    data = ((MessageCreateBuilder)new MessageCreateBuilder().setContent(message.val())).build();
                    referenceId = 0L;
                }
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException(ex.getMessage(), t);
            }
            usr.openPrivateChannel().queue(channel -> {
                MessageCreateAction action = channel.sendMessage(data);
                if (referenceId != 0L) {
                    action.setMessageReference(referenceId);
                }
                action.queue(null, ex -> Discord.HandleFailure(ex, t));
                data.close();
            });
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIllegalArgumentException.class, CREFormatException.class};
        }
    }
}

