/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chdiscord.abstraction.jda;

import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import me.pseudoknight.chdiscord.Discord;
import me.pseudoknight.chdiscord.abstraction.jda.Events;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.events.guild.member.GuildMemberJoinEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import net.dv8tion.jda.api.events.guild.voice.GuildVoiceUpdateEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.NotNull;

public class Listener
extends ListenerAdapter {
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (Discord.jda == null || event.getAuthor().equals(Discord.jda.getSelfUser())) {
            return;
        }
        if (event.getChannelType() == ChannelType.PRIVATE) {
            Events.JDADiscordPrivateMessageReceivedEvent e = new Events.JDADiscordPrivateMessageReceivedEvent(event);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_private_message_received", (BindableEvent)e));
        } else if (event.isFromGuild()) {
            Events.JDADiscordGuildMessageReceivedEvent e = new Events.JDADiscordGuildMessageReceivedEvent(event);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_message_received", (BindableEvent)e));
        }
    }

    public void onMessageUpdate(@NotNull MessageUpdateEvent event) {
        if (!event.isFromGuild() || Discord.jda == null || event.getAuthor().equals(Discord.jda.getSelfUser())) {
            return;
        }
        Events.JDADiscordGuildMessageUpdatedEvent e = new Events.JDADiscordGuildMessageUpdatedEvent(event);
        StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_message_updated", (BindableEvent)e));
    }

    public void onMessageReactionAdd(@NotNull MessageReactionAddEvent event) {
        if (!event.isFromGuild() || Discord.jda == null || Discord.jda.getSelfUser().equals(event.getUser())) {
            return;
        }
        event.retrieveMember().queue(member -> {
            Events.JDADiscordReactionAddedEvent e = new Events.JDADiscordReactionAddedEvent(event, (Member)member);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_reaction_added", (BindableEvent)e));
        });
    }

    public void onMessageReactionRemove(@NotNull MessageReactionRemoveEvent event) {
        if (!event.isFromGuild() || Discord.jda == null || Discord.jda.getSelfUser().equals(event.getUser())) {
            return;
        }
        event.retrieveMember().queue(member -> {
            Events.JDADiscordReactionRemovedEvent e = new Events.JDADiscordReactionRemovedEvent(event, (Member)member);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_reaction_removed", (BindableEvent)e));
        });
    }

    public void onGuildVoiceUpdate(@NotNull GuildVoiceUpdateEvent event) {
        if (event.getChannelJoined() != null && event.getChannelLeft() == null) {
            Events.JDADiscordVoiceJoinedEvent e = new Events.JDADiscordVoiceJoinedEvent(event);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_voice_joined", (BindableEvent)e));
        } else if (event.getChannelLeft() != null && event.getChannelJoined() == null) {
            Events.JDADiscordVoiceLeftEvent e = new Events.JDADiscordVoiceLeftEvent(event);
            StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_voice_left", (BindableEvent)e));
        }
    }

    public void onGuildMemberJoin(@NotNull GuildMemberJoinEvent event) {
        Events.JDADiscordMemberJoinEvent e = new Events.JDADiscordMemberJoinEvent(event);
        StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_member_joined", (BindableEvent)e));
    }

    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        Events.JDADiscordMemberLeaveEvent e = new Events.JDADiscordMemberLeaveEvent(event);
        StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"discord_member_left", (BindableEvent)e));
    }
}

