/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chdiscord;

import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientPermissionException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.List;
import me.pseudoknight.chdiscord.Discord;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.utils.cache.MemberCacheView;

public class GuildFunctions {
    static final String SERVER_ARGUMENT = " The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server.";

    public static String docs() {
        return "Functions for managing a Discord server (guild).";
    }

    @api
    public static class discord_get_members_with_role
    extends Discord.Function {
        public String getName() {
            return "discord_get_members_with_role";
        }

        public String docs() {
            return "array {[server], role} Gets an array of cached members in this guild server with a given role. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. Array contains a list of user int ids. Members may not be cached immediately upon bot connection.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Role role;
            Guild guild;
            Discord.CheckConnection(t);
            if (args.length == 1) {
                guild = Discord.GetGuild(environment);
                role = Discord.GetRole(args[0], guild, t);
            } else {
                guild = Discord.GetGuild(args[0], t);
                role = Discord.GetRole(args[1], guild, t);
            }
            MemberCacheView memberCache = guild.getMemberCache();
            List members = memberCache.getElementsWithRoles(new Role[]{role});
            CArray array = new CArray(t, (int)memberCache.size());
            members.forEach(mem -> array.push((Mixed)new CInt(mem.getIdLong(), t), t));
            return array;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_get_members
    extends Discord.Function {
        public String getName() {
            return "discord_get_members";
        }

        public String docs() {
            return "array {[server]} Gets an array of all cached members in this guild server. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. Array contains a list of user int ids. Members may not be cached immediately upon bot connection.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            Guild guild = args.length == 1 ? Discord.GetGuild(args[0], t) : Discord.GetGuild(environment);
            MemberCacheView memberCache = guild.getMemberCache();
            CArray array = new CArray(t, (int)memberCache.size());
            memberCache.forEach(mem -> array.push((Mixed)new CInt(mem.getIdLong(), t), t));
            return array;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class};
        }
    }

    @api
    public static class discord_retrieve_invites
    extends Discord.Function {
        public String getName() {
            return "discord_retrieve_invites";
        }

        public String docs() {
            return "void {[server], closure} Retrieves an array of invite arrays for this guild server. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. Passes the array to the callback closure. Each invite array contains data about the invite, which has the keys 'code',  'channelid', inviter 'userid', 'uses' and 'max_uses'. Requires the `Manage Server` permission.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Guild guild;
            Discord.CheckConnection(t);
            int callbackIndex = 0;
            if (args.length == 2) {
                guild = Discord.GetGuild(args[0], t);
                callbackIndex = 1;
            } else {
                guild = Discord.GetGuild(environment);
            }
            CClosure closure = (CClosure)args[callbackIndex];
            try {
                guild.retrieveInvites().queue(list -> {
                    CArray array = new CArray(t);
                    for (Invite invite : list) {
                        User inviter;
                        CArray inviteArray = CArray.GetAssociativeArray((Target)t);
                        inviteArray.set("code", invite.getCode());
                        Invite.Channel channel = invite.getChannel();
                        if (channel != null) {
                            inviteArray.set("channelid", (Mixed)new CInt(channel.getIdLong(), t), t);
                        }
                        if ((inviter = invite.getInviter()) != null) {
                            inviteArray.set("userid", (Mixed)new CInt(inviter.getIdLong(), t), t);
                        }
                        if (invite.isExpanded()) {
                            inviteArray.set("uses", (Mixed)new CInt((long)invite.getUses(), t), t);
                            inviteArray.set("max_uses", (Mixed)new CInt((long)invite.getMaxUses(), t), t);
                        }
                        array.push((Mixed)inviteArray, t);
                    }
                    StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> closure.executeCallable(new Mixed[]{array}));
                });
            }
            catch (PermissionException ex) {
                throw new CREInsufficientPermissionException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class};
        }
    }

    @api
    public static class discord_member_move_voice_channel
    extends Discord.Function {
        public String getName() {
            return "discord_member_move_voice_channel";
        }

        public String docs() {
            return "void {[server], member, channel} Moves a member to another voice channel. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. The member must already be connected to a voice channel in the guild. The `channel` argument can be a channel's unique int id. A channel's exact name can also be used, but if it's not unique, the first matching channel will be used. If a channel is omitted, it will attempt to use the channel from the event bind context. If not in an event bind, it will use the default channel. Throws IllegalArgumentException if member is not connected to a voice channel. Throws InsufficientPermissionException if the member and bot do not have access to the destination channel. Requires the `Move Members` permission.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            VoiceChannel channel;
            Member member;
            Guild guild;
            Discord.CheckConnection(t);
            if (args.length == 2) {
                guild = Discord.GetGuild(environment);
                member = Discord.GetMember(args[0], guild, t);
                channel = Discord.GetVoiceChannel(args[1], guild, t);
            } else {
                guild = Discord.GetGuild(args[0], t);
                member = Discord.GetMember(args[1], guild, t);
                channel = Discord.GetVoiceChannel(args[2], guild, t);
            }
            try {
                guild.moveVoiceMember(member, (AudioChannel)channel).queue(null, ex -> Discord.HandleFailure(ex, t));
            }
            catch (PermissionException ex2) {
                throw new CREInsufficientPermissionException(ex2.getMessage(), t);
            }
            catch (IllegalArgumentException | IllegalStateException ex3) {
                throw new CREIllegalArgumentException(ex3.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_member_set_roles
    extends Discord.Function {
        public String getName() {
            return "discord_member_set_roles";
        }

        public String docs() {
            return "void {[server], member, role(s), [reason]} Sets the roles for a server member. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. The role argument can be an array or a single role. A role is either a unique int id or name. Optional reason string is supported. Throws NotFoundException if a role by that name doesn't exist. Requires the `Manage Roles` permission and a role higher than any set roles.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3, 4};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Member mem;
            Guild guild;
            Discord.CheckConnection(t);
            String reason = null;
            ArrayList<Role> roles = new ArrayList<Role>();
            int rolesIndex = 1;
            if (args.length == 4) {
                guild = Discord.GetGuild(args[0], t);
                mem = Discord.GetMember(args[1], guild, t);
                rolesIndex = 2;
                reason = args[3].val();
            } else if (args.length == 3) {
                if (args[2].isInstanceOf(CArray.TYPE)) {
                    guild = Discord.GetGuild(args[0], t);
                    mem = Discord.GetMember(args[1], guild, t);
                    rolesIndex = 2;
                } else if (args[1].isInstanceOf(CArray.TYPE)) {
                    guild = Discord.GetGuild(environment);
                    mem = Discord.GetMember(args[0], guild, t);
                    reason = args[2].val();
                } else {
                    try {
                        guild = Discord.GetGuild(args[0], t);
                        mem = Discord.GetMember(args[1], guild, t);
                        rolesIndex = 2;
                    }
                    catch (CRENotFoundException ex2) {
                        guild = Discord.GetGuild(environment);
                        mem = Discord.GetMember(args[0], guild, t);
                        reason = args[2].val();
                    }
                }
            } else {
                guild = Discord.GetGuild(environment);
                mem = Discord.GetMember(args[0], guild, t);
            }
            if (args[rolesIndex].isInstanceOf(CArray.TYPE)) {
                CArray ca = (CArray)args[rolesIndex];
                for (Mixed key : ca.keySet()) {
                    roles.add(Discord.GetRole(ca.get(key, t), guild, t));
                }
            } else {
                roles.add(Discord.GetRole(args[rolesIndex], guild, t));
            }
            try {
                guild.modifyMemberRoles(mem, roles).reason(reason).queue(null, ex -> Discord.HandleFailure(ex, t));
            }
            catch (PermissionException ex3) {
                throw new CREInsufficientPermissionException(ex3.getMessage(), t);
            }
            catch (IllegalArgumentException ex4) {
                throw new CREIllegalArgumentException(ex4.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREInsufficientPermissionException.class, CREIllegalArgumentException.class};
        }
    }

    @api
    public static class discord_member_get_roles
    extends Discord.Function {
        public String getName() {
            return "discord_member_get_roles";
        }

        public String docs() {
            return "array {[server], member} Gets an associative array of all server roles for a member. The `server` argument is the guild server's unique int id. It is always optional and will fall back to event bind context or the default server. The `member` argument is a user's unique int id (or username). Throws NotFoundException if a member by that id doesn't exist. The key is the role name, and the value is the role numeric id. Throws NotFoundException if a member by that name doesn't exist.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Discord.CheckConnection(t);
            Member mem = args.length == 2 ? Discord.GetMember(args[1], Discord.GetGuild(args[0], t), t) : Discord.GetMember(args[0], Discord.GetGuild(environment), t);
            CArray roles = CArray.GetAssociativeArray((Target)t);
            for (Role role : mem.getRoles()) {
                roles.set(role.getName(), (Mixed)new CInt(role.getIdLong(), t), t);
            }
            return roles;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class};
        }
    }
}

