/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chdynmap.core.events;

import com.hekta.chdynmap.abstraction.events.MCDynmapWebChatEvent;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.CRE.CREBindException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Map;

public class DynmapEvents {
    public static String docs() {
        return "Contains events related to the Dynmap plugin";
    }

    @api
    public static class dm_player_web_chat
    extends AbstractEvent {
        public String getName() {
            return "dm_player_web_chat";
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            throw new CREBindException("This operation is not supported.", t);
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public String docs() {
            return "{name: <macro> | processed: <boolean match> | source: <macro>} Fires when a player send a message on the Dynmap. {message: the message the player sent | name: the name of the sender | processed: returns if the event has been handled by a plugin | source: from where the message is sent} {} {}";
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof MCDynmapWebChatEvent) {
                MCDynmapWebChatEvent wce = (MCDynmapWebChatEvent)event;
                Prefilters.match(prefilter, (String)"source", (String)wce.getSource(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"name", (String)wce.getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"processed", (boolean)wce.isProcessed(), (Prefilters.PrefilterType)Prefilters.PrefilterType.BOOLEAN_MATCH);
                return true;
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof MCDynmapWebChatEvent) {
                Map eventMap = this.evaluate_helper(event);
                MCDynmapWebChatEvent wce = (MCDynmapWebChatEvent)event;
                eventMap.put("source", new CString(wce.getSource(), Target.UNKNOWN));
                eventMap.put("name", new CString(wce.getName(), Target.UNKNOWN));
                eventMap.put("message", new CString(wce.getMessage(), Target.UNKNOWN));
                eventMap.put("processed", CBoolean.get((boolean)wce.isProcessed()));
                return eventMap;
            }
            throw new EventException("Cannot convert to CHDynmapWebChatEvent.");
        }
    }
}

