/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chdynmap.core.functions;

import com.hekta.chdynmap.core.CHDynmapStatic;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;

public class DynmapPlayers {
    public static String docs() {
        return "A class of functions using the Dynmap features for players.";
    }

    @api
    public static class dm_post_pquit
    extends DynmapPlayerGetterFunction {
        public String getName() {
            return "dm_post_pquit";
        }

        public String docs() {
            return "void {[playerName]} Post a quit message for player to web. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String displayName;
            MCPlayer player;
            if (args.length == 0) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                displayName = psender.getDisplayName();
            } else {
                MCPlayer mcplayer = Static.getServer().getPlayer(args[0].val());
                if (mcplayer == null) {
                    player = Static.getServer().getOfflinePlayer(args[0].val());
                    displayName = player.getName();
                } else {
                    player = mcplayer;
                    displayName = mcplayer.getDisplayName();
                }
            }
            CHDynmapStatic.getDynmapAPI(t).postPlayerQuitToWeb((MCOfflinePlayer)player, displayName);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_post_pjoin
    extends DynmapPlayerGetterFunction {
        public String getName() {
            return "dm_post_pjoin";
        }

        public String docs() {
            return "void {[playerName]} Post a join message for player to web. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String displayName;
            MCPlayer player;
            if (args.length == 0) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                displayName = psender.getDisplayName();
            } else {
                MCPlayer mcplayer = Static.getServer().getPlayer(args[0].val());
                if (mcplayer == null) {
                    player = Static.getServer().getOfflinePlayer(args[0].val());
                    displayName = player.getName();
                } else {
                    player = mcplayer;
                    displayName = mcplayer.getDisplayName();
                }
            }
            CHDynmapStatic.getDynmapAPI(t).postPlayerJoinToWeb((MCOfflinePlayer)player, displayName);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_post_pchat
    extends DynmapPlayerFunction {
        public String getName() {
            return "dm_post_pchat";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "void {[playerName], message | playerName, message, [displayName]} Post message from player to web, if displayName is an empty string, it is not noticed. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String message;
            String displayName;
            MCPlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                displayName = psender.getDisplayName();
                message = args[0].val();
            } else if (args.length == 2) {
                MCPlayer mcplayer = Static.getServer().getPlayer(args[0].val());
                if (mcplayer == null) {
                    player = Static.getServer().getOfflinePlayer(args[0].val());
                    displayName = player.getName();
                } else {
                    player = mcplayer;
                    displayName = mcplayer.getDisplayName();
                }
                message = args[1].val();
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                displayName = args[2].val();
                message = args[1].val();
            }
            CHDynmapStatic.getDynmapAPI(t).postPlayerMessageToWeb((MCOfflinePlayer)player, displayName, message);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_pcan_see
    extends DynmapPlayerGetterFunction {
        public String getName() {
            return "dm_pcan_see";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], otherPlayerName} Returns if the player can see the other player. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCOfflinePlayer otherPlayer;
            MCOfflinePlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                otherPlayer = Static.getServer().getOfflinePlayer(args[0].val());
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                otherPlayer = Static.getServer().getOfflinePlayer(args[1].val());
            }
            return CBoolean.get((boolean)CHDynmapStatic.getDynmapAPI(t).testIfPlayerVisibleToPlayer(player, otherPlayer));
        }
    }

    @api
    public static class dm_assert_pinvisibility
    extends DynmapPlayerFunction {
        public String getName() {
            return "dm_assert_pinvisibility";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "void {[playerName], boolean | playerName, boolean, [pluginID]} Asserts the player invisibility (transient, if player is configured to be hidden, it is made visibile if one or more plugins assert its visibility), pluginID is the id that will be used to assert, default to 'CommandHelper'. This will not throw a PlayerOfflineException (exept from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String plugin;
            boolean isInvisible;
            MCPlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                isInvisible = ArgumentValidation.getBooleanObject((Mixed)args[0], (Target)t);
                plugin = "CommandHelper";
            } else if (args.length == 2) {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                isInvisible = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
                plugin = "CommandHelper";
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                isInvisible = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
                plugin = args[2].val();
            }
            CHDynmapStatic.getDynmapAPI(t).assertPlayerInvisibility((MCOfflinePlayer)player, isInvisible, plugin);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_assert_pvisibility
    extends DynmapPlayerFunction {
        public String getName() {
            return "dm_assert_pvisibility";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "void {[playerName], boolean | playerName, boolean, [pluginID]} Asserts the player visibility (transient, if player is configured to be visible, it is made hidden if one or more plugins assert its invisibility), pluginID is the id that will be used to assert, default to 'CommandHelper'. This will not throw a PlayerOfflineException (exept from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String plugin;
            boolean isVisible;
            MCPlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                isVisible = ArgumentValidation.getBooleanObject((Mixed)args[0], (Target)t);
                plugin = "CommandHelper";
            } else if (args.length == 2) {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                isVisible = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
                plugin = "CommandHelper";
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                isVisible = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
                plugin = args[2].val();
            }
            CHDynmapStatic.getDynmapAPI(t).assertPlayerVisibility((MCOfflinePlayer)player, isVisible, plugin);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_set_pvisible
    extends DynmapPlayerFunction {
        public String getName() {
            return "dm_set_pvisible";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "void {[playerName], boolean} Sets if the player is visible on the Dynmap. This will not throw a PlayerOfflineException (exept from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean isVisible;
            MCOfflinePlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                isVisible = ArgumentValidation.getBooleanObject((Mixed)args[0], (Target)t);
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
                isVisible = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            }
            CHDynmapStatic.getDynmapAPI(t).setPlayerVisiblity(player, isVisible);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_pvisible
    extends DynmapPlayerGetterFunction {
        public String getName() {
            return "dm_pvisible";
        }

        public String docs() {
            return "boolean {[playerName]} Returns if the player is visible on the Dynmap. This will not throw a PlayerOfflineException (exept from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCOfflinePlayer player;
            if (args.length == 0) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
            } else {
                player = Static.getServer().getOfflinePlayer(args[0].val());
            }
            return CBoolean.get((boolean)CHDynmapStatic.getDynmapAPI(t).getPlayerVisbility(player));
        }
    }

    public static abstract class DynmapPlayerGetterFunction
    extends DynmapPlayerFunction {
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class};
        }
    }

    public static abstract class DynmapPlayerFunction
    extends AbstractFunction {
        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

