/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.chfile.chfunctions;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CRESecurityException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.chfile.LifeCycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPOutputStream;

public class CHFileHandling {
    public static void checkSecurity(File file, Environment env, Target t) throws CRESecurityException, CREIOException {
        try {
            if (!Static.InCmdLine((Environment)env, (boolean)false) && !Security.CheckSecurity((File)file)) {
                throw new CRESecurityException("You do not have permission to access file: '" + file.getAbsolutePath() + "'", t);
            }
        }
        catch (IOException e) {
            throw new CREIOException(e.getMessage(), t);
        }
    }

    @api
    public static class chf_write_binary
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            CByteArray content = ArgumentValidation.getByteArray((Mixed)args[1], (Target)t);
            boolean overwrite = args.length >= 3 && ArgumentValidation.getBooleanish((Mixed)args[2], (Target)t);
            CHFileHandling.checkSecurity(location, env, t);
            if (!overwrite && location.exists()) {
                throw new CRESecurityException("The file already exists and the overwrite option is false: '" + location.getAbsolutePath() + "'.", t);
            }
            location.getParentFile().mkdirs();
            try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(location));){
                ((OutputStream)outStream).write(content.asByteArrayCopy());
            }
            catch (IOException e) {
                throw new CREIOException("Could not write to file. Message: " + e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {path, content, [overwrite]} Writes the given byte array to the file at the given path. Required parent directories will be created if necessary. If the file already exists and overwrite is false, a SecurityException is thrown. Overwrite defaults to false. The path is relative to the file that is being run, not CommandHelper. If the content is not a byte_array, a CastException is thrown. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown. If the writing itself fails, an IOException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRESecurityException.class, CREIOException.class, CREFormatException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_write_gzip_binary
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            CByteArray content = ArgumentValidation.getByteArray((Mixed)args[1], (Target)t);
            boolean overwrite = args.length >= 3 && ArgumentValidation.getBooleanish((Mixed)args[2], (Target)t);
            CHFileHandling.checkSecurity(location, env, t);
            if (!overwrite && location.exists()) {
                throw new CRESecurityException("The file already exists and the overwrite option is false: '" + location.getAbsolutePath() + "'.", t);
            }
            location.getParentFile().mkdirs();
            try (GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(location));){
                ((OutputStream)outStream).write(content.asByteArrayCopy());
            }
            catch (IOException e) {
                throw new CREIOException("Could not write to file. Message: " + e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {path, content, [overwrite]} Gzips and writes the given byte array to the file at the given path. Required parent directories will be created if necessary. If the file already exists and overwrite is false, a SecurityException is thrown. Overwrite defaults to false. The path is relative to the file that is being run, not CommandHelper. If the content is not a byte_array, a CastException is thrown. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown. If the writing itself fails, an IOException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRESecurityException.class, CREIOException.class, CREFormatException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_write
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            OpenOption[] options;
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            String content = args[1].val();
            String writeOption = args.length < 3 ? null : args[2].val();
            CHFileHandling.checkSecurity(location, env, t);
            if (writeOption == null) {
                if (location.exists()) {
                    throw new CRESecurityException("The file already exists and no OVERWRITE option has been given: '" + location.getAbsolutePath() + "'.", t);
                }
                options = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW};
            } else if (writeOption.equalsIgnoreCase("APPEND")) {
                options = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            } else if (writeOption.equalsIgnoreCase("OVERWRITE")) {
                options = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            } else {
                throw new CREFormatException("Argument 3 of " + this.getName() + " has to be one of 'OVERWRITE' or 'APPEND'.", t);
            }
            location.getParentFile().mkdirs();
            try {
                Files.write(location.toPath(), content.getBytes(), options);
            }
            catch (IOException e) {
                throw new CREIOException("Could not write to file. Message: " + e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {path, content, [option]} Writes the given content to the file at the given path. The option can be one of OVERWRITE/APPEND. Required parent directories will be created if necessary. If the file already exists and no option is given, a SecurityException is thrown. The path is relative to the file that is being run, not CommandHelper. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown. If the writing itself fails, an IOException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class, CREFormatException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_create_directory
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            boolean createRequiredDirs = args.length == 2 && ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            CHFileHandling.checkSecurity(location, env, t);
            if (location.exists()) {
                if (location.isDirectory()) {
                    return CVoid.VOID;
                }
                throw new CREIOException("Cannot create directory with the same name as a file in the same directory: '" + location + "'", t);
            }
            File parentFile = location.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                if (!createRequiredDirs) {
                    throw new CRESecurityException("The directory in which the directory would be created does not exist and createRequiredDirs is not enabled: '" + location.getAbsolutePath() + "'", t);
                }
                if (!parentFile.mkdirs()) {
                    throw new CREIOException("Could not create (some) directory(ies) of: '" + location.getAbsolutePath() + "'", t);
                }
            }
            if (!location.mkdir()) {
                throw new CREIOException("Could not create directory at: '" + location.getAbsolutePath() + "'", t);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {path, [createRequiredDirs]} Creates a directory at the given path. If createRequiredDirs is true, required parent directories will be created. Defaults to false. The path is relative to the file that is being run, not CommandHelper. Throws a SecurityException if createRequiredDirs is false and the parent directory of the given path does not exist. Throws an IOException if the file or required directories could not be created. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_create_file
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            boolean createRequiredDirs = args.length == 2 && ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            CHFileHandling.checkSecurity(location, env, t);
            if (location.exists()) {
                throw new CREIOException("The given file already exists: '" + location.getAbsolutePath() + "'", t);
            }
            if (!location.getParentFile().exists()) {
                if (!createRequiredDirs) {
                    throw new CRESecurityException("The directory in which the file would be created does not exist and createRequiredDirs is not enabled: '" + location.getAbsolutePath() + "'", t);
                }
                if (!location.getParentFile().mkdirs()) {
                    throw new CREIOException("Could not create directory: '" + location.getParentFile().getAbsolutePath() + "'", t);
                }
            }
            try {
                location.createNewFile();
            }
            catch (IOException e) {
                throw new CREIOException("Could not create file at: '" + location.getAbsolutePath() + "'. Message: " + e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {path, [createRequiredDirs]} Creates a file at the given path. If createRequiredDirs is true, required parent directories will be created. Defaults to false. The path is relative to the file that is being run, not CommandHelper. Throws a SecurityException if createRequiredDirs is false and the parent directory of the given path does not exist. Throws an IOException if the file or required directories could not be created. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_delete
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            boolean allowRemoveDirContent = args.length == 2 && ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            CHFileHandling.checkSecurity(location, env, t);
            if (!location.exists()) {
                throw new CREIOException("The given file does not exist: '" + location.getAbsolutePath() + "'", t);
            }
            if (!allowRemoveDirContent && location.isDirectory() && location.listFiles().length != 0) {
                throw new CRESecurityException("The given file is a non-empty directory and allowRemoveFolderContent is not enabled: '" + location.getAbsolutePath() + "'", t);
            }
            if (!chf_delete.deleteFile(location)) {
                throw new CREIOException("Could not delete (some) file(s) from: '" + location.getAbsolutePath() + "'", t);
            }
            return CVoid.VOID;
        }

        private static boolean deleteFile(File file) {
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory()) {
                boolean success = true;
                for (File subFile : file.listFiles()) {
                    if (chf_delete.deleteFile(subFile)) continue;
                    success = false;
                }
                return success && file.delete();
            }
            return false;
        }

        public String docs() {
            return "void {path, [allowRemoveDirContent]} Deletes the file or directory at the given path. The path is relative to the file that is being run, not CommandHelper. If allowRemoveDirContent is true, directory contents will be removed if a non-empty directory is given. Defaults to false. Throws a SecurityException If allowRemoveDirContent is false and the given file is a non-empty directory. Throws an IOException if the file does not exist or (a part of the files) could not be removed. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_copy
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{2, 3, 4};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File locationFrom = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            File locationTo = Static.GetFileFromArgument((String)args[1].val(), (Environment)env, (Target)t, null);
            boolean overWrite = args.length >= 3 && ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
            boolean createTargetDirs = args.length == 4 && ArgumentValidation.getBooleanObject((Mixed)args[3], (Target)t);
            CHFileHandling.checkSecurity(locationFrom, env, t);
            CHFileHandling.checkSecurity(locationTo, env, t);
            if (locationFrom.getAbsolutePath().equals(locationTo.getAbsolutePath())) {
                throw new CREIOException("Cannot copy file or directory to itself: '" + locationFrom.getAbsolutePath() + "'", t);
            }
            if (!locationFrom.exists()) {
                throw new CREIOException("File or directory at 'fromPath' does not exist: '" + locationFrom.getAbsolutePath() + "'", t);
            }
            File locationToParent = locationTo.getParentFile();
            if (locationToParent != null && !locationToParent.exists()) {
                if (!createTargetDirs) {
                    throw new CREIOException("Target directory does not exist: '" + locationToParent.getAbsolutePath() + "'", t);
                }
                if (!locationToParent.mkdirs()) {
                    throw new CREIOException("Could not create directory: '" + locationToParent.getAbsolutePath() + "'", t);
                }
            }
            if (locationFrom.isFile()) {
                try {
                    chf_copy.copyFile(locationFrom, locationTo, overWrite, t);
                }
                catch (IOException e) {
                    throw new CREIOException("Could not copy file from: '" + locationFrom.getAbsolutePath() + "' to: '" + locationTo.getAbsolutePath() + "'. Message: " + e.getMessage(), t);
                }
            }
            try {
                if (!locationTo.exists() && !locationTo.mkdir()) {
                    throw new CREIOException("Could not create directory: '" + locationToParent.getAbsolutePath() + "'", t);
                }
                for (File fromFile : locationFrom.listFiles()) {
                    File toFile = new File(locationTo, fromFile.getName());
                    chf_copy.copyFile(fromFile, toFile, overWrite, t);
                }
            }
            catch (IOException e) {
                throw new CREIOException("Could not copy (some) file(s) from: '" + locationFrom.getAbsolutePath() + "' to: '" + locationTo.getAbsolutePath() + "'. Message: " + e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        private static void copyFile(File from, File to, boolean overWrite, Target t) throws IOException, CRESecurityException {
            if (from.isFile()) {
                if (!overWrite && to.isFile()) {
                    throw new CRESecurityException("Cannot overwrite existing file (overwrite parameter is false): '" + to.getAbsolutePath() + "'", t);
                }
                Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else if (from.isDirectory()) {
                if (!to.isDirectory() && !to.mkdir()) {
                    throw new IOException("Could not create directory: '" + to.getAbsolutePath() + "'.");
                }
                for (File subFrom : from.listFiles()) {
                    File subTo = new File(to.getAbsoluteFile(), subFrom.getName());
                    if (!overWrite && subTo.isFile()) {
                        throw new CRESecurityException("Cannot overwrite existing file (overwrite parameter is false): '" + subTo.getAbsolutePath() + "'", t);
                    }
                    chf_copy.copyFile(subFrom, subTo, overWrite, t);
                }
            }
        }

        public String docs() {
            return "void {fromPath, toPath, [allowOverwrite], [createRequiredDirs]} Copies the file or directory (including contents) from the fromPath to the toPath. When copying a directory which's target already exists, it will be merged with the existing directory. This also holds for subdirectories. toPath should contain the file or directory name of the copy, and not just the directory in which to place the copy. If allowOverwrite is true, files will overwrite the file at their target location if they already exist. Defaults to false. If createRequiredDirs is true, the parent directory of toPath will be created if it does not yet exist. Defaults to false. The paths are relative to the file that is being run, not CommandHelper. Throws a SecurityException if allowOverwrite is false and the file at toPath already exists and is not a directory. Throws an IOException if createRequiredDirs is false and the parent directory of toPath does not exist. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_is_directory
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            CHFileHandling.checkSecurity(location, env, t);
            return CBoolean.GenerateCBoolean((boolean)location.isDirectory(), (Target)t);
        }

        public String docs() {
            return "boolean {path} Returns whether the file at the given path is a directory. The path is relative to the file that is being run, not CommandHelper. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_file_exists
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            CHFileHandling.checkSecurity(location, env, t);
            return CBoolean.GenerateCBoolean((boolean)location.exists(), (Target)t);
        }

        public String docs() {
            return "boolean {path} Returns whether the file or directory at the given path exists. The path is relative to the file that is being run, not CommandHelper. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class chf_directory_list
    extends LifeCycle.FileFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File location = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            CHFileHandling.checkSecurity(location, env, t);
            if (!location.exists()) {
                throw new CREIOException("Directory at location does not exist: " + location.getAbsolutePath() + ".", t);
            }
            if (!location.isDirectory()) {
                throw new CREIOException("File at location is not a directory: " + location.getAbsolutePath() + ".", t);
            }
            CArray ret = new CArray(t);
            for (String content : location.list()) {
                ret.push((Mixed)new CString(content, t), t);
            }
            return ret;
        }

        public String docs() {
            return "array {directory} Returns an array containing all files and directories in the given directory. The path is relative to the file that is being run, not CommandHelper. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESecurityException.class, CREIOException.class};
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

