/*
 * Decompiled with CFR 0.152.
 */
package me.macjuul.chfiles;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.SSHWrapper;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CRESecurityException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.libs.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class FileFunctions {
    public static String docs() {
        return "A set of functions for interacting with files and directories.";
    }

    @api
    public static class file_last_modified
    extends FileFunction {
        public String getName() {
            return "file_last_modified";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "int {file} Returns the time a file was last modified as a unix time stamp. Will return 0 if the file does not exist or an I/O error occurs.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
                return new CInt(loc.lastModified(), t);
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class write_file
    extends FileFunction {
        public String getName() {
            return "write_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3, 4};
        }

        public String docs() {
            return "void {file, content, [mode]} Writes text to a file. Accepts a byte array or a string as the content. The mode parameter can be OVERWRITE or APPEND.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
                if (!loc.exists()) {
                    loc.createNewFile();
                }
                byte[] content = args[1].isInstanceOf(CByteArray.TYPE) ? ArgumentValidation.getByteArray((Mixed)args[1], (Target)t).asByteArrayCopy() : args[1].val().getBytes(StandardCharsets.UTF_8);
                if (args.length >= 3 && args[2].val().equalsIgnoreCase("OVERWRITE")) {
                    FileUtil.write((byte[])content, (File)loc, (int)0, (boolean)false);
                } else {
                    FileUtil.write((byte[])content, (File)loc, (int)1, (boolean)false);
                }
                return CVoid.VOID;
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class ungz_file
    extends FileFunction {
        public String getName() {
            return "ungz_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {gzfile, tofile} Unzip a file and write it to another file.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File gz = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            File tofile = Static.GetFileFromArgument((String)args[1].val(), (Environment)env, (Target)t, null);
            try {
                int length;
                if (!(Static.InCmdLine((Environment)env, (boolean)true) || Security.CheckSecurity((File)gz) && Security.CheckSecurity((File)tofile))) {
                    throw new CRESecurityException("You do not have access to some of the files", t);
                }
                FileInputStream fis = new FileInputStream(gz);
                GZIPInputStream gzis = new GZIPInputStream(fis);
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(tofile);
                while ((length = gzis.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
                gzis.close();
                fis.close();
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class};
        }
    }

    @api
    public static class rename_file
    extends FileFunction {
        public String getName() {
            return "rename_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {file, name} Renames a file.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            if (!loc.exists()) {
                throw new CREIOException(loc.getAbsolutePath() + " doesn't exist", t);
            }
            if (loc.isDirectory()) {
                loc.renameTo(new File(loc.getParent() + File.separator + args[1].val() + File.separator));
            } else if (loc.isFile()) {
                loc.renameTo(new File(loc.getParent() + File.separator + args[1].val()));
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class list_files
    extends FileFunction {
        public String getName() {
            return "list_files";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "array {dir} Lists all files and directories in given directory";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            CArray ret = new CArray(t);
            if (loc.exists() && loc.isDirectory()) {
                String[] list;
                for (String file : list = loc.list()) {
                    ret.push((Mixed)new CString(file, t), t);
                }
            } else {
                throw new CREIOException("This path is not a directory.", t);
            }
            return ret;
        }
    }

    @api
    public static class is_file
    extends FileFunction {
        public String getName() {
            return "is_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {path} Checks if a path is a file.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            return CBoolean.get((boolean)loc.isFile());
        }
    }

    @api
    public static class is_dir
    extends FileFunction {
        public String getName() {
            return "is_dir";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {path} Checks if a path is a directory.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            return CBoolean.get((boolean)loc.isDirectory());
        }
    }

    @api
    public static class get_absolute_path
    extends FileFunction {
        public String getName() {
            return "get_absolute_path";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "string {[file]} Gets the absolute path of a file, or this script file if none is specified.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String path = args.length == 0 ? t.file().getParentFile().getAbsolutePath() : Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null).getAbsolutePath();
            return new CString(path, t);
        }
    }

    @api
    public static class file_exists
    extends FileFunction {
        public String getName() {
            return "file_exists";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {path} Check if a file exists.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            return CBoolean.get((boolean)loc.exists());
        }
    }

    @api
    public static class delete_file
    extends FileFunction {
        public String getName() {
            return "delete_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {file} Deletes a file or directory.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
                if (!loc.exists()) {
                    throw new CREIOException(loc.getAbsolutePath() + "Doesn't exists", t);
                }
                if (loc.isDirectory()) {
                    FileUtils.deleteDirectory((File)loc);
                } else if (loc.isFile()) {
                    FileUtils.forceDelete((File)loc);
                }
                return CVoid.VOID;
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class create_file
    extends FileFunction {
        public String getName() {
            return "create_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {file} Creates a new file.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
                if (loc.exists()) {
                    throw new CREIOException(loc.getAbsolutePath() + " already exists", t);
                }
                loc.createNewFile();
                return CVoid.VOID;
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class create_dir
    extends FileFunction {
        public String getName() {
            return "create_dir";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {dir} Create a new directory.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc.getAbsolutePath() + "'", t);
                }
                if (loc.exists()) {
                    throw new CREIOException(loc.getAbsolutePath() + "Already Exists", t);
                }
                loc.mkdir();
                return CVoid.VOID;
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class copy_file
    extends FileFunction {
        public String getName() {
            return "copy_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {file, dir | dir, dir} Copies a file or directory to another directory.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File fromLoc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            File toLoc = Static.GetFileFromArgument((String)args[1].val(), (Environment)env, (Target)t, null);
            try {
                if (!(Static.InCmdLine((Environment)env, (boolean)true) || Security.CheckSecurity((File)fromLoc) && Security.CheckSecurity((File)toLoc))) {
                    throw new CRESecurityException("You do not have access to some of the files", t);
                }
                if (fromLoc.isDirectory()) {
                    FileUtils.copyDirectory((File)fromLoc, (File)toLoc);
                } else if (fromLoc.isFile()) {
                    FileUtils.copyFile((File)fromLoc, (File)toLoc);
                }
                return CVoid.VOID;
            }
            catch (IOException e) {
                throw new CREIOException(e.getMessage(), t);
            }
        }
    }

    @api
    public static class async_write_file
    extends FileFunction {
        public String getName() {
            return "async_write_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3, 4};
        }

        public String docs() {
            return "void {file, string, [mode], [callback]} Writes text to a file asynchronously. The mode parameter can be OVERWRITE or APPEND. The optional callback must be a closure. It will be executed upon write completion.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            File loc = Static.GetFileFromArgument((String)args[0].val(), (Environment)env, (Target)t, null);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((File)loc)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + loc + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            new Thread(() -> {
                try {
                    if (!loc.exists()) {
                        loc.createNewFile();
                    }
                    if (args.length >= 3 && args[2].val().equalsIgnoreCase("OVERWRITE")) {
                        FileUtil.write((String)args[1].val(), (File)loc, (int)0);
                    } else {
                        FileUtil.write((String)args[1].val(), (File)loc, (int)1);
                    }
                    if (args.length >= 4) {
                        CClosure closure = (CClosure)ArgumentValidation.getObject((Mixed)args[3], (Target)t, CClosure.class);
                        StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> closure.executeCallable(new Mixed[0]));
                    }
                }
                catch (IOException e) {
                    throw new CREIOException("File could not be written.", t);
                }
            }).start();
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class, CRESecurityException.class, CRECastException.class};
        }
    }

    @api
    public static class async_read_file
    extends FileFunction {
        public String getName() {
            return "async_read_file";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {file, callback} Asynchronously reads in a file. ----  This may be a remote file accessed with an SCP style path. (See the [[CommandHelper/SCP|wiki article]] about SCP credentials for more information.) If the file is not found, or otherwise can't be read in, an IOException is thrown. If the file specified is not within base-dir (as specified in the preferences file), a SecurityException is thrown. (This is not applicable for remote files) The line endings for the string returned will always be \\n, even if they originally were \\r\\n. This method will immediately return, and asynchronously read in the file, and finally send the contents to the callback once the task completes. The callback should have the following signature: closure(@contents, @exception){ &lt;code&gt; }. If @contents is null, that indicates that an exception occurred, and @exception will not be null, but instead have an exception array. Otherwise, @contents will contain the file's contents, and @exception will be null. This method is useful to use in two cases, either you need a remote file via SCP, or a local file is big enough that you notice a delay when simply using the read() function.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String file = args[0].val();
            if (!(args[1] instanceof CClosure)) {
                throw new CRECastException("Expected parameter 2 of " + this.getName() + " to be a closure!", t);
            }
            CClosure callback = (CClosure)ArgumentValidation.getObject((Mixed)args[1], (Target)t, CClosure.class);
            try {
                if (!Static.InCmdLine((Environment)env, (boolean)true) && !Security.CheckSecurity((String)file)) {
                    throw new CRESecurityException("You do not have permission to access the file '" + file + "'", t);
                }
            }
            catch (Exception e) {
                throw new CREIOException(e.getMessage(), t);
            }
            new Thread(() -> {
                String returnString = null;
                CREIOException exception = null;
                if (file.contains("@")) {
                    try {
                        returnString = SSHWrapper.SCPReadString((String)file);
                    }
                    catch (IOException ex) {
                        exception = new CREIOException(ex.getMessage(), t, (Throwable)ex);
                    }
                } else {
                    try {
                        File _file = Static.GetFileFromArgument((String)file, (Environment)env, (Target)t, null);
                        returnString = FileUtil.read((File)_file);
                    }
                    catch (IOException ex) {
                        exception = new CREIOException(ex.getMessage(), t, (Throwable)ex);
                    }
                }
                Object cret = returnString == null ? CNull.NULL : new CString(returnString, t);
                Object cex = exception == null ? CNull.NULL : ObjectGenerator.GetGenerator().exception((ConfigRuntimeException)exception, env, t);
                StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> async_read_file.lambda$exec$0(callback, (Mixed)cret, (Mixed)cex));
            }).start();
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class, CRESecurityException.class, CRECastException.class};
        }

        private static /* synthetic */ void lambda$exec$0(CClosure callback, Mixed cret, Mixed cex) {
            callback.executeCallable(new Mixed[]{cret, cex});
        }
    }

    public static abstract class FileFunction
    extends AbstractFunction {
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        public Boolean runAsync() {
            return null;
        }

        public boolean isRestricted() {
            return true;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class, CRESecurityException.class};
        }
    }
}

