/*
 * Decompiled with CFR 0.152.
 */
package com.chllvm.core;

import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Functions {

    @api
    public static class cpp_eval
    extends AbstractFunction {
        File tempDir = new File(".temp");

        public Class[] thrown() {
            return new Class[]{CREIOException.class, CREPluginInternalException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            block12: {
                try {
                    CommandExecutor.Execute((String)"g++ --version");
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Functions.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    throw new CREIOException("g++ must first be installed on your system", t, (Throwable)ex);
                }
                try {
                    String script = args[0].val();
                    this.tempDir.mkdirs();
                    File scriptLocation = new File(this.tempDir, "temp.cpp");
                    String ext = "";
                    if (OSUtils.GetOS() == OSUtils.OS.WINDOWS) {
                        ext = ".exe";
                    }
                    File execLocation = new File(this.tempDir, "temp" + ext);
                    FileUtil.write((String)script, (File)scriptLocation);
                    CommandExecutor ce = new CommandExecutor(new String[]{"g++", scriptLocation.getCanonicalPath(), "-o", execLocation.getCanonicalPath()});
                    final StringBuffer error = new StringBuffer();
                    ce.setSystemErr((OutputStream)new BufferedOutputStream(new OutputStream(){

                        public void write(int b) throws IOException {
                            error.append((char)b);
                        }
                    }));
                    int status = ce.start().waitFor();
                    if (status == 0) {
                        CommandExecutor exec = new CommandExecutor(new String[]{execLocation.getCanonicalPath()});
                        exec.setSystemInputsAndOutputs();
                        exec.start().waitFor();
                        break block12;
                    }
                    throw new CREPluginInternalException(error.toString(), t);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Functions.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    throw new CREIOException(ex.getMessage(), t, (Throwable)ex);
                }
                finally {
                    FileUtil.recursiveDelete((File)this.tempDir);
                }
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "cpp_eval";
        }

        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        public String docs() {
            return "void {script, [gccOptions], [args...]} Compiles and executes arbitrary C/C++. The args are sent as commandline arguments to the executable. The main function is not automatically added for you, so you must provide a full main function. GCC must already be installed on your system.";
        }

        public Version since() {
            return new SimpleVersion("1.0.0");
        }
    }
}

