/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.chirc;

import com.entityreborn.chirc.Events;
import com.entityreborn.chirc.Tracking;
import com.entityreborn.chirc.Utils;
import com.entityreborn.socbot.Channel;
import com.entityreborn.socbot.Colors;
import com.entityreborn.socbot.SocBot;
import com.entityreborn.socbot.Styles;
import com.entityreborn.socbot.Target;
import com.entityreborn.socbot.User;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Functions {

    @api
    public static class irc_del_user_meta
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_del_user_meta:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String userName = args[1].val();
            User user = bot.getUser(userName);
            if (user == null) {
                throw new CRENotFoundException("No idea who that user is!", t);
            }
            String key = args[2].val();
            Object retn = user.remMetaData(key);
            if (retn instanceof Mixed) {
                return (Mixed)retn;
            }
            return new CString(retn.toString(), t);
        }

        public String getName() {
            return "irc_del_user_meta";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "mixed {id, name, key} Deletes metadata for a given user and returns it.";
        }
    }

    @api
    public static class irc_set_channel_meta
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_set_channel_meta:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String chanName = args[1].val();
            Channel channel = bot.getChannel(chanName);
            if (channel == null) {
                throw new CRENotFoundException("No idea about that channel!", t);
            }
            String key = args[2].val();
            Mixed value = args[3];
            channel.setMetaData(key, (Object)value);
            return CNull.NULL;
        }

        public String getName() {
            return "irc_set_channel_meta";
        }

        public Integer[] numArgs() {
            return new Integer[]{4};
        }

        public String docs() {
            return "array {id, name, key, value} Set metadata for a given channel.";
        }
    }

    @api
    public static class irc_set_user_meta
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_set_user_meta:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String userName = args[1].val();
            User user = bot.getUser(userName);
            if (user == null) {
                throw new CRENotFoundException("No idea who that user is!", t);
            }
            String key = args[2].val();
            Mixed value = args[3];
            user.setMetaData(key, (Object)value);
            return CNull.NULL;
        }

        public String getName() {
            return "irc_set_user_meta";
        }

        public Integer[] numArgs() {
            return new Integer[]{4};
        }

        public String docs() {
            return "array {id, name, key, value} Set metadata for a given user.";
        }
    }

    @api
    public static class irc_channel_meta
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_channel_meta:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String chanName = args[1].val();
            Channel channel = bot.getChannel(chanName);
            if (channel == null) {
                throw new CRENotFoundException("No clue about that channel!", t);
            }
            CArray retn = new CArray(t);
            for (Map.Entry entry : channel.getMetaData().entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (entry.getValue() instanceof Mixed) {
                    value = (Mixed)entry.getValue();
                    retn.set(key, value, t);
                    continue;
                }
                value = entry.getValue().toString();
                retn.set(key, (String)value);
            }
            return retn;
        }

        public String getName() {
            return "irc_channel_meta";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {id, name} Return an array of metadata for a given channel.";
        }
    }

    @api
    public static class irc_user_meta
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_user_meta:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String userName = args[1].val();
            User user = bot.getUser(userName);
            if (user == null) {
                throw new CRENotFoundException("No idea who that is!", t);
            }
            CArray retn = new CArray(t);
            for (Map.Entry entry : user.getMetaData().entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (entry.getValue() instanceof Mixed) {
                    value = (Mixed)entry.getValue();
                    retn.set(key, value, t);
                    continue;
                }
                value = entry.getValue().toString();
                retn.set(key, (String)value);
            }
            return retn;
        }

        public String getName() {
            return "irc_user_meta";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {id, name} Return an array of metadata for a given user.";
        }
    }

    @api
    public static class irc_irc2mc_colors
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_irc2mc_colors:" + Tracking.flatten(args), t);
            String line = args[0].val();
            String background = "(,(1[0-5]|0?[0-9]))?";
            line = line.replaceAll("\u00030?1" + background, "\u00a70");
            line = line.replaceAll("\u00030?2" + background, "\u00a71");
            line = line.replaceAll("\u00030?3" + background, "\u00a72");
            line = line.replaceAll("\u000310" + background, "\u00a73");
            line = line.replaceAll("\u00030?5" + background, "\u00a74");
            line = line.replaceAll("\u00030?6" + background, "\u00a75");
            line = line.replaceAll("\u00030?7" + background, "\u00a76");
            line = line.replaceAll("\u000315" + background, "\u00a77");
            line = line.replaceAll("\u000314" + background, "\u00a78");
            line = line.replaceAll("\u000312" + background, "\u00a79");
            line = line.replaceAll("\u00030?9" + background, "\u00a7a");
            line = line.replaceAll("\u000311" + background, "\u00a7b");
            line = line.replaceAll("\u00030?4" + background, "\u00a7c");
            line = line.replaceAll("\u000313" + background, "\u00a7d");
            line = line.replaceAll("\u00030?8" + background, "\u00a7e");
            line = line.replaceAll("\u00030?0" + background, "\u00a7f");
            line = Colors.removeAll((String)line);
            line = Styles.removeAll((String)line);
            return new CString(line, t);
        }

        public String getName() {
            return "irc_irc2mc_colors";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "string {line} Return a string with irc colors converted to mc colors. Unknown colors will be stripped. Does not support styles (yet!).";
        }
    }

    @api
    public static class irc_mc2irc_colors
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_mc2irc_colors:" + Tracking.flatten(args), t);
            String line = args[0].val();
            line = line.replaceAll("\u00a70", "\u000301");
            line = line.replaceAll("\u00a71", "\u000302");
            line = line.replaceAll("\u00a72", "\u000303");
            line = line.replaceAll("\u00a73", "\u000310");
            line = line.replaceAll("\u00a74", "\u000305");
            line = line.replaceAll("\u00a75", "\u000306");
            line = line.replaceAll("\u00a76", "\u000307");
            line = line.replaceAll("\u00a77", "\u000315");
            line = line.replaceAll("\u00a78", "\u000314");
            line = line.replaceAll("\u00a79", "\u000312");
            line = line.replaceAll("\u00a7a", "\u000309");
            line = line.replaceAll("\u00a7b", "\u000311");
            line = line.replaceAll("\u00a7c", "\u000304");
            line = line.replaceAll("\u00a7d", "\u000313");
            line = line.replaceAll("\u00a7e", "\u000308");
            line = line.replaceAll("\u00a7f", "\u000300");
            line = line.replaceAll("\u00a7.", "");
            return new CString(line, t);
        }

        public String getName() {
            return "irc_mc2irc_colors";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "string {line} Return a string with mc colors converted to irc colors. Unknown colors will be stripped. Does not support styles (yet!).";
        }
    }

    @api
    public static class irc_style
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Styles style;
            Utils.verbose("CHIRC", "irc_style:" + Tracking.flatten(args), t);
            String name = args[0].val();
            try {
                style = Styles.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new CREFormatException("Bad style name", t);
            }
            return new CString(style.toString(), t);
        }

        public String getName() {
            return "irc_style";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {style} Return a style for use in IRC messages. Values: " + StringUtils.Join((Object[])Styles.values(), (String)", ") + ". ITALIC and STRIKETHRU don't work on all clients.";
        }
    }

    @api
    public static class irc_color
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Colors color;
            Utils.verbose("CHIRC", "irc_color:" + Tracking.flatten(args), t);
            String name = args[0].val().toUpperCase();
            try {
                color = Colors.valueOf((String)name.replace(" ", ""));
            }
            catch (IllegalArgumentException e) {
                throw new CREFormatException("Bad foreground color name", t);
            }
            if (args.length == 2) {
                try {
                    String background = args[1].val().toUpperCase();
                    color.setBackground(background.replace(" ", ""));
                }
                catch (IllegalArgumentException e) {
                    throw new CREFormatException("Bad background color name", t);
                }
            }
            return new CString(color.toColor(), t);
        }

        public String getName() {
            return "irc_color";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {color[, background]} Return a colorcode for use in IRC messages. Values: " + StringUtils.Join((Object[])Colors.values(), (String)", ");
        }
    }

    @api
    public static class irc_info
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_info:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.get(args[0].val(), t);
            CArray retn = new CArray(t);
            CArray channels = new CArray(t);
            for (Channel chan : bot.getChannels()) {
                channels.push((Mixed)new CString(chan.getName(), t), t);
            }
            retn.set("nickname", bot.getNickname());
            retn.set("channels", (Mixed)channels, t);
            retn.set("connected", (Mixed)CBoolean.get((boolean)bot.isConnected()), t);
            return retn;
        }

        public String getName() {
            return "irc_info";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {id} Get information about a specific irc connection.";
        }
    }

    @api
    public static class irc_user_info
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_nick:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String userName = args[1].val();
            User user = bot.getUser(userName);
            if (user == null) {
                throw new CRENotFoundException("No idea who that is!", t);
            }
            CArray retn = new CArray(t);
            retn.set("name", user.getName());
            retn.set("modes", user.getModes());
            retn.set("hostmask", user.getHostmask());
            return retn;
        }

        public String getName() {
            return "irc_user_info";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {id, user} Get info on a specific user.";
        }
    }

    @api
    public static class irc_channel_info
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_nick:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String chanName = args[1].val();
            Channel chan = bot.getChannel(chanName);
            if (chan == null) {
                throw new CRENotFoundException("Not joined to that channel!", t);
            }
            CArray retn = new CArray(t);
            retn.set("name", chan.getName());
            retn.set("modes", chan.getModes());
            retn.set("topic", chan.getTopic());
            CArray users = new CArray(t);
            for (Map.Entry entry : chan.getUserModes().entrySet()) {
                CArray data = new CArray(t);
                data.set("modes", (String)entry.getValue());
                users.set(((User)entry.getKey()).getName(), (Mixed)data, t);
            }
            retn.set("users", (Mixed)users, t);
            return retn;
        }

        public String getName() {
            return "irc_channel_info";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {id, channel} Get info on a specific channel.";
        }
    }

    @api
    public static class irc_nick
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_nick:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String name = args[1].val();
            bot.setNickname(name);
            return CNull.NULL;
        }

        public String getName() {
            return "irc_nick";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {id, newnick} Try for a new nickname.";
        }
    }

    @api
    public static class irc_action
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_action:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String channel = args[1].val();
            String message = args[2].val();
            Object target = Target.Util.isUser((String)channel, (SocBot)bot) ? bot.getUser(channel) : bot.getChannel(channel);
            if (target != null) {
                target.sendCTCP("ACTION", new String[]{message});
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_action";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "void {id, target, message} Send an action to target.";
        }
    }

    @api
    public static class irc_msg
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_msg:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String channel = args[1].val();
            String message = args[2].val();
            Object target = Target.Util.isUser((String)channel, (SocBot)bot) ? bot.getUser(channel) : bot.getChannel(channel);
            if (target != null) {
                target.sendMsg(new String[]{message});
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_msg";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "void {id, target, message} Send a message to target.";
        }
    }

    @api
    public static class irc_quit
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_quit:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            if (args.length == 2) {
                bot.quit(args[1].val());
            } else {
                bot.quit();
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_quit";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {id, channel[, password]} Quit the server, optionally using a message.";
        }
    }

    @api
    public static class irc_part
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_part:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String channel = args[1].val();
            if (args.length == 3) {
                bot.part(channel, args[2].val());
            } else {
                bot.part(channel);
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_part";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {id, channel[, password]} Leave a channel, optionally using a message.";
        }
    }

    @api
    public static class irc_join
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_join:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String channel = args[1].val();
            if (args.length == 3) {
                bot.join(channel, args[2].val());
            } else {
                bot.join(channel);
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_join";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {id, channel[, password]} Join a channel, optionally using a password.";
        }
    }

    @api
    public static class irc_connect
    extends IrcFunc {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREIOException.class, CRECastException.class, CRERangeException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String password;
            int port;
            Utils.verbose("CHIRC", "irc_connect:" + Tracking.flatten(args), t);
            final SocBot bot = Tracking.get(args[0].val(), t);
            String nick = args[1].val();
            final String host = args[2].val();
            boolean async = true;
            if (args.length >= 4) {
                if (!(args[3] instanceof CArray) || !((CArray)args[3]).inAssociativeMode()) {
                    throw new CRECastException(this.getName() + " expects an associative array to be sent as the fourth argument", t);
                }
                CArray arr = (CArray)args[3];
                if (arr.containsKey("realname")) {
                    bot.setRealname(arr.get("realname", t).val());
                }
                if (arr.containsKey("username")) {
                    bot.setUsername(arr.get("username", t).val());
                }
                if (arr.containsKey("port")) {
                    long iport = ArgumentValidation.getInt((Mixed)arr.get("port", t), (Target)t);
                    if (iport < 1L || iport > 65535L) {
                        throw new CRERangeException(this.getName() + " expects an integer between 1 and 65535 to be sent as port in the fourth argument", t);
                    }
                    port = (int)iport;
                } else {
                    port = 6667;
                }
                password = arr.containsKey("password") ? arr.get("password", t).val() : null;
                if (arr.containsKey("runsync")) {
                    if (!(arr.get("runsync", t) instanceof CBoolean)) {
                        throw new CRECastException(this.getName() + " expects a boolean to be sent as runsync in the fourth argument", t);
                    }
                    async = !((CBoolean)arr.get("runsync", t)).getBoolean();
                }
            } else {
                port = 6667;
                password = null;
            }
            bot.setNickname(nick);
            final Runnable doConnect = new Runnable(){

                @Override
                public void run() {
                    try {
                        bot.connect(host, port, password);
                    }
                    catch (IOException e) {
                        final Events.ConnectionException event = new Events.ConnectionException(e, bot);
                        try {
                            StaticLayer.GetConvertor().runOnMainThreadAndWait((Callable)new Callable<Object>(){

                                @Override
                                public Object call() {
                                    EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"irc_connection_exception", (BindableEvent)event);
                                    return null;
                                }
                            });
                        }
                        catch (Exception ex) {
                            Logger.getLogger(Events.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
            if (async) {
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        doConnect.run();
                    }
                };
                th.start();
            } else {
                doConnect.run();
            }
            return CNull.NULL;
        }

        public String getName() {
            return "irc_connect";
        }

        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }

        public String docs() {
            return "void {id, nick, host[, array]} Connect to host using nickname nick.";
        }
    }

    @api
    public static class irc_destroy
    extends IrcFunc {
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_destroy:" + Tracking.flatten(args), t);
            Tracking.destroy(args[0].val(), t);
            return CNull.NULL;
        }

        public String getName() {
            return "irc_destroy";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {id} Destroy an IRC bot. Disconnects the bot from any connection, and removes it's instance from memory.";
        }
    }

    @api
    public static class irc_send_raw
    extends IrcFunc {
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_send_raw:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.getConnected(args[0].val(), t);
            String line = args[1].val();
            bot.sendLine(line);
            return CNull.NULL;
        }

        public String getName() {
            return "irc_send_raw";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {id, line} Send a raw IRC line. Consult the IRC RFC for details.";
        }
    }

    @api
    public static class irc_strip_color
    extends IrcFunc {
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_strip_color:" + Tracking.flatten(args), t);
            String out = Colors.removeAll((String)args[0].val());
            out = Styles.removeAll((String)out);
            return new CString(out, t);
        }

        public String getName() {
            return "irc_strip_color";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "string {line} Remove all IRC formatting from a string.";
        }
    }

    @api
    public static class irc_create
    extends IrcFunc {
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Utils.verbose("CHIRC", "irc_create:" + Tracking.flatten(args), t);
            SocBot bot = Tracking.create(args[0].val());
            return CBoolean.get((bot != null ? 1 : 0) != 0);
        }

        public String getName() {
            return "irc_create";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {id} Create an IRC bot for later use. Returns true if that id didn't exist, and false if it did.";
        }
    }

    public static abstract class IrcFunc
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

