/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.chirc;

import com.entityreborn.chirc.Events;
import com.entityreborn.chirc.Utils;
import com.entityreborn.socbot.SocBot;
import com.entityreborn.socbot.eventsystem.EventManager;
import com.entityreborn.socbot.eventsystem.Listener;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.MSExtension;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;

@MSExtension(value="CHIRC")
public class Tracking
extends AbstractExtension {
    private static final Map<String, SocBot> bots = new HashMap<String, SocBot>();
    private static final Events events = new Events();

    public void onStartup() {
        Utils.log("CHIRC", "v." + this.getVersion() + " loaded.", Target.UNKNOWN);
    }

    public void onShutdown() {
        Utils.log("CHIRC", "v." + this.getVersion() + " stopping...", Target.UNKNOWN);
        for (SocBot bot : bots.values()) {
            bot.disconnect(true);
        }
        bots.clear();
        Utils.log("CHIRC", "v." + this.getVersion() + " stopped", Target.UNKNOWN);
    }

    public static String flatten(Mixed ... args) {
        String retn = "";
        for (int i = 0; i < args.length; ++i) {
            retn = retn + args[i].val();
            if (i == args.length - 1) continue;
            retn = retn + ", ";
        }
        return retn;
    }

    public static SocBot create(String id) {
        if (bots.containsKey(id.toLowerCase())) {
            return null;
        }
        Utils.verbose("CHIRC", "Creating irc bot with id " + id, Target.UNKNOWN);
        SocBot bot = new SocBot(id.toLowerCase());
        EventManager.registerEvents((Listener)events, (Object)bot);
        bots.put(id.toLowerCase(), bot);
        return bot;
    }

    public static SocBot get(String id, Target t) {
        SocBot bot = bots.get(id.toLowerCase());
        if (bot == null) {
            throw new CRENotFoundException("That id doesn't exist!", t);
        }
        return bot;
    }

    public static SocBot getConnected(String id, Target t) {
        SocBot bot = Tracking.get(id, t);
        if (!bot.isConnected()) {
            throw new CREException("This bot is not connected!", t);
        }
        return bot;
    }

    public static void destroy(String id, Target t) {
        SocBot bot = bots.remove(id.toLowerCase());
        if (bot == null) {
            throw new CRENotFoundException("That id doesn't exist!", t);
        }
        Utils.verbose("CHIRC", "Destroying bot with id " + id, t);
        bot.disconnect(true);
    }

    public Version getVersion() {
        return new SimpleVersion(0, 0, 1);
    }
}

