/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.chirc;

import com.entityreborn.socbot.Numerics;
import com.entityreborn.socbot.Packet;
import com.entityreborn.socbot.SocBot;
import com.entityreborn.socbot.events.CTCPEvent;
import com.entityreborn.socbot.events.ConnectedEvent;
import com.entityreborn.socbot.events.DisconnectedEvent;
import com.entityreborn.socbot.events.ErrorEvent;
import com.entityreborn.socbot.events.JoinEvent;
import com.entityreborn.socbot.events.NickEvent;
import com.entityreborn.socbot.events.NickInUseEvent;
import com.entityreborn.socbot.events.NumericEvent;
import com.entityreborn.socbot.events.PacketReceivedEvent;
import com.entityreborn.socbot.events.PartEvent;
import com.entityreborn.socbot.events.PrivmsgEvent;
import com.entityreborn.socbot.events.QuitEvent;
import com.entityreborn.socbot.events.WelcomeEvent;
import com.entityreborn.socbot.eventsystem.EventHandler;
import com.entityreborn.socbot.eventsystem.Listener;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Events
implements Listener {
    public void fireEvent(String name, BindableEvent evt) {
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)name, (BindableEvent)evt);
    }

    @EventHandler
    public void handleDisconnect(DisconnectedEvent e) {
        Disconnected event = new Disconnected(e);
        this.fireEvent("irc_disconnected", event);
    }

    @EventHandler
    public void handleError(ErrorEvent e) {
        Error event = new Error(e);
        this.fireEvent("irc_error", event);
    }

    @EventHandler
    public void handleNick(NickEvent e) {
        Nick event = new Nick(e);
        this.fireEvent("irc_nick_changed", event);
    }

    @EventHandler
    public void handleNickInUse(NickInUseEvent e) {
        NickInUse event = new NickInUse(e);
        this.fireEvent("irc_nick_in_use", event);
    }

    @EventHandler
    public void handleNumeric(NumericEvent e) {
        Numeric event = new Numeric(e);
        this.fireEvent("irc_numeric", event);
    }

    @EventHandler
    public void handlePacketRecv(PacketReceivedEvent e) {
        RecvLine event = new RecvLine(e);
        this.fireEvent("irc_recv_raw", event);
    }

    @EventHandler
    public void handleConnect(ConnectedEvent e) {
        Connected event = new Connected(e);
        this.fireEvent("irc_connected", event);
    }

    @EventHandler
    public void handlePrivMsg(PrivmsgEvent e) {
        PrivMsg event = new PrivMsg(e);
        this.fireEvent("irc_msg", event);
    }

    @EventHandler
    public void handleCTCP(CTCPEvent e) {
        if ("ACTION".equalsIgnoreCase(e.getType())) {
            Action event = new Action(e);
            this.fireEvent("irc_action", event);
        }
    }

    @EventHandler
    public void handleWelcome(WelcomeEvent e) {
        Welcome event = new Welcome(e);
        this.fireEvent("irc_welcomed", event);
    }

    @EventHandler
    public void handleJoined(JoinEvent e) {
        Join event = new Join(e);
        this.fireEvent("irc_joined", event);
    }

    @EventHandler
    public void handleQuit(QuitEvent e) {
        Quit event = new Quit(e);
        this.fireEvent("irc_quit", event);
    }

    @EventHandler
    public void handleParted(PartEvent e) {
        Part event = new Part(e);
        this.fireEvent("irc_parted", event);
    }

    @api
    public static class irc_parted
    extends IrcEvent {
        public String getName() {
            return "irc_parted";
        }

        public String docs() {
            return "{} Fires when a user leaves a channel. User could be self when using irc_part().{id | who: The user that left | channel: The channel that was left }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Part) {
                Part msg = (Part)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("who", (Mixed)new CString(msg.getWho(), Target.UNKNOWN));
                retn.put("channel", (Mixed)new CString(msg.getChannel(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_quit
    extends IrcEvent {
        public String getName() {
            return "irc_quit";
        }

        public String docs() {
            return "{} Fires when a user quits. User could be self when using irc_quit().{id | who: The user that quit | message }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Quit) {
                Quit msg = (Quit)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("who", (Mixed)new CString(msg.getWho(), Target.UNKNOWN));
                retn.put("message", (Mixed)new CString(msg.getQuitMessage(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_joined
    extends IrcEvent {
        public String getName() {
            return "irc_joined";
        }

        public String docs() {
            return "{} Fires when a user joins a channel. User could be self when using irc_join().{id | who: The user that joined | channel: The channel that was joined }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Join) {
                Join msg = (Join)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("who", (Mixed)new CString(msg.getWho(), Target.UNKNOWN));
                retn.put("channel", (Mixed)new CString(msg.getChannel(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_welcomed
    extends IrcEvent {
        public String getName() {
            return "irc_welcomed";
        }

        public String docs() {
            return "{} Fires when a welcome reply is received after the bot successfully signed in.{id}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Welcome) {
                Welcome msg = (Welcome)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_action
    extends IrcEvent {
        public String getName() {
            return "irc_action";
        }

        public String docs() {
            return "{} Fires when an action CTCP message is received. (/me){id | who | target: The receiving channel or user  | message }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Action) {
                Action msg = (Action)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("who", (Mixed)new CString(msg.getWho(), Target.UNKNOWN));
                retn.put("target", (Mixed)new CString(msg.getTarget(), Target.UNKNOWN));
                retn.put("message", (Mixed)new CString(msg.getMessage(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_recv_raw
    extends IrcEvent {
        public String getName() {
            return "irc_recv_raw";
        }

        public String docs() {
            return "{} Fires when a packet is received. This is fired before any tracking is done by the internal library, so be aware of what you're doing!{id | line: The raw packet data }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof RecvLine) {
                RecvLine msg = (RecvLine)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("line", (Mixed)new CString(msg.getPacket().getOriginalLine(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_error
    extends IrcEvent {
        public String getName() {
            return "irc_error";
        }

        public String docs() {
            return "{} Fires when error packet is received.{id | message }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Error) {
                Error msg = (Error)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("message", (Mixed)new CString(msg.getMessage(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_msg
    extends IrcEvent {
        public String getName() {
            return "irc_msg";
        }

        public String docs() {
            return "{} Fires when bot sends or receives a private message.{id | who: The sender | target: The receiving channel or user | message }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof PrivMsg) {
                PrivMsg msg = (PrivMsg)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("who", (Mixed)new CString(msg.getWho(), Target.UNKNOWN));
                retn.put("target", (Mixed)new CString(msg.getTarget(), Target.UNKNOWN));
                retn.put("message", (Mixed)new CString(msg.getMessage(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_connection_exception
    extends IrcEvent {
        public String getName() {
            return "irc_connection_exception";
        }

        public String docs() {
            return "{} Fires when connection fails. Triggers reconnect.{id | exceptionclass: The exception's simple class name | message}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof ConnectionException) {
                ConnectionException msg = (ConnectionException)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("message", (Mixed)new CString(msg.getMessage(), Target.UNKNOWN));
                retn.put("exceptionclass", (Mixed)new CString(msg.className(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_connected
    extends IrcEvent {
        public String getName() {
            return "irc_connected";
        }

        public String docs() {
            return "{} Fires when connected to host. Bot is about to attempt signin. The bot isn't in the server yet. (advanced use only!){id | server: The host connected to | port: The port connected to}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Connected) {
                Connected msg = (Connected)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("server", (Mixed)new CString(msg.getServer(), Target.UNKNOWN));
                retn.put("port", (Mixed)new CInt((long)msg.getPort(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_numeric
    extends IrcEvent {
        public String getName() {
            return "irc_numeric";
        }

        public String docs() {
            return "{} Fires when certain numeric packets are received. (See RFC 2812){id | numeric | numericid | args | message }{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Numeric) {
                Numeric msg = (Numeric)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("numeric", (Mixed)new CString(msg.getNumeric().getName(), Target.UNKNOWN));
                retn.put("numericid", (Mixed)new CInt((long)msg.getNumeric().getCode(), Target.UNKNOWN));
                retn.put("args", (Mixed)Construct.GetConstruct(msg.getArgs()));
                retn.put("message", (Mixed)new CString(msg.getMessage(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_nick_in_use
    extends IrcEvent {
        public String getName() {
            return "irc_nick_in_use";
        }

        public String docs() {
            return "{} Fires when an attempt at changing nickname fails because the nick is in use.{id | nick: The attempted nickname}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof NickInUse) {
                NickInUse msg = (NickInUse)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("nick", (Mixed)CBoolean.get((String)msg.getNick()));
            }
            return retn;
        }
    }

    @api
    public static class irc_nick
    extends IrcEvent {
        public String getName() {
            return "irc_nick_changed";
        }

        public String docs() {
            return "{} Fires when user has their nickname changed.{id | oldnick: The previous nickname | newnick: The now current nickname}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Nick) {
                Nick msg = (Nick)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("oldnick", (Mixed)new CString(msg.getOld(), Target.UNKNOWN));
                retn.put("newnick", (Mixed)new CString(msg.getNew(), Target.UNKNOWN));
            }
            return retn;
        }
    }

    @api
    public static class irc_disconnected
    extends IrcEvent {
        public String getName() {
            return "irc_disconnected";
        }

        public String docs() {
            return "{} Fires when disconnected from host. If irc_destroy or irc_quit is used, wasClean will be true. It will be false if a timeout or other error occurred.{id | wasClean: Whether bot disconnected without error}{}{}";
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            HashMap<String, Mixed> retn = new HashMap<String, Mixed>();
            if (e instanceof Disconnected) {
                Disconnected msg = (Disconnected)e;
                retn.put("id", (Mixed)new CString(msg.getBot().getID(), Target.UNKNOWN));
                retn.put("wasClean", (Mixed)CBoolean.get((boolean)msg.wasClean()));
            }
            return retn;
        }
    }

    private static abstract class IrcEvent
    extends AbstractEvent {
        private IrcEvent() {
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return true;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) throws ConfigRuntimeException {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    private static class Action
    implements BindableEvent {
        private final CTCPEvent event;

        public Action(CTCPEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getWho() {
            return this.event.getSender().getName();
        }

        public String getTarget() {
            return this.event.getTarget().getName();
        }

        public String getMessage() {
            return this.event.getMessage();
        }
    }

    private static class PrivMsg
    implements BindableEvent {
        private final PrivmsgEvent event;

        public PrivMsg(PrivmsgEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getWho() {
            return this.event.getSender().getName();
        }

        public String getTarget() {
            return this.event.getTarget().getName();
        }

        public String getMessage() {
            return this.event.getMessage();
        }
    }

    private static class Part
    implements BindableEvent {
        private final PartEvent event;

        public Part(PartEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getWho() {
            return this.event.getUser().getName();
        }

        public String getChannel() {
            return this.event.getChannel().getName();
        }
    }

    private static class RecvLine
    implements BindableEvent {
        private final PacketReceivedEvent event;

        public RecvLine(PacketReceivedEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public Packet getPacket() {
            return this.event.getPacket();
        }
    }

    private static class Quit
    implements BindableEvent {
        private final QuitEvent event;

        public Quit(QuitEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getWho() {
            return this.event.getUser().getName();
        }

        public String getQuitMessage() {
            return this.event.getQuitMessage();
        }
    }

    private static class Join
    implements BindableEvent {
        private final JoinEvent event;

        public Join(JoinEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getWho() {
            return this.event.getUser().getName();
        }

        public String getChannel() {
            return this.event.getChannel().getName();
        }
    }

    private static class Welcome
    implements BindableEvent {
        private final WelcomeEvent event;

        public Welcome(WelcomeEvent e) {
            this.event = e;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }
    }

    protected static class ConnectionException
    implements BindableEvent {
        private final IOException exception;
        private final SocBot bot;

        public ConnectionException(IOException e, SocBot b) {
            this.exception = e;
            this.bot = b;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.bot;
        }

        public String className() {
            return this.exception.getClass().getSimpleName();
        }

        public String getMessage() {
            return this.exception.getMessage();
        }
    }

    private static class Numeric
    implements BindableEvent {
        private final NumericEvent event;

        public Numeric(NumericEvent event) {
            this.event = event;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public Numerics.Numeric getNumeric() {
            return this.event.getNumeric();
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public List<String> getArgs() {
            return this.event.getPacket().getArgs();
        }
    }

    private static class NickInUse
    implements BindableEvent {
        private final NickInUseEvent event;

        public NickInUse(NickInUseEvent event) {
            this.event = event;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getNick() {
            return this.event.getNick();
        }
    }

    private static class Nick
    implements BindableEvent {
        private final NickEvent event;

        public Nick(NickEvent event) {
            this.event = event;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getOld() {
            return this.event.getUser().getLastNick();
        }

        public String getNew() {
            return this.event.getNewNick();
        }
    }

    private static class Connected
    implements BindableEvent {
        private final ConnectedEvent event;

        public Connected(ConnectedEvent event) {
            this.event = event;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getServer() {
            return this.event.getServer();
        }

        public int getPort() {
            return this.event.getPort();
        }
    }

    private static class Disconnected
    implements BindableEvent {
        private final DisconnectedEvent event;

        public Disconnected(DisconnectedEvent event) {
            this.event = event;
        }

        public Object _GetObject() {
            return this;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public boolean wasClean() {
            return this.event.wasClean();
        }
    }

    private static class Error
    implements BindableEvent {
        private final ErrorEvent event;

        public Object _GetObject() {
            return this;
        }

        public Error(ErrorEvent evt) {
            this.event = evt;
        }

        public SocBot getBot() {
            return this.event.getBot();
        }

        public String getMessage() {
            return this.event.getMessage();
        }
    }
}

