/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.chlb;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.worldedit.CuboidRegion;
import io.github.jbaero.chlb.LBColumns;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LBOG {
    private static LBOG lbog = null;

    public static LBOG GetGenerator() {
        if (lbog == null) {
            lbog = new LBOG();
        }
        return lbog;
    }

    public QueryParams query(Mixed c, LogBlock lb, Target t) {
        QueryParams queryParams = new QueryParams(lb);
        if (c instanceof CArray && ((CArray)c).inAssociativeMode()) {
            MCLocation corner1;
            CArray argParams = (CArray)c;
            if (!argParams.containsKey("info")) {
                throw new CREFormatException("Array was missing info key", t);
            }
            queryParams.merge(this.columns(queryParams, argParams.get("info", t), t));
            if (argParams.containsKey("changetype")) {
                try {
                    queryParams.bct = QueryParams.BlockChangeType.valueOf((String)argParams.get("changetype", t).val());
                }
                catch (IllegalArgumentException iae) {
                    throw new CREFormatException("Applicable changetypes: " + QueryParams.BlockChangeType.values().toString(), t);
                }
            }
            if (argParams.containsKey("location")) {
                corner1 = ObjectGenerator.GetGenerator().location(argParams.get("location", t), null, t);
                queryParams.setLocation(((BukkitMCLocation)corner1).asLocation());
                if (argParams.containsKey("radius")) {
                    queryParams.radius = ArgumentValidation.getInt32((Mixed)argParams.get("radius", t), (Target)t);
                }
            } else if (argParams.containsKey("sel")) {
                CuboidRegion worldEditSelection;
                Mixed sel = argParams.get("sel", t);
                if (sel instanceof CArray) {
                    CArray ca = (CArray)sel;
                    if (ca.size() < 2L) {
                        throw new CREFormatException("Expected 2 location arrays for sel", t);
                    }
                    corner1 = ObjectGenerator.GetGenerator().location(ca.get(0, t), null, t);
                    MCLocation corner2 = ObjectGenerator.GetGenerator().location(ca.get(1, t), null, t);
                    worldEditSelection = CuboidRegion.fromCorners((World)((BukkitMCWorld)corner1.getWorld()).__World(), (Location)((BukkitMCLocation)corner1).asLocation(), (Location)((BukkitMCLocation)corner2).asLocation());
                    queryParams.setSelection(worldEditSelection);
                } else {
                    MCPlayer player = Static.GetPlayer((Mixed)argParams.get("sel", t), (Target)t);
                    worldEditSelection = CuboidRegion.fromPlayerSelection((Player)((BukkitMCPlayer)player)._Player());
                    queryParams.setSelection(worldEditSelection);
                }
            }
            if (argParams.containsKey("players")) {
                ArrayList<String> plist = new ArrayList<String>();
                if (argParams.get("players", t) instanceof CArray) {
                    int i = 0;
                    while ((long)i < ((CArray)argParams.get("players", t)).size()) {
                        plist.add(((CArray)argParams.get("players", t)).get(i, t).val());
                        ++i;
                    }
                } else {
                    plist.add(argParams.get("players", t).val());
                }
                queryParams.players = plist;
            }
            if (argParams.containsKey("world")) {
                queryParams.world = ((BukkitMCWorld)Static.getServer().getWorld(argParams.get("world", t).val())).__World();
            }
            if (argParams.containsKey("since")) {
                queryParams.since = ArgumentValidation.getInt32((Mixed)argParams.get("since", t), (Target)t);
            }
            if (argParams.containsKey("before")) {
                queryParams.before = ArgumentValidation.getInt32((Mixed)argParams.get("before", t), (Target)t);
            }
            if (argParams.containsKey("limit")) {
                queryParams.limit = ArgumentValidation.getInt32((Mixed)argParams.get("limit", t), (Target)t);
            }
        } else {
            throw new CREFormatException("Expected an associative array but received " + c, t);
        }
        return queryParams;
    }

    public QueryParams columns(QueryParams queryParams, Mixed col, Target t) {
        if (col instanceof CArray && ((CArray)col).size() >= 0L) {
            CArray columnsArray = (CArray)col;
            int i = 0;
            while ((long)i < columnsArray.size()) {
                block19: {
                    LBColumns lbc;
                    try {
                        lbc = LBColumns.valueOf(columnsArray.get(i, t).val().toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        break block19;
                    }
                    switch (lbc) {
                        case CHESTACCESS: {
                            queryParams.needChestAccess = true;
                            break;
                        }
                        case COORDS: {
                            queryParams.needCoords = true;
                            break;
                        }
                        case COUNT: {
                            queryParams.needCount = true;
                            break;
                        }
                        case DATA: {
                            queryParams.needData = true;
                            break;
                        }
                        case DATE: {
                            queryParams.needDate = true;
                            break;
                        }
                        case ID: {
                            queryParams.needId = true;
                            break;
                        }
                        case KILLER: {
                            queryParams.needKiller = true;
                            break;
                        }
                        case MESSAGE: {
                            queryParams.needMessage = true;
                            break;
                        }
                        case PLAYER: {
                            queryParams.needPlayer = true;
                            break;
                        }
                        case TYPE: {
                            queryParams.needType = true;
                            break;
                        }
                        case VICTIM: {
                            queryParams.needVictim = true;
                            break;
                        }
                        case WEAPON: {
                            queryParams.needWeapon = true;
                        }
                    }
                }
                ++i;
            }
        } else {
            throw new CREFormatException("Needed an array to determine which info is requested", t);
        }
        return queryParams;
    }
}

