/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chnaughty;

import com.google.gson.JsonSyntaxException;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.mojang.datafixers.util.Either;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

class Minecraft {
    static final int VIEW_DISTANCE = Bukkit.getViewDistance() * 16;

    Minecraft() {
    }

    static PlayerConnection GetConnection(MCPlayer player) {
        return ((CraftPlayer)player.getHandle()).getHandle().c;
    }

    static Entity GetEntity(MCEntity entity) {
        return ((CraftEntity)entity.getHandle()).getHandle();
    }

    static EntityPlayer GetPlayer(MCPlayer player) {
        return ((CraftPlayer)player.getHandle()).getHandle();
    }

    static void Sleep(MCPlayer p, MCLocation loc, Target t) {
        Either result;
        EntityPlayer player = Minecraft.GetPlayer(p);
        BlockPosition pos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        try {
            result = player.startSleepInBed(pos, false);
        }
        catch (IllegalArgumentException ex) {
            throw new CREException("That is not a bed.", t);
        }
        result.ifLeft(bedresult -> {
            switch (bedresult) {
                case a: {
                    throw new CREException("It's not possible to sleep here.", t);
                }
                case b: {
                    throw new CREException("It's not possible to sleep now.", t);
                }
                case c: {
                    throw new CREException("That bed is too far away.", t);
                }
                case d: {
                    throw new CREException("That bed is obstructed.", t);
                }
                case e: {
                    throw new CREException("Can't sleep for some reason.", t);
                }
                case f: {
                    throw new CREException("It's not safe to sleep.", t);
                }
            }
        });
    }

    static void OpenBook(MCPlayer p, Mixed data, Target t) {
        if (data instanceof CArray) {
            CArray pages = (CArray)data;
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta bookmeta = (BookMeta)book.getItemMeta();
            if (bookmeta == null) {
                throw new CRENullPointerException("Book meta is null. This shouldn't happen and may be a problem with the server.", t);
            }
            int i = 0;
            while ((long)i < pages.size()) {
                block13: {
                    String text = pages.get(i, t).val();
                    if (!(text.isEmpty() || text.charAt(0) != '[' && text.charAt(0) != '{')) {
                        try {
                            bookmeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{ComponentSerializer.parse((String)text)});
                            break block13;
                        }
                        catch (JsonSyntaxException | IllegalStateException throwable) {
                            // empty catch block
                        }
                    }
                    bookmeta.addPage(new String[]{text});
                }
                ++i;
            }
            bookmeta.setTitle(" ");
            bookmeta.setAuthor(" ");
            book.setItemMeta((ItemMeta)bookmeta);
            ((Player)p.getHandle()).openBook(book);
        } else {
            Item item;
            EnumHand h;
            EntityPlayer player = Minecraft.GetPlayer(p);
            try {
                h = EnumHand.valueOf((String)data.val());
            }
            catch (IllegalArgumentException ex) {
                throw new CREIllegalArgumentException(ex.getMessage(), t);
            }
            try {
                item = player.b(h).d();
            }
            catch (NullPointerException ex) {
                throw new CRENullPointerException(ex.getMessage(), t);
            }
            if (item == Items.tU) {
                player.c.a((Packet)new PacketPlayOutOpenBook(h));
            } else {
                throw new CREIllegalArgumentException("No book in the given hand.", t);
            }
        }
    }

    static void SetSky(MCPlayer p, float a2, float b) {
        PlayerConnection conn = Minecraft.GetConnection(p);
        conn.a((Packet)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, a2));
        conn.a((Packet)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, b));
    }

    static void ActionMsg(MCPlayer p, String message) {
        TextComponent txt = new TextComponent(message);
        ((Player)p.getHandle()).spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)txt);
    }
}

