/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chnaughty;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Collection;
import java.util.EnumSet;
import me.pseudoknight.chnaughty.Minecraft;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Functions {
    public static String docs() {
        return "Functions that lack a Bukkit or Spigot API interface.";
    }

    @api
    public static class set_entity_size
    extends AbstractFunction {
        public String getName() {
            return "set_entity_size";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "void {entity, width, height} Sets an entity's width and height. This gets reset every time the entity's pose changes.";
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            net.minecraft.world.entity.Entity entity = ((CraftEntity)Static.getEntity((Mixed)args[0], (Target)t).getHandle()).getHandle();
            float width = ArgumentValidation.getDouble32((Mixed)args[1], (Target)t);
            float height = ArgumentValidation.getDouble32((Mixed)args[2], (Target)t);
            ReflectionUtils.set(net.minecraft.world.entity.Entity.class, (Object)entity, (String)"bh", (Object)EntitySize.b((float)width, (float)height));
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CRELengthException.class, CRECastException.class, CREIllegalArgumentException.class};
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }
    }

    @api
    public static class set_psky
    extends AbstractFunction {
        public String getName() {
            return "set_psky";
        }

        public String docs() {
            return "void {[playerName], downFallOpacity, storminess} Sends a packet to the player to change their sky. As of 1.17 the first number changes the opacity of precipitation from 0.0 - 1.0. The second number changes the storminess of the skyt while precipitating from 0.0 - 1.0.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            float b;
            float a2;
            MCPlayer p;
            if (args.length == 3) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                a2 = ArgumentValidation.getDouble32((Mixed)args[1], (Target)t);
                b = ArgumentValidation.getDouble32((Mixed)args[2], (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                a2 = ArgumentValidation.getDouble32((Mixed)args[0], (Target)t);
                b = ArgumentValidation.getDouble32((Mixed)args[1], (Target)t);
            }
            Minecraft.SetSky(p, a2, b);
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CRERangeException.class, CRECastException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class pswing_hand
    extends AbstractFunction {
        public String getName() {
            return "pswing_hand";
        }

        public String docs() {
            return "void {[playerName], [hand]} Swing the player's hand in an attack animation. The hand parameter can be either main_hand (default) or off_hand. Note that this also triggers a player_interact event when the player is not hitting a block. The event will always have the action \"left_click_air\" and the hand \"main_hand\".";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            String hand = "MAIN_HAND";
            if (args.length == 2) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                hand = args[1].val().toUpperCase();
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                if (args.length == 1) {
                    hand = args[0].val().toUpperCase();
                }
            }
            Player player = (Player)p.getHandle();
            if (hand.isEmpty() || hand.equals("MAIN_HAND")) {
                player.swingMainHand();
            } else if (hand.equals("OFF_HAND")) {
                player.swingOffHand();
            } else {
                throw new CREFormatException("Expected main_hand or off_hand but got \"" + hand + "\".", t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREFormatException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class set_pstinger_count
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CRECastException.class, CRERangeException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            int stingers;
            MCPlayer p;
            if (args.length == 2) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                stingers = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                stingers = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
            }
            EntityPlayer player = ((CraftPlayer)p.getHandle()).getHandle();
            player.q(stingers);
            return CVoid.VOID;
        }

        public String getName() {
            return "set_pstinger_count";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], count} Sets the amount of bee stingers in a player's model.";
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class set_parrow_count
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CRECastException.class, CRERangeException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            int arrowCount;
            MCPlayer p;
            int ticks = -1;
            if (args.length > 1) {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
                arrowCount = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
                if (args.length > 2) {
                    ticks = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
                }
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                arrowCount = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
            }
            Player player = (Player)p.getHandle();
            player.setArrowsInBody(arrowCount);
            if (ticks > -1) {
                player.setArrowCooldown(ticks);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "set_parrow_count";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {count | player, count, [ticks]} Sets the amount of arrows in a player's model. Optional number of ticks the arrow count will persist until arrows start despawning again. (default: 20 * (30 - count))";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class open_sign
    extends AbstractFunction {
        public String getName() {
            return "open_sign";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {[player], location, [lines]} Opens a sign editor for the given sign location. Lines must be an array with 4 values or null. If not provided, it'll use the lines from the given sign. Throws CastException if not a sign block.";
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            BlockState state;
            Mixed clocation;
            MCPlayer player;
            Mixed clines = null;
            if (args.length == 3) {
                player = Static.GetPlayer((Mixed)args[0], (Target)t);
                clocation = args[1];
                clines = args[2];
            } else if (args.length == 2) {
                if (args[0] instanceof CArray) {
                    player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                    Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                    clocation = args[0];
                    clines = args[1];
                } else {
                    player = Static.GetPlayer((Mixed)args[0], (Target)t);
                    clocation = args[1];
                }
            } else {
                player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                clocation = args[0];
            }
            MCLocation signLoc = ObjectGenerator.GetGenerator().location(clocation, null, t);
            if (clines != null) {
                String[] lines = new String[4];
                if (!(clines instanceof CNull)) {
                    if (!(clines instanceof CArray)) {
                        throw new CREFormatException("Expected an array.", t);
                    }
                    CArray array = (CArray)clines;
                    for (int i = 0; i < 4; ++i) {
                        lines[i] = array.get(i, t).val();
                    }
                }
                player.sendSignTextChange(signLoc, lines);
            }
            if (!((state = ((Location)signLoc.getHandle()).getBlock().getState()) instanceof Sign)) {
                throw new CRECastException("This location is not a sign.", t);
            }
            try {
                ((Player)player.getHandle()).openSign((Sign)state);
            }
            catch (IllegalArgumentException ex) {
                throw new CREInvalidWorldException("Cannot open sign in another world", t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREFormatException.class, CREInvalidWorldException.class, CRECastException.class, CREIndexOverflowException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class open_book
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREFormatException.class, CREIllegalArgumentException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Mixed data;
            MCPlayer player;
            if (args.length == 2) {
                player = Static.GetPlayer((Mixed)args[0], (Target)t);
                data = args[1];
            } else {
                player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                data = args[0];
            }
            Minecraft.OpenBook(player, data, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "open_book";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], data} Sends a virtual book to a player. Accepts an array of pages or a hand that has a book to open. Each page can be either JSON or a plain text. If the JSON is not formatted correctly,  it will fall back to string output per page. Throws IllegalArgumentException if no written book resides in the given hand.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class tps
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            double[] recentTps = ((CraftServer)Bukkit.getServer()).getServer().recentTps;
            CArray tps2 = new CArray(t, 3);
            for (double d : recentTps) {
                tps2.push((Mixed)new CDouble(Math.min((double)Math.round(d * 100.0) / 100.0, 20.0), t), t);
            }
            return tps2;
        }

        public String getName() {
            return "tps";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public String docs() {
            return "array {} Returns an array of average ticks per second over 5, 10 and 15 minutes.";
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class action_msg
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String message;
            String name = "";
            if (args.length == 2) {
                name = args[0].val();
                message = args[1].val();
            } else {
                MCCommandSender sender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetCommandSender();
                if (sender instanceof MCPlayer) {
                    name = sender.getName();
                }
                message = args[0].val();
            }
            MCPlayer player = Static.GetPlayer((String)name, (Target)t);
            Minecraft.ActionMsg(player, message);
            return CVoid.VOID;
        }

        public String getName() {
            return "action_msg";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], message} Sends a message to the action bar.";
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class ping
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            if (args.length == 1) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
            }
            return new CInt((long)((Player)p.getHandle()).getPing(), t);
        }

        public String getName() {
            return "ping";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "int {[playerName]} Gets the player's ping.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class ray_trace
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREFormatException.class, CRERangeException.class, CRECastException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Vector end;
            Location loc;
            Player p;
            double range = Minecraft.VIEW_DISTANCE;
            double raySize = 0.0;
            if (args.length == 0) {
                p = (Player)((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer().getHandle();
                loc = p.getEyeLocation();
            } else if (args.length == 1) {
                p = (Player)((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer().getHandle();
                range = ArgumentValidation.getDouble((Mixed)args[0], (Target)t);
                loc = p.getEyeLocation();
            } else if (args.length == 2) {
                if (args[0] instanceof CArray) {
                    p = null;
                    loc = (Location)ObjectGenerator.GetGenerator().location(args[0], null, t).getHandle();
                } else {
                    p = (Player)Static.GetPlayer((String)args[0].val(), (Target)t).getHandle();
                    loc = p.getEyeLocation();
                }
                range = ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            } else if (args.length == 3) {
                mcp = Static.GetPlayer((String)args[0].val(), (Target)t);
                p = (Player)mcp.getHandle();
                if (args[1] instanceof CArray) {
                    loc = (Location)ObjectGenerator.GetGenerator().location(args[1], mcp.getWorld(), t).getHandle();
                    range = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                } else {
                    loc = p.getEyeLocation();
                    range = ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
                    raySize = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                }
            } else {
                mcp = Static.GetPlayer((String)args[0].val(), (Target)t);
                p = (Player)mcp.getHandle();
                loc = (Location)ObjectGenerator.GetGenerator().location(args[1], mcp.getWorld(), t).getHandle();
                range = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                raySize = ArgumentValidation.getDouble((Mixed)args[3], (Target)t);
            }
            if (range == 0.0) {
                throw new CRERangeException("Range cannot be zero!", t);
            }
            range = Math.min(range, (double)Minecraft.VIEW_DISTANCE);
            double yaw = Math.toRadians(loc.getYaw() + 90.0f);
            double pitch = Math.toRadians(-loc.getPitch());
            Vector dir = new Vector(Math.cos(yaw) * Math.cos(pitch), Math.sin(pitch), Math.sin(yaw) * Math.cos(pitch));
            RayTraceResult blockResult = loc.getWorld().rayTraceBlocks(loc, dir, range, FluidCollisionMode.NEVER, true);
            Vector start = loc.toVector();
            CArray hits = CArray.GetAssociativeArray((Target)t);
            if (blockResult != null) {
                end = blockResult.getHitPosition();
                hits.set("hitblock", (Mixed)CBoolean.TRUE, t);
                hits.set("block", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(blockResult.getHitBlock().getLocation()), false), t);
                BlockFace face = blockResult.getHitBlockFace();
                hits.set("hitface", (Mixed)(face == null ? CNull.NULL : new CString(face.name(), t)), t);
            } else {
                end = loc.toVector().add(dir.multiply(range));
                hits.set("hitblock", (Mixed)CBoolean.FALSE, t);
                hits.set("block", (Mixed)CNull.NULL, t);
                hits.set("hitface", (Mixed)CNull.NULL, t);
            }
            BukkitMCLocation blockHitPos = new BukkitMCLocation(end.toLocation(loc.getWorld()));
            hits.set("location", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)blockHitPos, false), t);
            hits.set("origin", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(loc)), t);
            BoundingBox aabb = new BoundingBox(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
            if (raySize != 0.0) {
                aabb.expand(raySize);
            }
            Collection validTargets = loc.getWorld().getNearbyEntities(aabb, entity -> entity instanceof LivingEntity && !entity.equals(p));
            CArray hitEntities = new CArray(t);
            for (Entity entity2 : validTargets) {
                RayTraceResult hitResult;
                BoundingBox boundingBox = entity2.getBoundingBox();
                if (raySize != 0.0) {
                    boundingBox.expand(raySize);
                }
                if ((hitResult = boundingBox.rayTrace(start, dir, range)) == null) continue;
                CArray entityhit = CArray.GetAssociativeArray((Target)t);
                BukkitMCLocation hitPos = new BukkitMCLocation(hitResult.getHitPosition().toLocation(loc.getWorld()));
                entityhit.set("uuid", (Mixed)new CString(entity2.getUniqueId().toString(), t), t);
                entityhit.set("location", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)hitPos, false), t);
                hitEntities.push((Mixed)entityhit, t);
            }
            hits.set("entities", (Mixed)hitEntities, t);
            return hits;
        }

        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        public String getName() {
            return "ray_trace";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2, 3, 4};
        }

        public String docs() {
            return "array {[player], [location], [range], [raySize]} Returns an array of result data from a ray trace from the player's eye location or the given location. Result array contains the following keys: 'hitblock' is whether or not a block was hit; 'hitface' is the block face that was hit (or null); 'block' is the location of the block that was hit (or null); 'location' contains the location where the ray trace ends; 'origin' contains the location where the ray trace starts (useful if you don't specify a location); 'entities' contains an array of hit entities where each array contains a 'location' key and 'uuid' key.";
        }
    }

    @api
    public static class psleep
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCLocation loc;
            MCPlayer p;
            boolean force = false;
            if (args.length > 1) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                loc = ObjectGenerator.GetGenerator().location(args[1], p.getWorld(), t);
                if (args.length == 3) {
                    force = ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
                }
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                loc = ObjectGenerator.GetGenerator().location(args[0], p.getWorld(), t);
            }
            if (force) {
                ((Player)p.getHandle()).sleep((Location)loc.getHandle(), true);
            } else {
                Minecraft.Sleep(p, loc, t);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "psleep";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {[playerName], location, [force]} Sets the player sleeping at the specified bed location. Optionally force sleeping even if player normally wouldn't be able to. If not forced, it will throws an exception when unsuccessful. The following conditions must be met for a player to sleep: the location must be a bed, the player must be near it, it must not be obstructed, it must be night and there must not be hostile mobs nearby.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class relative_teleport
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREException.class, CREFormatException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer player;
            String name = "";
            if (args.length > 1) {
                name = args[0].val();
            } else {
                player = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (player != null) {
                    name = player.getName();
                }
            }
            player = (CraftPlayer)Bukkit.getServer().getPlayer(name);
            if (player == null) {
                throw new CREPlayerOfflineException("No online player by that name.", t);
            }
            PlayerConnection connection = player.getHandle().c;
            if (!(args[args.length - 1] instanceof CArray)) {
                throw new CRECastException("Expecting an array at parameter " + args.length + " of set_ploc", t);
            }
            CArray ca = (CArray)args[args.length - 1];
            MCLocation l = ObjectGenerator.GetGenerator().location((Mixed)ca, null, t);
            if (!l.getWorld().getName().equals(player.getWorld().getName())) {
                throw new CREIllegalArgumentException("Cannot relative teleport to another world.", t);
            }
            double x = l.getX();
            double y = l.getY();
            double z = l.getZ();
            float yaw = l.getYaw();
            float pitch = l.getPitch();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(new BlockPosition(l.getBlockX(), l.getBlockY(), l.getBlockZ()));
            ((WorldServer)connection.p().dM()).l().a(TicketType.g, chunkcoordintpair, 1, (Object)connection.p().aj());
            player.eject();
            if (player.isSleeping()) {
                player.wakeup(true);
            }
            connection.teleport(x, y, z, yaw, pitch, EnumSet.allOf(RelativeMovement.class), PlayerTeleportEvent.TeleportCause.PLUGIN);
            connection.p().n(yaw);
            return CVoid.VOID;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public String getName() {
            return "relative_teleport";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], location} Sets the player location relative to where they are on their client. This can be used for smooth teleportation.";
        }
    }

    @api
    public static class set_entity_rotation
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CRELengthException.class, CRECastException.class, CREIllegalArgumentException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            net.minecraft.world.entity.Entity entity = Minecraft.GetEntity(Static.getEntity((Mixed)args[0], (Target)t));
            float yaw = (float)ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            if ((double)(yaw %= 360.0f) >= 180.0) {
                yaw -= 360.0f;
            } else if ((double)yaw < -180.0) {
                yaw += 360.0f;
            }
            if (args.length == 3) {
                float pitch = (float)ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                if ((double)pitch > 90.0) {
                    pitch = 90.0f;
                } else if ((double)pitch < -90.0) {
                    pitch = -90.0f;
                }
                entity.s(pitch);
            }
            entity.r(yaw);
            entity.n(yaw);
            return CVoid.VOID;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public String getName() {
            return "set_entity_rotation";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {entity, yaw, [pitch]} Sets an entity's yaw and pitch without teleporting or ejecting.";
        }
    }
}

