/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chnaughty;

import com.google.gson.JsonSyntaxException;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Collection;
import me.pseudoknight.chnaughty.NMS;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Functions {
    static final int VIEW_DISTANCE = Bukkit.getViewDistance() * 16;

    public static String docs() {
        return "Functions that lack a Bukkit or Spigot API interface.";
    }

    @api
    public static class set_entity_size
    extends AbstractFunction {
        public String getName() {
            return "set_entity_size";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "void {entity, width, height} Sets an entity's width and height. This is used for some types of collisions, but is not visual (see generic_scale attribute). This gets reset every time the entity's pose changes.";
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            float width = ArgumentValidation.getDouble32((Mixed)args[1], (Target)t);
            float height = ArgumentValidation.getDouble32((Mixed)args[2], (Target)t);
            MCEntity entity = Static.getEntity((Mixed)args[0], (Target)t);
            NMS.GetImpl().setEntitySize(entity, width, height);
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CRELengthException.class, CRECastException.class, CREIllegalArgumentException.class};
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }
    }

    @api
    public static class pswing_hand
    extends AbstractFunction {
        public String getName() {
            return "pswing_hand";
        }

        public String docs() {
            return "void {[player], [hand]} Swing the player's hand in an attack animation. The hand parameter can be either main_hand (default) or off_hand. Note that this also triggers a player_interact event when the player is not hitting a block. The event will always have the action \"left_click_air\" and the hand \"main_hand\".";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            String hand = "main_hand";
            if (args.length == 2) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                hand = args[1].val().toLowerCase();
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                if (args.length == 1) {
                    hand = args[0].val().toLowerCase();
                }
            }
            Player player = (Player)p.getHandle();
            if (hand.isEmpty() || hand.equals("main_hand")) {
                player.swingMainHand();
            } else if (hand.equals("off_hand")) {
                player.swingOffHand();
            } else {
                throw new CREFormatException("Expected main_hand or off_hand but got \"" + hand + "\".", t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREFormatException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class set_pstinger_count
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CRECastException.class, CRERangeException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            int stingers;
            MCPlayer p;
            if (args.length == 2) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                stingers = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                stingers = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
            }
            NMS.GetImpl().setStingerCount(p, stingers, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "set_pstinger_count";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[player], count} Sets the amount of bee stingers in a player's model.";
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class set_parrow_count
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CRECastException.class, CRERangeException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            int arrowCount;
            MCPlayer p;
            int ticks = -1;
            if (args.length > 1) {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
                arrowCount = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
                if (args.length > 2) {
                    ticks = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
                }
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                arrowCount = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
            }
            Player player = (Player)p.getHandle();
            player.setArrowsInBody(arrowCount);
            if (ticks > -1) {
                player.setArrowCooldown(ticks);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "set_parrow_count";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {count | player, count, [ticks]} Sets the amount of arrows in a player's model. Optional number of ticks the arrow count will persist until arrows start despawning again. (default: 20 * (30 - count))";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class open_sign
    extends AbstractFunction {
        public String getName() {
            return "open_sign";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {[player], location, [side], [lines]} Opens a sign editor for the given sign location. The side is optional, and must be FRONT or BACK. (default FRONT) Lines must be an array with up to 4 values or null. If not provided, it'll use the existing lines. Throws CastException if not a sign block.";
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Mixed clocation;
            MCPlayer player;
            Mixed clines = null;
            Mixed cside = null;
            if (args.length == 4) {
                player = Static.GetPlayer((Mixed)args[0], (Target)t);
                clocation = args[1];
                cside = args[2];
                clines = args[3];
            } else if (args.length == 3) {
                if (args[0] instanceof CArray) {
                    player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                    Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                    clocation = args[0];
                    cside = args[1];
                    clines = args[2];
                } else if (args[2] instanceof CArray) {
                    player = Static.GetPlayer((Mixed)args[0], (Target)t);
                    clocation = args[1];
                    clines = args[2];
                } else {
                    player = Static.GetPlayer((Mixed)args[0], (Target)t);
                    clocation = args[1];
                    cside = args[2];
                }
            } else if (args.length == 2) {
                if (args[0] instanceof CArray) {
                    player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                    Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                    clocation = args[0];
                    if (args[1] instanceof CArray) {
                        clines = args[1];
                    } else {
                        cside = args[1];
                    }
                } else {
                    player = Static.GetPlayer((Mixed)args[0], (Target)t);
                    clocation = args[1];
                }
            } else {
                player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                clocation = args[0];
            }
            MCLocation signLoc = ObjectGenerator.GetGenerator().location(clocation, null, t);
            BlockState state = ((Location)signLoc.getHandle()).getBlock().getState();
            if (!(state instanceof Sign)) {
                throw new CRECastException("This location is not a sign.", t);
            }
            Sign sign = (Sign)state;
            Side side = Side.FRONT;
            if (cside != null) {
                try {
                    side = Side.valueOf((String)cside.val());
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Invalid sign side: " + cside.val(), t);
                }
            }
            if (clines != null) {
                SignSide signSide = sign.getSide(side);
                if (clines instanceof CArray) {
                    CArray array = (CArray)clines;
                    long max = Math.min(array.size(), 4L);
                    int i = 0;
                    while ((long)i < max) {
                        signSide.setLine(i, array.get(i, t).val());
                        ++i;
                    }
                    ((Player)player.getHandle()).sendBlockUpdate((Location)signLoc.getHandle(), (TileState)sign);
                } else if (clines != CNull.NULL) {
                    throw new CREFormatException("Expected lines to be an array.", t);
                }
            }
            try {
                ((Player)player.getHandle()).openSign((Sign)state, side);
            }
            catch (IllegalArgumentException ex) {
                throw new CREInvalidWorldException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREFormatException.class, CREInvalidWorldException.class, CRECastException.class, CREIndexOverflowException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class open_book
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREFormatException.class, CREIllegalArgumentException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Mixed data;
            MCPlayer player;
            if (args.length == 2) {
                player = Static.GetPlayer((Mixed)args[0], (Target)t);
                data = args[1];
            } else {
                player = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)player, (Target)t);
                data = args[0];
            }
            if (data instanceof CArray) {
                CArray pages = (CArray)data;
                ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
                BookMeta bookmeta = (BookMeta)book.getItemMeta();
                if (bookmeta == null) {
                    throw new CRENullPointerException("Book meta is null. This shouldn't happen and may be a problem with the server.", t);
                }
                int i = 0;
                while ((long)i < pages.size()) {
                    block14: {
                        String text = pages.get(i, t).val();
                        if (!(text.isEmpty() || text.charAt(0) != '[' && text.charAt(0) != '{')) {
                            try {
                                bookmeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{ComponentSerializer.parse((String)text)});
                                break block14;
                            }
                            catch (JsonSyntaxException | IllegalStateException throwable) {
                                // empty catch block
                            }
                        }
                        bookmeta.addPage(new String[]{text});
                    }
                    ++i;
                }
                bookmeta.setTitle(" ");
                bookmeta.setAuthor(" ");
                book.setItemMeta((ItemMeta)bookmeta);
                ((Player)player.getHandle()).openBook(book);
            } else {
                ItemStack book;
                if (data.val().equals("MAIN_HAND")) {
                    book = ((Player)player.getHandle()).getInventory().getItemInMainHand();
                } else if (data.val().equals("OFF_HAND")) {
                    book = ((Player)player.getHandle()).getInventory().getItemInMainHand();
                } else {
                    throw new CREIllegalArgumentException("Invalid hand: " + data.val(), t);
                }
                if (book.isEmpty() || book.getType() != Material.WRITTEN_BOOK) {
                    throw new CREIllegalArgumentException("No book in the given hand.", t);
                }
                ((Player)player.getHandle()).openBook(book);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "open_book";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[playerName], data} Sends a virtual book to a player. Accepts an array of pages or a hand that has a book to open. Each page can be either JSON or a plain text. If the JSON is not formatted correctly, it will fall back to string output per page. Throws IllegalArgumentException if no written book resides in the given hand.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class tps
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray tps2 = new CArray(t, 3);
            for (double d : NMS.GetImpl().getTPS()) {
                tps2.push((Mixed)new CDouble(Math.min((double)Math.round(d * 100.0) / 100.0, 20.0), t), t);
            }
            return tps2;
        }

        public String getName() {
            return "tps";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public String docs() {
            return "array {} Returns an array of average ticks per second over 5, 10 and 15 minutes.";
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class action_msg
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String message;
            String name = "";
            if (args.length == 2) {
                name = args[0].val();
                message = args[1].val();
            } else {
                MCCommandSender sender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetCommandSender();
                if (sender instanceof MCPlayer) {
                    name = sender.getName();
                }
                message = args[0].val();
            }
            MCPlayer player = Static.GetPlayer((String)name, (Target)t);
            BaseComponent txt = TextComponent.fromLegacy((String)message);
            ((Player)player.getHandle()).spigot().sendMessage(ChatMessageType.ACTION_BAR, txt);
            return CVoid.VOID;
        }

        public String getName() {
            return "action_msg";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[player], message} Sends a message to the action bar.";
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class ping
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            if (args.length == 1) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
            }
            return new CInt((long)((Player)p.getHandle()).getPing(), t);
        }

        public String getName() {
            return "ping";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "int {[player]} Gets the player's ping.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class ray_trace
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREFormatException.class, CRERangeException.class, CRECastException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Vector end;
            Location loc;
            Player p;
            double range = VIEW_DISTANCE;
            double raySize = 0.0;
            if (args.length == 0) {
                p = (Player)((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer().getHandle();
                loc = p.getEyeLocation();
            } else if (args.length == 1) {
                p = (Player)((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer().getHandle();
                range = ArgumentValidation.getDouble((Mixed)args[0], (Target)t);
                loc = p.getEyeLocation();
            } else if (args.length == 2) {
                if (args[0] instanceof CArray) {
                    p = null;
                    loc = (Location)ObjectGenerator.GetGenerator().location(args[0], null, t).getHandle();
                } else {
                    p = (Player)Static.GetPlayer((String)args[0].val(), (Target)t).getHandle();
                    loc = p.getEyeLocation();
                }
                range = ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
            } else if (args.length == 3) {
                mcp = Static.GetPlayer((String)args[0].val(), (Target)t);
                p = (Player)mcp.getHandle();
                if (args[1] instanceof CArray) {
                    loc = (Location)ObjectGenerator.GetGenerator().location(args[1], mcp.getWorld(), t).getHandle();
                    range = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                } else {
                    loc = p.getEyeLocation();
                    range = ArgumentValidation.getDouble((Mixed)args[1], (Target)t);
                    raySize = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                }
            } else {
                mcp = Static.GetPlayer((String)args[0].val(), (Target)t);
                p = (Player)mcp.getHandle();
                loc = (Location)ObjectGenerator.GetGenerator().location(args[1], mcp.getWorld(), t).getHandle();
                range = ArgumentValidation.getDouble((Mixed)args[2], (Target)t);
                raySize = ArgumentValidation.getDouble((Mixed)args[3], (Target)t);
            }
            if (range == 0.0) {
                throw new CRERangeException("Range cannot be zero!", t);
            }
            range = Math.min(range, (double)VIEW_DISTANCE);
            double yaw = Math.toRadians(loc.getYaw() + 90.0f);
            double pitch = Math.toRadians(-loc.getPitch());
            Vector dir = new Vector(Math.cos(yaw) * Math.cos(pitch), Math.sin(pitch), Math.sin(yaw) * Math.cos(pitch));
            RayTraceResult blockResult = loc.getWorld().rayTraceBlocks(loc, dir, range, FluidCollisionMode.NEVER, true);
            Vector start = loc.toVector();
            CArray hits = CArray.GetAssociativeArray((Target)t);
            if (blockResult != null) {
                end = blockResult.getHitPosition();
                hits.set("hitblock", (Mixed)CBoolean.TRUE, t);
                hits.set("block", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(blockResult.getHitBlock().getLocation()), false), t);
                BlockFace face = blockResult.getHitBlockFace();
                hits.set("hitface", (Mixed)(face == null ? CNull.NULL : new CString(face.name(), t)), t);
            } else {
                end = loc.toVector().add(dir.multiply(range));
                hits.set("hitblock", (Mixed)CBoolean.FALSE, t);
                hits.set("block", (Mixed)CNull.NULL, t);
                hits.set("hitface", (Mixed)CNull.NULL, t);
            }
            BukkitMCLocation blockHitPos = new BukkitMCLocation(end.toLocation(loc.getWorld()));
            hits.set("location", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)blockHitPos, false), t);
            hits.set("origin", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(loc)), t);
            BoundingBox aabb = new BoundingBox(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
            if (raySize != 0.0) {
                aabb.expand(raySize);
            }
            Collection validTargets = loc.getWorld().getNearbyEntities(aabb, entity -> entity instanceof LivingEntity && !entity.equals((Object)p));
            CArray hitEntities = new CArray(t);
            for (Entity entity2 : validTargets) {
                RayTraceResult hitResult;
                BoundingBox boundingBox = entity2.getBoundingBox();
                if (raySize != 0.0) {
                    boundingBox.expand(raySize);
                }
                if ((hitResult = boundingBox.rayTrace(start, dir, range)) == null) continue;
                CArray entityhit = CArray.GetAssociativeArray((Target)t);
                BukkitMCLocation hitPos = new BukkitMCLocation(hitResult.getHitPosition().toLocation(loc.getWorld()));
                entityhit.set("uuid", (Mixed)new CString(entity2.getUniqueId().toString(), t), t);
                entityhit.set("location", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)hitPos, false), t);
                hitEntities.push((Mixed)entityhit, t);
            }
            hits.set("entities", (Mixed)hitEntities, t);
            return hits;
        }

        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        public String getName() {
            return "ray_trace";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2, 3, 4};
        }

        public String docs() {
            return "array {[player], [location], [range], [raySize]} Returns an array of result data from a ray trace from the player's eye location or the given location. Result array contains the following keys: 'hitblock' is whether or not a block was hit; 'hitface' is the block face that was hit (or null); 'block' is the location of the block that was hit (or null); 'location' contains the location where the ray trace ends; 'origin' contains the location where the ray trace starts (useful if you don't specify a location); 'entities' contains an array of hit entities where each array contains a 'location' key and 'uuid' key.";
        }
    }

    @api
    public static class psleep
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCLocation loc;
            MCPlayer p;
            boolean force = false;
            if (args.length == 3) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                loc = ObjectGenerator.GetGenerator().location(args[1], p.getWorld(), t);
                force = ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
            } else if (args.length == 2) {
                if (args[0] instanceof CArray) {
                    p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                    Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                    loc = ObjectGenerator.GetGenerator().location(args[0], p.getWorld(), t);
                    force = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
                } else {
                    p = Static.GetPlayer((String)args[0].val(), (Target)t);
                    loc = ObjectGenerator.GetGenerator().location(args[1], p.getWorld(), t);
                }
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                loc = ObjectGenerator.GetGenerator().location(args[0], p.getWorld(), t);
            }
            try {
                boolean success = ((Player)p.getHandle()).sleep((Location)loc.getHandle(), force);
                if (!force && !success) {
                    throw new CREException("Cannot sleep in the bed.", t);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new CREException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "psleep";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {[player], location, [force]} Sets the player sleeping at the specified bed location. Optionally force sleeping even if player normally wouldn't be able to. If not forced, it will throw an exception when unsuccessful. The following conditions must be met for a player to sleep: the location must be a bed, the player must be near it, it must not be obstructed, it must be night and there must not be hostile mobs nearby.";
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class relative_teleport
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class, CREException.class, CREFormatException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Construct exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            if (args.length > 1) {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
            }
            if (!(args[args.length - 1] instanceof CArray)) {
                throw new CRECastException("Expecting an array at parameter " + args.length + " of set_ploc", t);
            }
            CArray ca = (CArray)args[args.length - 1];
            MCLocation l = ObjectGenerator.GetGenerator().location((Mixed)ca, null, t);
            if (!l.getWorld().getName().equals(p.getWorld().getName())) {
                throw new CREIllegalArgumentException("Cannot relative teleport to another world.", t);
            }
            NMS.GetImpl().relativeTeleport(p, l, t);
            return CVoid.VOID;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public String getName() {
            return "relative_teleport";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[player], location} Sets the player location relative to where they are on their client. This can be used for smooth teleportation.";
        }
    }
}

