/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chpaper;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;

public class PlayerFunctions {
    public static String docs() {
        return "Player functions using the Paper API.";
    }

    @api
    public static class get_firework_shooter
    extends AbstractFunction {
        public String getName() {
            return "get_firework_shooter";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "UUID {fireworkUUID} Returns the UUID for the entity that spawned this firework, or null if none exists.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Entity e = (Entity)Static.getEntity((Mixed)args[0], (Target)t).getHandle();
            if (!(e instanceof Firework)) {
                throw new CREBadEntityException("Entity is not a firework.", t);
            }
            UUID spawner = ((Firework)e).getSpawningEntity();
            if (spawner == null) {
                return CNull.NULL;
            }
            return new CString(spawner.toString(), t);
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class set_paffects_spawning
    extends AbstractFunction {
        public String getName() {
            return "set_paffects_spawning";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[player], boolean} Sets whether or not this player affects mob spawning.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            boolean doesAffect;
            MCPlayer p;
            if (args.length == 2) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
                doesAffect = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                doesAffect = ArgumentValidation.getBooleanObject((Mixed)args[0], (Target)t);
            }
            ((Player)p.getHandle()).setAffectsSpawning(doesAffect);
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class paffects_spawning
    extends AbstractFunction {
        public String getName() {
            return "paffects_spawning";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "boolean {[player]} Gets whether or not this player affects mob spawning.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            if (args.length == 1) {
                p = Static.GetPlayer((String)args[0].val(), (Target)t);
            } else {
                p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
            }
            return CBoolean.get((boolean)((Player)p.getHandle()).getAffectsSpawning());
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRELengthException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class pview_distance
    extends AbstractFunction {
        public String getName() {
            return "pview_distance";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "void {[player]} Gets view distance for player in chunks.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p;
            if (args.length == 0) {
                p = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
            } else {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
            }
            return new CInt((long)((Player)p.getHandle()).getViewDistance(), t);
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class set_pview_distance
    extends AbstractFunction {
        public String getName() {
            return "set_pview_distance";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[player], distance} Sets view distance for player in chunks. (2 - 32)";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            int distance;
            MCPlayer p;
            if (args.length == 1) {
                p = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                Static.AssertPlayerNonNull((MCPlayer)p, (Target)t);
                distance = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
            } else {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
                distance = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            }
            ((Player)p.getHandle()).setViewDistance(Math.min(Math.max(distance, 2), 32));
            return CVoid.VOID;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }
    }
}

