/*
 * Decompiled with CFR 0.152.
 */
package io.github.jb_aero.perms;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PermissionConvertor {
    public static CArray permission(Permission p, Target t) {
        CNull children;
        CArray ret = new CArray(t);
        ret.set("name", (Mixed)new CString(p.getName(), t), t);
        Object description = p.getDescription() == null ? CNull.NULL : new CString(p.getDescription(), t);
        ret.set("description", (Mixed)description, t);
        ret.set("default", (Mixed)new CString(p.getDefault().name(), t), t);
        if (p.getChildren() == null) {
            children = CNull.NULL;
        } else {
            CArray ca = new CArray(t);
            for (Map.Entry perm : p.getChildren().entrySet()) {
                ca.set((String)perm.getKey(), (Mixed)CBoolean.get((boolean)((Boolean)perm.getValue())), t);
            }
            children = ca;
        }
        ret.set("children", (Mixed)children, t);
        return ret;
    }

    public static Permission permission(Mixed c, Target t) {
        if (c instanceof CArray) {
            CArray ca = (CArray)c;
            String description = null;
            HashMap<String, Boolean> children = null;
            PermissionDefault def = Permission.DEFAULT_PERMISSION;
            if (!ca.containsKey("name")) {
                throw new CREFormatException("The array did not contain key 'name'", t);
            }
            String name = ca.get("name", t).val();
            if (ca.containsKey("default") && !(ca.get("default", t) instanceof CNull)) {
                try {
                    def = PermissionDefault.valueOf((String)ca.get("default", t).val());
                }
                catch (IllegalArgumentException iae) {
                    throw new CREFormatException("Default must be one of: " + StringUtils.Join((Object[])PermissionDefault.values(), (String)", ", (String)", or "), t);
                }
            }
            if (ca.containsKey("description") && !(ca.get("description", t) instanceof CNull)) {
                description = ca.get("description", t).val();
            }
            if (ca.containsKey("children") && !(ca.get("children", t) instanceof CNull)) {
                if (ca.get("children", t) instanceof CArray) {
                    children = new HashMap<String, Boolean>();
                    for (String key : ((CArray)ca.get("children", t)).stringKeySet()) {
                        children.put(key, ArgumentValidation.getBooleanObject((Mixed)ca, (Target)t));
                    }
                } else {
                    throw new CREFormatException("Key children was expected to be an array", t);
                }
            }
            return new Permission(name, description, def, children);
        }
        throw new CREFormatException("A permission array was expected", t);
    }
}

