/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.CHPexAPI;

import com.laytonsmith.annotations.api;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.CHPexAPI.CHPexFunctions;
import io.github.pieter12345.CHPexAPI.LifeCycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class CHPexGroupFunctions
extends CHPexFunctions {

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_group_children
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String world = args.length > 1 ? CHPexFunctions.convertStringArg(args[1], "world", t) : null;
            List permGroups = world == null || world.isEmpty() ? permGroup.getChildGroups() : permGroup.getChildGroups(world);
            CArray parents = new CArray(t);
            for (PermissionGroup child : permGroups) {
                parents.push((Mixed)new CString(child.getIdentifier(), t), t);
            }
            return parents;
        }

        public String docs() {
            return "array {group, [world]} Returns an array containing the names of all direct children of the given group, excluding world-specific children (groups that are only child of the given group in a specific world, other than the given world). The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group is empty. Throws NullPointerException when group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_remove_group_parent
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String group = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "parent", t);
            String world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            List parentNames = world != null && !world.isEmpty() ? permGroup.getOwnParentIdentifiers(world) : permGroup.getOwnParentIdentifiers();
            boolean removed = parentNames.remove(group);
            if (removed) {
                if (world != null && !world.isEmpty()) {
                    permGroup.setParentsIdentifier(parentNames, world);
                } else {
                    permGroup.setParentsIdentifier(parentNames);
                }
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, parent, [world]} Removes the given parent from the parent list of the given group in the given world or non-world specific if no world is given (affecting all worlds). The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or parent is empty. Throws NullPointerException when group or parent is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_add_group_parent
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String group = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "parent", t);
            String world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            List parentNames = world != null && !world.isEmpty() ? permGroup.getOwnParentIdentifiers(world) : permGroup.getOwnParentIdentifiers();
            boolean added = parentNames.add(group);
            if (added) {
                if (world != null && !world.isEmpty()) {
                    permGroup.setParentsIdentifier(parentNames, world);
                } else {
                    permGroup.setParentsIdentifier(parentNames);
                }
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, parent, [world]} Adds the given parent to the parent list of the given group in the given world or non-world specific if no world is given (affecting all worlds). The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or parent is empty. Throws NullPointerException when group or parent is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_group_parents
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            Mixed groups = args[1];
            if (groups instanceof CNull) {
                throw new CRENullPointerException("Parent array can not be null.", t);
            }
            if (!(groups instanceof CArray) || ((CArray)groups).isAssociative()) {
                throw new CRECastException("Expecting a non-associative array for parents. Received: " + String.valueOf(groups.typeof()) + ".", t);
            }
            CArray groupsArray = (CArray)groups;
            ArrayList<String> parentNames = new ArrayList<String>((int)groupsArray.size());
            for (Mixed group : groupsArray.asList()) {
                parentNames.add(CHPexFunctions.convertNonNullNonEmptyStringArg(group, "group", t));
            }
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permGroup.setParentsIdentifier(parentNames, world);
            } else {
                permGroup.setParentsIdentifier(parentNames);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, parentArray, [world]} Sets the parents of the given group in the given world or non-world specific if no world is given (affecting all worlds). The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or an element in parentArray is empty. Throws NullPointerException when group or an element in parentArray is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_group_parents
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String world = args.length > 1 ? CHPexFunctions.convertStringArg(args[1], "world", t) : null;
            List permGroups = world == null || world.isEmpty() ? permGroup.getOwnParents() : permGroup.getOwnParents(world);
            CArray parents = new CArray(t);
            for (PermissionGroup parent : permGroups) {
                parents.push((Mixed)new CString(parent.getIdentifier(), t), t);
            }
            return parents;
        }

        public String docs() {
            return "array {group, [world]} Returns an array containing the names of all direct parents of the given group, excluding world-specific parents. When world is given, all parents specific to that world are added to the return array. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group is empty. Throws NullPointerException when group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_group_users
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String world = args.length > 1 ? CHPexFunctions.convertStringArg(args[1], "world", t) : null;
            Set permUsers = world == null || world.isEmpty() ? permGroup.getUsers() : permGroup.getUsers(world);
            CArray groupUsers = new CArray(t);
            for (PermissionUser groupMember : permUsers) {
                groupUsers.push((Mixed)new CString(groupMember.getIdentifier(), t), t);
            }
            return groupUsers;
        }

        public String docs() {
            return "array {group, [world]} Returns an array containing the identifiers (name/uuid) of all players in the given group (excluding through inheritance). If the world is given, only members who are member of the given group in the given world are returned. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group is empty. Throws NullPointerException when group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_remove_group_permission
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String perm = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "permission", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permGroup.removePermission(perm, world);
            } else {
                permGroup.removePermission(perm);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, permission, [world]} Removes the given permissions from the given group in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or permission is empty. Throws NullPointerException when group or permission is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_add_group_permission
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String perm = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "permission", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permGroup.addPermission(perm, world);
            } else {
                permGroup.addPermission(perm);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, permission, [world]} Adds the given permissions to the given group in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or permission is empty. Throws NullPointerException when group or permission is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_group_permissions
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            if (!(args[1] instanceof CArray)) {
                throw new CRECastException("Expecting the second argument of " + this.getName() + "(group, permissionArray) to be an array, but found: " + String.valueOf(args[1].typeof()) + ".", t);
            }
            CArray permsArray = (CArray)args[1];
            if (permsArray.isAssociative()) {
                throw new CREIllegalArgumentException("Expecting the second argument of " + this.getName() + "(group, permissionArray) to be a non-associative array.", t);
            }
            ArrayList<String> permsList = new ArrayList<String>();
            for (Mixed perm : permsArray.asList()) {
                permsList.add(CHPexFunctions.convertNonNullNonEmptyStringArg(perm, "permission", t));
            }
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permGroup.setPermissions(permsList, world);
            } else {
                permGroup.setPermissions(permsList);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, permissionArray, [world]} Sets the given permissions for the given group in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or one of the permissions is empty. Throws NullPointerException when group or one of the permissions is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_group_permissions
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            CArray ret = CArray.GetAssociativeArray((Target)t);
            for (Map.Entry permissionsEntry : permGroup.getAllPermissions().entrySet()) {
                CArray perms = new CArray(t);
                for (String perm : (List)permissionsEntry.getValue()) {
                    perms.push((Mixed)new CString(perm, t), t);
                }
                ret.set((String)permissionsEntry.getKey(), (Mixed)perms, t);
            }
            return ret;
        }

        public String docs() {
            return "array {group} Returns all permissions of the given group in an associative array in format: array('': permissionsArray, 'worldName': permissionsArray) where permissionsArray is an array of permission strings. This does NOT include permissions a group has through inheritance of other groups. Throws IllegalArgumentException when group is empty. Throws NullPointerException when group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_group_option
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            String optionKey = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "optionKey", t);
            String optionValue = CHPexFunctions.convertStringArg(args[2], "optionValue", t);
            String string = world = args.length > 3 ? CHPexFunctions.convertStringArg(args[3], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permGroup.setOption(optionKey, optionValue, world);
            } else {
                permGroup.setOption(optionKey, optionValue);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {group, optionKey, optionValue, [world]} Sets the given option for the given group in the given or all worlds. Option keys used by Pex are: default, prefix and suffix. Setting the value to null will remove the option from the group. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when group or optionKey is empty. Throws NullPointerException when group or optionKey is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_group_options
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionGroup permGroup = CHPexFunctions.getPexGroup(args[0], t);
            CArray ret = CArray.GetAssociativeArray((Target)t);
            for (Map.Entry optionEntry : permGroup.getAllOptions().entrySet()) {
                CArray cOptionList = CArray.GetAssociativeArray((Target)t);
                for (Map.Entry entry : ((Map)optionEntry.getValue()).entrySet()) {
                    cOptionList.set((String)entry.getKey(), (String)entry.getValue(), t);
                }
                ret.set((String)optionEntry.getKey(), (Mixed)cOptionList, t);
            }
            return ret;
        }

        public String docs() {
            return "array {group} Returns all options of the given group in an associative array in format: array('': optionArray, 'worldName': optionArray) where optionArray is an associative array with possible keys default, prefix and suffix. Throws IllegalArgumentException when group is empty. Throws NullPointerException when group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_groups
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            CArray ret = new CArray(t);
            for (PermissionGroup permGroup : PermissionsEx.getPermissionManager().getGroupList()) {
                ret.push((Mixed)new CString(permGroup.getIdentifier(), t), t);
            }
            return ret;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public String docs() {
            return "array {} Returns an array containing all groups in the pex config.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }
    }
}

