/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.CHPexAPI;

import com.laytonsmith.annotations.api;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.CHPexAPI.CHPexFunctions;
import io.github.pieter12345.CHPexAPI.LifeCycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class CHPexUserFunctions
extends CHPexFunctions {

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_remove_user_group
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String group = CHPexFunctions.convertNonNullStringArg(args[1], "group", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.removeGroup(group, world);
            } else {
                permUser.removeGroup(group);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, group, [world]} Removes the given player/uuid from the given group in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or group is empty. Throws NullPointerException when player/uuid or group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_add_user_group
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String group = CHPexFunctions.convertNonNullStringArg(args[1], "group", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.addGroup(group, world);
            } else {
                permUser.addGroup(group);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, group, [world]} Adds the given player/uuid to the given group in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or group is empty. Throws NullPointerException when player/uuid or group is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_user_groups
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            Mixed groups = args[1];
            if (groups instanceof CNull) {
                throw new CRENullPointerException("Groups array can not be null.", t);
            }
            if (!(groups instanceof CArray) || ((CArray)groups).isAssociative()) {
                throw new CRECastException("Expecting a non-associative array for groups. Received: " + String.valueOf(groups.typeof()) + ".", t);
            }
            CArray groupsArray = (CArray)groups;
            ArrayList<String> parentNames = new ArrayList<String>((int)groupsArray.size());
            for (Mixed group : groupsArray.asList()) {
                parentNames.add(CHPexFunctions.convertNonNullNonEmptyStringArg(group, "group", t));
            }
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.setParentsIdentifier(parentNames, world);
            } else {
                permUser.setParentsIdentifier(parentNames);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, groupArray, [world]} Sets the groups for the given player/uuid in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or a group in the groupArray is empty. Throws NullPointerException when player/uuid or a group in the groupArray is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_user_groups
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            boolean specificOnly;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String world = args.length > 1 ? CHPexFunctions.convertStringArg(args[1], "world", t) : null;
            boolean bl = specificOnly = args.length > 2 ? CHPexFunctions.convertBooleanArg(args[2], "specificOnly", t) : false;
            List permGroups = specificOnly ? (world == null || world.isEmpty() ? permUser.getOwnParentIdentifiers() : permUser.getOwnParentIdentifiers(world)) : (world == null || world.isEmpty() ? permUser.getParentIdentifiers() : permUser.getParentIdentifiers(world));
            CArray userGroups = new CArray(t);
            for (String permGroup : permGroups) {
                userGroups.push((Mixed)new CString(permGroup, t), t);
            }
            return userGroups;
        }

        public String docs() {
            return "array {player/uuid, [world, [specificOnly]]} Returns an array containing all groups the player/uuid has in the given world. There are three types of groups: default (from group configs), global (personal user config) and world-specific (personal user config). When 'world' is non-empty, the world-specific groups are included. When 'world' is empty, the global groups are included. 'world' defaults to ''. When 'specificOnly' is false, the global groups are included. When 'specificOnly' is false and no groups have been included so far, default groups are included. 'specificOnly' defaults to false. Throws IllegalArgumentException when player/uuid is empty. Throws NullPointerException when player/uuid is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_remove_user_permission
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String perm = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "permission", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.removePermission(perm, world);
            } else {
                permUser.removePermission(perm);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, permission, [world]} Removes the given permissions from the given player/uuid in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or permission is empty. Throws NullPointerException when player/uuid or permission is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_add_user_permission
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String perm = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "permission", t);
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.addPermission(perm, world);
            } else {
                permUser.addPermission(perm);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, permission, [world]} Adds the given permissions to the given player/uuid in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or permission is empty. Throws NullPointerException when player/uuid or permission is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_user_permissions
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            if (!(args[1] instanceof CArray)) {
                throw new CRECastException("Expecting the second argument of " + this.getName() + "(player/uuid, permissionArray) to be an array, but found: " + String.valueOf(args[1].typeof()) + ".", t);
            }
            CArray permsArray = (CArray)args[1];
            if (permsArray.isAssociative()) {
                throw new CREIllegalArgumentException("Expecting the second argument of " + this.getName() + "(player/uuid, permissionArray) to be a non-associative array.", t);
            }
            ArrayList<String> permsList = new ArrayList<String>();
            for (Mixed perm : permsArray.asList()) {
                permsList.add(CHPexFunctions.convertNonNullNonEmptyStringArg(perm, "permission", t));
            }
            String string = world = args.length > 2 ? CHPexFunctions.convertStringArg(args[2], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.setPermissions(permsList, world);
            } else {
                permUser.setPermissions(permsList);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, permissionArray, [world} Sets the given permissions for the given player/uuid in the given or all worlds. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or one of the permissions is empty. Throws NullPointerException when player/uuid or one of the permissions is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_user_permissions
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            CArray ret = CArray.GetAssociativeArray((Target)t);
            for (Map.Entry permissionsEntry : permUser.getAllPermissions().entrySet()) {
                CArray perms = new CArray(t);
                for (String perm : (List)permissionsEntry.getValue()) {
                    perms.push((Mixed)new CString(perm, t), t);
                }
                ret.set((String)permissionsEntry.getKey(), (Mixed)perms, t);
            }
            return ret;
        }

        public String docs() {
            return "array {player/uuid} Returns an array containing all personal permissions the player/uuid has in format: array('': personalPermissions, 'worldName': personalPermissions). where personalPermissions is an array of permission strings. This does NOT include permissions a player/uuid has through groups. Throws IllegalArgumentException when player/uuid is empty. Throws NullPointerException when player/uuid is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_set_user_option
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String world;
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            String optionKey = CHPexFunctions.convertNonNullNonEmptyStringArg(args[1], "optionKey", t);
            String optionValue = CHPexFunctions.convertStringArg(args[2], "optionValue", t);
            String string = world = args.length > 3 ? CHPexFunctions.convertStringArg(args[3], "world", t) : null;
            if (world != null && !world.isEmpty()) {
                permUser.setOption(optionKey, optionValue, world);
            } else {
                permUser.setOption(optionKey, optionValue);
            }
            return CVoid.VOID;
        }

        public String docs() {
            return "void {player/uuid, optionKey, optionValue, [world]} Sets the given option for the given player/uuid in the given or all worlds. Option keys used by Pex are: name, prefix and suffix. Setting the value to null will remove the option from the player/uuid. The world argument will be ignored when it is null or empty. Throws IllegalArgumentException when player/uuid or optionKey is empty. Throws NullPointerException when player/uuid or optionKey is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_user_options
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            PermissionUser permUser = CHPexFunctions.getPexUser(args[0], t);
            CArray ret = CArray.GetAssociativeArray((Target)t);
            for (Map.Entry optionEntry : permUser.getAllOptions().entrySet()) {
                CArray cOptionList = CArray.GetAssociativeArray((Target)t);
                for (Map.Entry entry : ((Map)optionEntry.getValue()).entrySet()) {
                    cOptionList.set((String)entry.getKey(), (String)entry.getValue(), t);
                }
                ret.set((String)optionEntry.getKey(), (Mixed)cOptionList, t);
            }
            return ret;
        }

        public String docs() {
            return "array {player/uuid} Returns all personal options of the given player/uuid in an associative array in format: array('': optionArray, 'worldName': optionArray) where optionArray is an associative array with possible keys name, prefix and suffix. Throws IllegalArgumentException when player/uuid is empty. Throws NullPointerException when player/uuid is null.";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class pex_get_users
    extends LifeCycle.PexFunction {
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Static.checkPlugin((String)"PermissionsEx", (Target)t);
            CArray ret = new CArray(t);
            for (PermissionUser permUser : PermissionsEx.getPermissionManager().getUsers()) {
                ret.push((Mixed)new CString(permUser.getIdentifier(), t), t);
            }
            return ret;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public String docs() {
            return "array {} Returns an array containing all players/uuids in the pex config.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }
    }
}

