/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.extensions.chsc;

import com.entityreborn.communication.Exceptions;
import com.entityreborn.communication.NodePoint;
import com.entityreborn.communication.Publisher;
import com.entityreborn.communication.Subscriber;
import com.entityreborn.communication.Util;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.MSExtension;
import com.laytonsmith.extensions.chsc.Events;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.zeromq.ZAuth;
import org.zeromq.ZCertStore;
import org.zeromq.ZContext;

@MSExtension(value="CHServerCommunication")
public class Tracking
extends AbstractExtension {
    private static File certDir;
    private static Version VERSION;
    private static final Map<String, NodePoint> nodes;
    public static ZContext context;
    public static ZAuth authentication;

    public void onStartup() {
        context = new ZContext(1);
        authentication = new ZAuth(context, (ZCertStore.Fingerprinter)new ZCertStore.Hasher());
        authentication.setVerbose(true);
        certDir = new File(this.getConfigDir(), "certs");
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        Static.getLogger().log(Level.INFO, "CHServerCommunication " + VERSION + " loaded.");
    }

    public void onShutdown() {
        Set<String> keys = nodes.keySet();
        for (String key : keys) {
            NodePoint pub = nodes.get(key);
            pub.stop();
        }
        nodes.clear();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Static.getLogger().log(Level.SEVERE, null, ex);
        }
        if (authentication != null) {
            authentication.destroy();
            authentication = null;
        }
        if (context != null) {
            context.destroy();
            context = null;
        }
        Static.getLogger().log(Level.INFO, "CHServerCommunication " + VERSION + " unloaded.");
    }

    public static ZAuth getAuthenticator() {
        return authentication;
    }

    public static void setAuthenticator(ZAuth auth) {
        authentication = auth;
    }

    public static void configureCurve() {
        authentication.configureCurve(certDir.getAbsolutePath());
    }

    public static ZContext getContext() {
        return context;
    }

    public static void setContext(ZContext ctx) {
        context = ctx;
    }

    public static boolean hasPublisher(String name) throws Exceptions.InvalidNameException {
        if (!Util.isValidName(name)) {
            throw new Exceptions.InvalidNameException(name);
        }
        return nodes.containsKey(name);
    }

    public static boolean hasSubscriber(String name) throws Exceptions.InvalidNameException {
        if (!Util.isValidName(name)) {
            throw new Exceptions.InvalidNameException(name);
        }
        return nodes.containsKey(name) && nodes.get(name) instanceof Publisher;
    }

    public static NodePoint getNode(String name) throws Exceptions.InvalidNameException {
        if (!Util.isValidName(name)) {
            throw new Exceptions.InvalidNameException(name);
        }
        return nodes.get(name);
    }

    public static NodePoint getOrCreate(final DaemonManager daemon, int type, String name) throws Exceptions.InvalidNameException {
        if (!Util.isValidName(name)) {
            throw new Exceptions.InvalidNameException(name);
        }
        NodePoint retn = Tracking.getNode(name);
        if (retn != null) {
            return retn;
        }
        if (type == 1) {
            Publisher pub = new Publisher(name);
            pub.init(context);
            nodes.put(name, pub);
            return pub;
        }
        if (type == 2) {
            Subscriber sub = new Subscriber(name);
            sub.init(context);
            nodes.put(name, sub);
            sub.addCallback(new Subscriber.MessageCallback(){

                @Override
                public void process(String subscriber, String channel, String publisher, String message) {
                    Events.fireReceived(daemon, subscriber, channel, publisher, message);
                }
            });
            return sub;
        }
        MSLog.GetLogger().i((MSLog.Tag)MSLog.Tags.RUNTIME, name + " was not created!", Target.UNKNOWN);
        return retn;
    }

    public static boolean close(String name) throws Exceptions.InvalidNameException {
        if (!Util.isValidName(name)) {
            throw new Exceptions.InvalidNameException(name);
        }
        NodePoint node = Tracking.getNode(name);
        if (node != null) {
            nodes.remove(name);
            node.stop();
            return true;
        }
        return false;
    }

    public Version getVersion() {
        return new SimpleVersion(0, 0, 4);
    }

    static {
        VERSION = new SimpleVersion(0, 0, 5);
        nodes = new HashMap<String, NodePoint>();
    }
}

