/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.communication;

import com.entityreborn.communication.Exceptions;
import com.entityreborn.communication.NodePoint;
import com.laytonsmith.extensions.chsc.Tracking;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zeromq.ZAuth;
import org.zeromq.ZCertStore;
import org.zeromq.ZContext;

public class Subscriber
extends NodePoint
implements Runnable {
    private final Set<MessageCallback> callbacks = Collections.synchronizedSet(new HashSet());
    private final String name;

    public Subscriber(String name) {
        this.owningThread = new Thread((Runnable)this, "subscriber-" + name);
        this.name = name;
    }

    public void init(ZContext context) {
        super.init(context, 2);
    }

    public void addCallback(MessageCallback toRun) {
        this.callbacks.add(toRun);
    }

    public void remCallback(MessageCallback toRun) {
        this.callbacks.remove(toRun);
    }

    @Override
    public void connect(String endpoint) {
        super.connect(endpoint);
        this.socket.subscribe("");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted() && this.alive) {
            Object obj;
            String recv;
            try {
                String raw = this.socket.recvStr(1);
                if (raw == null) {
                    Thread.sleep(5L);
                    continue;
                }
                recv = raw.trim();
            }
            catch (Exception e) {
                break;
            }
            if (recv.isEmpty()) continue;
            JSONParser parser = new JSONParser();
            try {
                obj = parser.parse(recv);
            }
            catch (ParseException ex) {
                Logger.getLogger(Subscriber.class.getName()).log(Level.WARNING, "Malformed packet received. Skipping.");
                continue;
            }
            JSONObject data = (JSONObject)obj;
            if (!(data.containsKey((Object)"channel") && data.containsKey((Object)"publisherid") && data.containsKey((Object)"message"))) {
                Logger.getLogger(Subscriber.class.getName()).log(Level.WARNING, "Malformed packet received. JSON object missing channel, publisherid or message component. Skipping.");
                continue;
            }
            String channel = data.get((Object)"channel").toString();
            String identifier = data.get((Object)"publisherid").toString();
            String message = data.get((Object)"message").toString();
            for (MessageCallback toRun : this.callbacks) {
                try {
                    toRun.process(this.name, channel, identifier, message);
                }
                catch (Exception ex) {
                    Logger.getLogger(Subscriber.class.getName()).log(Level.SEVERE, "Error processing callback", ex);
                }
            }
        }
        this.cleanup();
    }

    public static void main(String[] args) throws InterruptedException, Exceptions.InvalidChannelException, Exceptions.InvalidNameException {
        ZContext context = new ZContext(1);
        ZAuth auth = new ZAuth(context, (ZCertStore.Fingerprinter)new ZCertStore.Hasher());
        auth.setVerbose(true);
        Tracking.setContext(context);
        Tracking.setAuthenticator(auth);
        NodePoint np = Tracking.getOrCreate(null, 2, "subscriber");
        Subscriber sub = (Subscriber)np;
        Tracking.getAuthenticator().configureCurve("C:\\temp\\certs");
        sub.getSocket().setCurvePublicKey("*!!G^&m%iDVXWGB>V7g$j$>9%C%JmXTefszSnXyU".getBytes());
        sub.getSocket().setCurveSecretKey("Om]m<Khew8d*5[bML4R5St$Gkmt2LN*UM4TTXKjL".getBytes());
        sub.getSocket().setCurveServerKey("lN*r8I=:FuY@FZ&Mdn]HoOE!v@jx7kJ##Pf{S9>l".getBytes());
        sub.init(context);
        sub.connect("tcp://localhost:5556");
        sub.start();
        sub.addCallback(new MessageCallback(){

            @Override
            public void process(String subscriber, String channel, String publisher, String message) {
                String msg = "Received %s from %s on channel %s";
                System.out.println(String.format(msg, message, publisher, channel));
            }
        });
        Thread.sleep(10000L);
        sub.stop();
        auth.destroy();
        context.destroy();
    }

    public static interface MessageCallback {
        public void process(String var1, String var2, String var3, String var4);
    }
}

