/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chspigot.abstraction.bukkit;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.annotations.abstraction;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import me.pseudoknight.chspigot.abstraction.MCEntityDismountEvent;
import me.pseudoknight.chspigot.abstraction.MCEntityMountEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityMountEvent;

public class BukkitMountListener
implements Listener {
    private static BukkitMountListener listener;

    public static void register() {
        if (listener == null) {
            listener = new BukkitMountListener();
        }
        CommandHelperPlugin.self.registerEvents((Listener)listener);
    }

    public static void unregister() {
        EntityMountEvent.getHandlerList().unregister((Listener)listener);
        EntityDismountEvent.getHandlerList().unregister((Listener)listener);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDismount(EntityDismountEvent event) {
        BukkitEntityDismountEvent bede = new BukkitEntityDismountEvent((Event)event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"entity_dismount", (BindableEvent)bede);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityMount(EntityMountEvent event) {
        BukkitEntityMountEvent beme = new BukkitEntityMountEvent((Event)event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"entity_mount", (BindableEvent)beme);
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitEntityDismountEvent
    implements MCEntityDismountEvent {
        EntityDismountEvent e;

        public BukkitEntityDismountEvent(Event e) {
            this.e = (EntityDismountEvent)e;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.e.getEntity());
        }

        @Override
        public MCEntity getDismounted() {
            return new BukkitMCEntity(this.e.getDismounted());
        }

        public Object _GetObject() {
            return this.e;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitEntityMountEvent
    implements MCEntityMountEvent {
        EntityMountEvent e;

        public BukkitEntityMountEvent(Event e) {
            this.e = (EntityMountEvent)e;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.e.getEntity());
        }

        @Override
        public MCEntity getMount() {
            return new BukkitMCEntity(this.e.getMount());
        }

        public Object _GetObject() {
            return this.e;
        }
    }
}

