/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.CHStargate;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import me.pseudoknight.CHStargate.abstraction.CHStargateAccessEvent;
import me.pseudoknight.CHStargate.abstraction.CHStargateDestroyEvent;
import me.pseudoknight.CHStargate.abstraction.CHStargateOpenEvent;
import me.pseudoknight.CHStargate.abstraction.CHStargatePortalEvent;

public class CHEvents {

    @api
    public static class stargate_portal
    extends StargateEvent {
        public String getName() {
            return "stargate_portal";
        }

        public String docs() {
            return "{} Fired when a Stargate portal is traversed. {player: The player traveling. | portal: The Stargate portal's name. | network: The Stargate network this portal belongs to. | exit: The exit location. | exitportal: The name of portal at the exit.}{exit: A different exit location.} {} ";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            return true;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            CHStargatePortalEvent e = (CHStargatePortalEvent)event;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("player", (Mixed)new CString(e.getPlayer().getName(), t));
            map.put("portal", (Mixed)new CString(e.getPortal().getName(), t));
            map.put("network", (Mixed)new CString(e.getPortal().getNetwork(), t));
            map.put("exitportal", (Mixed)new CString(e.getDestination().getName(), t));
            map.put("exit", (Mixed)ObjectGenerator.GetGenerator().location(e.getExit()));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            if (event instanceof CHStargatePortalEvent) {
                CHStargatePortalEvent e = (CHStargatePortalEvent)event;
                if (key.equalsIgnoreCase("exit")) {
                    e.setExit(ObjectGenerator.GetGenerator().location(value, null, value.getTarget()));
                    return true;
                }
            }
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class stargate_open
    extends StargateEvent {
        public String getName() {
            return "stargate_open";
        }

        public String docs() {
            return "{} Fired when a Stargate portal is opened. {player: The player opening the portal, if one. | portal: The Stargate portal's name. | network: The Stargate network this portal belongs to.}{} {} ";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            return true;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            CHStargateOpenEvent e = (CHStargateOpenEvent)event;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            MCPlayer p = e.getPlayer();
            if (p != null) {
                map.put("player", (Mixed)new CString(p.getName(), Target.UNKNOWN));
            }
            map.put("portal", (Mixed)new CString(e.getPortal().getName(), Target.UNKNOWN));
            map.put("network", (Mixed)new CString(e.getPortal().getNetwork(), Target.UNKNOWN));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    public static class stargate_access
    extends StargateEvent {
        public String getName() {
            return "stargate_access";
        }

        public String docs() {
            return "{<boolean> deny: Whether access was denied or not. } Fired when a player interacts with a Stargate. Result determines access. {player: The player requesting access. | portal: The Stargate portal's name. | network: The Stargate network this portal belongs to.}{} {} ";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            Prefilters.match(prefilter, (String)"deny", (boolean)((CHStargateAccessEvent)e).getDeny(), (Prefilters.PrefilterType)Prefilters.PrefilterType.BOOLEAN_MATCH);
            return true;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            CHStargateAccessEvent e = (CHStargateAccessEvent)event;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("player", (Mixed)new CString(e.getPlayer().getName(), Target.UNKNOWN));
            map.put("portal", (Mixed)new CString(e.getPortal().getName(), Target.UNKNOWN));
            map.put("network", (Mixed)new CString(e.getPortal().getNetwork(), Target.UNKNOWN));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public void cancel(BindableEvent e, boolean state) {
            ((CHStargateAccessEvent)e).setDeny(state);
        }
    }

    @api
    public static class stargate_destroy
    extends StargateEvent {
        public String getName() {
            return "stargate_destroy";
        }

        public String docs() {
            return "{deny: <boolean> Whether access was denied or not. } Fired when a block of a Stargate portal is broken. {player: The player that broke the block. | portal: The Stargate portal's name. | network: The Stargate network this portal belongs to.}{}  {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            Prefilters.match(prefilter, (String)"deny", (boolean)((CHStargateDestroyEvent)e).getDeny(), (Prefilters.PrefilterType)Prefilters.PrefilterType.BOOLEAN_MATCH);
            return true;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            CHStargateDestroyEvent e = (CHStargateDestroyEvent)event;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            map.put("player", (Mixed)new CString(e.getPlayer().getName(), Target.UNKNOWN));
            map.put("portal", (Mixed)new CString(e.getPortal().getName(), Target.UNKNOWN));
            map.put("network", (Mixed)new CString(e.getPortal().getNetwork(), Target.UNKNOWN));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public void cancel(BindableEvent e, boolean state) {
            ((CHStargateDestroyEvent)e).setDeny(state);
        }
    }

    protected static abstract class StargateEvent
    extends AbstractEvent {
        protected StargateEvent() {
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }
    }
}

