/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.CHStargate;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.UUID;
import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.Portal;

public class CHFunctions {
    public static String docs() {
        return "These functions allow you to interface with Stargate portals.";
    }

    @api
    public static class sg_get_portal_info
    extends StargateFunction {
        public String getName() {
            return "sg_get_portal_info";
        }

        public String docs() {
            return "array {portalName, portalNetwork} Gets an array of data about a specific Stargate portal. Throws NotFoundException if a portal was not found by that name on the specified network. Array keys are: button, sign, destination, frame, entrance, options, open, ownerUUID, and ownerName. Options array keys are: alwaysOn, backwards, free, hidden, noNetwork, private, random, and show.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Portal portal = Portal.getByName((String)args[0].val(), (String)args[1].val());
            if (portal == null) {
                throw new CRENotFoundException("Portal was not found.", t);
            }
            CArray arr = CArray.GetAssociativeArray((Target)t);
            Blox button = portal.getButton();
            if (button == null) {
                arr.set("button", (Mixed)CNull.NULL, t);
            } else {
                arr.set("button", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(button.getLocation()), false), t);
            }
            arr.set("sign", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(portal.getSign().getLocation()), false), t);
            Portal destination = portal.getDestination();
            if (destination == null) {
                arr.set("destination", (Mixed)CNull.NULL, t);
            } else {
                arr.set("destination", (Mixed)new CString(portal.getDestination().getName(), t), t);
            }
            CArray frame = new CArray(t);
            for (Blox b : portal.getFrame()) {
                frame.push((Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation((AbstractionObject)new BukkitMCLocation(b.getLocation())), false), t);
            }
            arr.set("frame", (Mixed)frame, t);
            CArray entrance = new CArray(t);
            for (Blox b : portal.getEntrances()) {
                entrance.push((Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation((AbstractionObject)new BukkitMCLocation(b.getLocation())), false), t);
            }
            arr.set("entrance", (Mixed)entrance, t);
            CArray options = CArray.GetAssociativeArray((Target)t);
            options.set("alwaysOn", (Mixed)CBoolean.get((boolean)portal.isAlwaysOn()), t);
            options.set("backwards", (Mixed)CBoolean.get((boolean)portal.isBackwards()), t);
            options.set("free", (Mixed)CBoolean.get((boolean)portal.isFree()), t);
            options.set("hidden", (Mixed)CBoolean.get((boolean)portal.isHidden()), t);
            options.set("noNetwork", (Mixed)CBoolean.get((boolean)portal.isNoNetwork()), t);
            options.set("private", (Mixed)CBoolean.get((boolean)portal.isPrivate()), t);
            options.set("random", (Mixed)CBoolean.get((boolean)portal.isRandom()), t);
            options.set("show", (Mixed)CBoolean.get((boolean)portal.isShown()), t);
            arr.set("options", (Mixed)options, t);
            arr.set("open", (Mixed)CBoolean.get((boolean)portal.isOpen()), t);
            UUID ownerUUID = portal.getOwnerUUID();
            if (ownerUUID == null) {
                arr.set("ownerUUID", (Mixed)CNull.NULL, t);
            } else {
                arr.set("ownerUUID", ownerUUID.toString(), t);
            }
            String ownerName = portal.getOwnerName();
            if (ownerName.equals("")) {
                arr.set("ownerName", (Mixed)CNull.NULL, t);
            } else {
                arr.set("ownerName", ownerName, t);
            }
            return arr;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class sg_is_portal_open
    extends StargateFunction {
        public String getName() {
            return "sg_is_portal_open";
        }

        public String docs() {
            return "boolean {portalName, portalNetwork} Returns whether the given portal is currently open.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Portal portal = Portal.getByName((String)args[0].val(), (String)args[1].val());
            if (portal == null) {
                throw new CRENotFoundException("Portal was not found.", t);
            }
            return CBoolean.get((boolean)portal.isOpen());
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class sg_set_owner
    extends StargateFunction {
        public String getName() {
            return "sg_set_owner";
        }

        public String docs() {
            return "boolean {portalName, portalNetwork, owner} Sets the portal's owner name. Accepts UUID or player name, though the former is preferred. Throws NotFoundException if a portal was not found by that name on the specified network.";
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Portal portal = Portal.getByName((String)args[0].val(), (String)args[1].val());
            String owner = args[2].val();
            if (portal == null) {
                throw new CRENotFoundException("Portal was not found.", t);
            }
            if (owner.length() > 16) {
                try {
                    portal.setOwner(UUID.fromString(owner));
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Invalid UUID format.", t);
                }
            } else {
                portal.setOwner(Static.getServer().getOfflinePlayer(owner).getUniqueID());
            }
            return CBoolean.TRUE;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CREFormatException.class};
        }
    }

    @api
    public static class sg_get_owner_uuid
    extends StargateFunction {
        public String getName() {
            return "sg_get_owner_uuid";
        }

        public String docs() {
            return "string {portalName, portalNetwork} Returns the portal's owner UUID. Will return null if there's no owner UUID for this portal. being an unowned portal or a legacy portal stored with a player name. Throws NotFoundException if a portal was not found by that name on the specified network.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Portal portal = Portal.getByName((String)args[0].val(), (String)args[1].val());
            UUID owner = null;
            if (portal == null) {
                throw new CRENotFoundException("Portal was not found.", t);
            }
            owner = portal.getOwnerUUID();
            if (owner == null) {
                return CNull.NULL;
            }
            return new CString(owner.toString(), t);
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class sg_get_owner_name
    extends StargateFunction {
        public String getName() {
            return "sg_get_owner_name";
        }

        public String docs() {
            return "string {portalName, portalNetwork} Returns the portal's owner name. Will return null if the portal does not have an owner. Throws NotFoundException if a portal was not found by that name on the specified network.";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Portal portal = Portal.getByName((String)args[0].val(), (String)args[1].val());
            String owner = "";
            if (portal == null) {
                throw new CRENotFoundException("Portal was not found.", t);
            }
            owner = portal.getOwnerName();
            if (owner.equals("")) {
                return CNull.NULL;
            }
            return new CString(owner, t);
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    protected static abstract class StargateFunction
    extends AbstractFunction {
        protected StargateFunction() {
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class};
        }
    }
}

