/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.chvault.functions;

import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.jbaero.chvault.CHVault;
import io.github.jbaero.chvault.EconServer;
import io.github.jbaero.chvault.EconomyWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Economy {
    private static EconomyWrapper economy;
    private static final HashMap<UUID, Account> accounts;

    private static void CheckInstallation() throws ConfigRuntimeException {
        boolean failure = true;
        try {
            economy.getName();
            failure = false;
        }
        catch (NullPointerException e) {
            economy = EconServer.getEconomy();
            boolean bl = failure = economy == null || !economy.isEnabled();
        }
        if (failure) {
            throw new CREInvalidPluginException("You are attempting to use an economy function, and your economy setup is not valid. Please install Vault and an Economy plugin before attempting to use any of the Economy functions.", Target.UNKNOWN);
        }
    }

    private static Account GetAccount(String fname, Target t, Mixed ... args) {
        MCOfflinePlayer found;
        UUID key;
        String identifier = args[0].val();
        if (identifier.length() == 32 || identifier.length() == 36) {
            key = Static.GetUUID((String)identifier, (Target)t);
            found = Static.getServer().getOfflinePlayer(key);
        } else {
            found = Static.GetUser((String)identifier, (Target)t);
            if (found == null) {
                throw new CRENotFoundException(fname + " could not get the offline player: " + identifier, t);
            }
            key = found.getUniqueID();
        }
        for (Map.Entry<UUID, Account> entry : accounts.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        if (found != null) {
            Account acc = new Account(found);
            accounts.put(key, acc);
            return acc;
        }
        throw new CREPluginInternalException(fname + " could not find account matching " + args[0].val(), t);
    }

    private static BankAccount GetBankAccount(Mixed id) {
        return new BankAccount(id.val());
    }

    public static String docs() {
        return "Provides functions to hook into the server's economy plugin. To use any of these functions, you must have a Vault compatible economy plugin installed in addition to the [https://github.com/MilkBowl/Vault Vault plugin]. Beyond this, there is no special setup to get the economy functions working, assuming they work for you in game using the plugin's default controls. Bank controls may not be supported in your particular plugin, check the details of that particular plugin.";
    }

    static {
        accounts = new HashMap();
    }

    private static class Account {
        MCOfflinePlayer user;

        private Account(MCOfflinePlayer name) {
            Economy.CheckInstallation();
            this.user = name;
        }

        private boolean SetBalance(double number) {
            double current = economy.getBalance(this.user);
            if (number < current) {
                return economy.withdrawPlayer(this.user, current - number).transactionSuccess();
            }
            return economy.depositPlayer(this.user, number - current).transactionSuccess();
        }

        private boolean divide(double number) {
            return this.SetBalance(this.balance() / number);
        }

        private boolean multiply(double number) {
            return this.SetBalance(this.balance() * number);
        }

        private boolean subtract(double number) {
            return this.SetBalance(this.balance() - number);
        }

        private boolean add(double number) {
            return this.SetBalance(this.balance() + number);
        }

        private boolean set(double number) {
            return this.SetBalance(number);
        }

        private double balance() {
            return economy.getBalance(this.user);
        }
    }

    private static class BankAccount {
        String bank_name;

        private BankAccount(String bank_name) {
            Economy.CheckInstallation();
            this.bank_name = bank_name;
        }

        private boolean SetBalance(double number) {
            double current = Economy.economy.bankBalance((String)this.bank_name).balance;
            if (number < current) {
                return economy.bankWithdraw(this.bank_name, current - number).transactionSuccess();
            }
            return economy.bankDeposit(this.bank_name, number - current).transactionSuccess();
        }

        private boolean remove() {
            return economy.deleteBank(this.bank_name).transactionSuccess();
        }

        private boolean divide(double number) {
            return this.SetBalance(this.balance() / number);
        }

        private boolean multiply(double number) {
            return this.SetBalance(this.balance() * number);
        }

        private boolean subtract(double number) {
            return this.SetBalance(this.balance() - number);
        }

        private boolean add(double number) {
            return this.SetBalance(this.balance() + number);
        }

        private boolean set(double number) {
            return this.SetBalance(number);
        }

        private double balance() {
            return Economy.economy.bankBalance((String)this.bank_name).balance;
        }
    }

    @api
    public static class bacc_remove
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_remove";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {bank_name} Removes the given bank account from the game";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class, CREInvalidPluginException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).remove()) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to remove the bank account " + args[0].val(), t);
        }
    }

    @api
    public static class bacc_divide
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_divide";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {bank_name, value} Divides the bank account's balance by the given value";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).divide(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to divide the balance on bank account " + args[0].val() + ":" + args[1].val(), t);
        }
    }

    @api
    public static class bacc_multiply
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_multiply";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {bank_name, value} Multiplies the given bank account's balance by the given value";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).multiply(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to multiply the balance on bank account " + args[0].val() + ":" + args[1].val(), t);
        }
    }

    @api
    public static class bacc_subtract
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_subtract";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {bank_name, value} Subtracts the specified amount from the bank account's balance";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).subtract(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to subtract from the balance on bank account " + args[0].val() + ":" + args[1].val(), t);
        }
    }

    @api
    public static class bacc_add
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_add";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {bank_name, value} Adds the specified amount to the bank account's balance";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).add(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to add to the balance on bank account " + args[0].val() + ":" + args[1].val(), t);
        }
    }

    @api
    public static class bacc_set
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_set";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {bank_name, value} Sets the bank account's balance to the given amount";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetBankAccount(args[0]).set(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to set the balance on bank account " + args[0].val() + ":" + args[1].val(), t);
        }
    }

    @api
    public static class bacc_balance
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "bacc_balance";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {bank_name} Gets the specified bank account's balance";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble(Economy.GetBankAccount(args[0]).balance(), t);
        }
    }

    @api
    public static class acc_divide
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_divide";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {account_name, to_divide} Divides the account by the given amount";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetAccount(this.getName(), t, args).divide(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to divide the balance on account " + args[0].val(), t);
        }
    }

    @api
    public static class acc_multiply
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_multiply";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {account_name, to_multiply} Multiplies the account balance by the given amount";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetAccount(this.getName(), t, args).multiply(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to multiply the balance on account " + args[0].val(), t);
        }
    }

    @api
    public static class acc_subtract
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_subtract";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {account_name, to_subtract} Subtracts the given amount from the specified account";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetAccount(this.getName(), t, args).subtract(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to subtract from the balance on account " + args[0].val(), t);
        }
    }

    @api
    public static class acc_add
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_add";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {account_name, to_add} Adds an amount to the specified account";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetAccount(this.getName(), t, args).add(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to add to the balance on account " + args[0].val(), t);
        }
    }

    @api
    public static class acc_set
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_set";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {account_name, value} Sets the account's balance to the given amount";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (Economy.GetAccount(this.getName(), t, args).set(ArgumentValidation.getNumber((Mixed)args[1], (Target)t))) {
                return CVoid.VOID;
            }
            throw new CREPluginInternalException("An error occurred when trying to set the balance on account " + args[0].val(), t);
        }
    }

    @api
    public static class acc_balance
    extends CHVault.jFunction {
        @Override
        public String getName() {
            return "acc_balance";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "double {account_name} Returns the balance of the given account name.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Account ma = Economy.GetAccount(this.getName(), t, args);
            return new CDouble(ma.balance(), t);
        }
    }
}

