/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.apache.oltu.oauth2.client;

import com.laytonsmith.libs.org.apache.oltu.oauth2.client.HttpClient;
import com.laytonsmith.libs.org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import com.laytonsmith.libs.org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import com.laytonsmith.libs.org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import com.laytonsmith.libs.org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import java.util.HashMap;

public class OAuthClient {
    protected HttpClient httpClient;

    public OAuthClient(HttpClient oauthClient) {
        this.httpClient = oauthClient;
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, "POST", responseClass);
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return (T)((OAuthAccessTokenResponse)this.httpClient.execute(request, headers, requestMethod, responseClass));
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, OAuthJSONAccessTokenResponse.class);
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request, String requestMethod) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, requestMethod, OAuthJSONAccessTokenResponse.class);
    }

    public <T extends OAuthClientResponse> T resource(OAuthClientRequest request, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        return this.httpClient.execute(request, null, requestMethod, responseClass);
    }

    public void shutdown() {
        this.httpClient.shutdown();
    }
}

