/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.natives.interfaces.Mixed;

public class Variable
extends Construct {
    public static final long serialVersionUID = 1L;
    private final String name;
    private String def;
    private boolean optional;
    private boolean finalVar;
    private CString varValue;

    public Variable(String name, String def, boolean optional, boolean finalVar, Target t) {
        super(name, Construct.ConstructType.VARIABLE, t);
        this.name = name;
        this.setDefault(def);
        this.finalVar = finalVar;
        this.optional = optional;
        this.varValue = new CString(def, t);
    }

    public Variable(String name, String def, Target t) {
        this(name, def, false, false, t);
    }

    @Override
    public String toString() {
        return "var:" + this.name;
    }

    public String getVariableName() {
        return this.name;
    }

    public void setFinal(boolean finalVar) {
        this.finalVar = finalVar;
    }

    public boolean isFinal() {
        return this.finalVar;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        if (def == null) {
            def = "";
        }
        this.def = def;
    }

    @Override
    public String val() {
        return this.varValue.toString();
    }

    public void setVal(CString val) {
        this.varValue = val;
    }

    public void setVal(String val) {
        this.varValue = new CString(val, this.getTarget());
    }

    @Override
    public Variable clone() throws CloneNotSupportedException {
        Variable clone = (Variable)super.clone();
        if (this.varValue != null) {
            clone.varValue = this.varValue;
        }
        return clone;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Version since() {
        return super.since();
    }

    @Override
    public String docs() {
        return super.docs();
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[0];
    }
}

