/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.DataSourceFilter;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.ThreadsafeDataSource;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PersistenceNetworkImpl
implements PersistenceNetwork {
    private DataSourceFilter filter;
    private ConnectionMixinFactory.ConnectionMixinOptions options;

    public PersistenceNetworkImpl(File configuration, URI defaultURI, ConnectionMixinFactory.ConnectionMixinOptions options) throws IOException, DataSourceException {
        this(FileUtil.read(PersistenceNetworkImpl.ensureCreated(configuration)), defaultURI, options);
    }

    private static File ensureCreated(File f) throws IOException {
        if (!f.exists()) {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            try {
                f.createNewFile();
            }
            catch (IOException ex) {
                throw new IOException("IOException when trying to create file: " + f.getAbsolutePath(), ex);
            }
        }
        return f;
    }

    public PersistenceNetworkImpl(String configuration, URI defaultURI, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        this.filter = new DataSourceFilter(configuration, defaultURI);
        this.options = options;
    }

    @Override
    public URI getKeySource(String[] key) {
        return this.filter.getConnection(key);
    }

    private DataSource getDataSource(URI uri) throws DataSourceException {
        return ThreadsafeDataSource.GetDataSource(uri, this.options);
    }

    @Override
    public synchronized String get(String[] key) throws DataSourceException, IllegalArgumentException {
        DataSource ds = this.getDataSource(this.filter.getConnection(key));
        return ds.get(key);
    }

    @Override
    public synchronized boolean set(DaemonManager dm, String[] key, String value) throws DataSourceException, ReadOnlyException, IOException, IllegalArgumentException {
        DataSource ds = this.getDataSource(this.filter.getConnection(key));
        return ds.set(dm, key, value);
    }

    @Override
    public synchronized boolean hasKey(String[] key) throws DataSourceException, IllegalArgumentException {
        DataSource ds = this.getDataSource(this.filter.getConnection(key));
        return ds.hasKey(key);
    }

    @Override
    public synchronized void clearKey(DaemonManager dm, String[] key) throws DataSourceException, ReadOnlyException, IOException, IllegalArgumentException {
        DataSource ds = this.getDataSource(this.filter.getConnection(key));
        ds.clearKey(dm, key);
    }

    @Override
    public void clearDatabase(DaemonManager dm) throws DataSourceException, ReadOnlyException, IOException {
        for (URI uri : this.filter.getAllConnections()) {
            DataSource ds = this.getDataSource(uri);
            ds.clearDatabase(dm);
        }
    }

    @Override
    public synchronized Map<String[], String> getNamespace(String[] namespace) throws DataSourceException, IllegalArgumentException {
        Set<URI> uris = this.filter.getAllConnections(namespace);
        HashMap<String[], String> map = new HashMap<String[], String>();
        for (URI uri : uris) {
            Map<String[], String> db = this.getDataSource(uri).getValues(namespace);
            for (String[] key : db.keySet()) {
                if (!this.filter.getConnection(key).equals(uri)) continue;
                map.put(key, db.get(key));
            }
        }
        return map;
    }
}

