/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.EnumConvertor;
import com.laytonsmith.annotations.abstractionenum;
import com.laytonsmith.core.Prefs;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public final class Implementation {
    private static Type serverType = null;
    private static boolean useAbstractEnumThread = true;

    private Implementation() {
    }

    public static void useAbstractEnumThread(boolean on) {
        useAbstractEnumThread = on;
    }

    public static void forceServerType(Type type) {
        serverType = type;
    }

    public static void setServerType(Type type) {
        if (serverType == null) {
            serverType = type;
        } else if (type != Type.TEST) {
            throw new RuntimeException("Server type is already set! Cannot re-set!");
        }
        if (type != Type.TEST && type != Type.SHELL && useAbstractEnumThread) {
            Thread abstractionenumsThread = new Thread(() -> {
                block11: {
                    try {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Set<Class<?>> abstractionenums = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(abstractionenum.class);
                        for (Class<?> c : abstractionenums) {
                            abstractionenum annotation = c.getAnnotation(abstractionenum.class);
                            if (EnumConvertor.class.isAssignableFrom(c)) {
                                try {
                                    if (annotation.implementation() != serverType) continue;
                                    Method m = c.getDeclaredMethod("getConvertor", new Class[0]);
                                    EnumConvertor convertor = (EnumConvertor)m.invoke(null, new Object[0]);
                                    Class<? extends Enum> abstractEnum = annotation.forAbstractEnum();
                                    Class<? extends Enum> concreteEnum = annotation.forConcreteEnum();
                                    Implementation.checkEnumConvertors(convertor, abstractEnum, concreteEnum, false);
                                    Implementation.checkEnumConvertors(convertor, concreteEnum, abstractEnum, true);
                                    continue;
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                                    throw new Error(ex);
                                }
                                catch (NoSuchMethodException ex) {
                                    throw new Error(serverType.getBranding() + ": The method with signature public static " + c.getName() + " getConvertor() was not found in " + c.getName() + " Please add the following code: \nprivate static " + c.getName() + " instance;\npublic static " + c.getName() + " getConvertor(){\n\tif(instance == null){\n\t\tinstance = new " + c.getName() + "();\n\t}\n\treturn instance;\n}\nIf you do not know what  error is, please report this to the developers.");
                                }
                            }
                            throw new Error("Only classes that extend EnumConvertor may use @abstractionenum. " + c.getName() + " does not, yet it uses the annotation.");
                        }
                    }
                    catch (Exception e) {
                        boolean debugMode;
                        try {
                            debugMode = Prefs.DebugMode();
                        }
                        catch (RuntimeException ex) {
                            debugMode = true;
                        }
                        if (!debugMode) break block11;
                        e.printStackTrace();
                    }
                }
            }, "Abstraction Enum Verification Thread");
            abstractionenumsThread.setPriority(1);
            abstractionenumsThread.setDaemon(true);
            abstractionenumsThread.start();
        }
    }

    private static void checkEnumConvertors(EnumConvertor convertor, Class to, Class from, boolean isToConcrete) {
        for (Object enumConst : from.getEnumConstants()) {
            ReflectionUtils.set(EnumConvertor.class, convertor, "useError", false);
            if (isToConcrete) {
                convertor.getConcreteEnum((Enum)enumConst);
            } else {
                convertor.getAbstractedEnum((Enum)enumConst);
            }
            ReflectionUtils.set(EnumConvertor.class, convertor, "useError", true);
        }
    }

    public static Type GetServerType() {
        if (serverType == null) {
            throw new RuntimeException("Server type has not been set yet! Please call Implementation.setServerType with the appropriate implementation.");
        }
        return serverType;
    }

    public static enum Type {
        TEST("test-backend"),
        BUKKIT("CommandHelper"),
        SHELL("MethodScript"),
        SPONGE("CommandHelper");

        private final String branding;

        private Type(String branding) {
            this.branding = branding;
        }

        public String getBranding() {
            return this.branding;
        }
    }
}

