/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCEntityEquipment;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.inventory.EntityEquipment;

public class BukkitMCEntityEquipment
implements MCEntityEquipment {
    private final EntityEquipment ee;

    public BukkitMCEntityEquipment(EntityEquipment equipment) {
        this.ee = equipment;
    }

    @Override
    public void clearEquipment() {
        this.ee.clear();
    }

    @Override
    public int getSize() {
        return MCEquipmentSlot.values().length;
    }

    @Override
    public MCEntity getHolder() {
        return BukkitConvertor.BukkitGetCorrectEntity(this.ee.getHolder());
    }

    @Override
    public Map<MCEquipmentSlot, MCItemStack> getAllEquipment() {
        EnumMap<MCEquipmentSlot, MCItemStack> slots = new EnumMap<MCEquipmentSlot, MCItemStack>(MCEquipmentSlot.class);
        block8: for (MCEquipmentSlot key : MCEquipmentSlot.values()) {
            switch (key) {
                case WEAPON: {
                    slots.put(key, this.getWeapon());
                    continue block8;
                }
                case OFF_HAND: {
                    slots.put(key, this.getItemInOffHand());
                    continue block8;
                }
                case HELMET: {
                    slots.put(key, this.getHelmet());
                    continue block8;
                }
                case CHESTPLATE: {
                    slots.put(key, this.getChestplate());
                    continue block8;
                }
                case LEGGINGS: {
                    slots.put(key, this.getLeggings());
                    continue block8;
                }
                case BOOTS: {
                    slots.put(key, this.getBoots());
                }
            }
        }
        return slots;
    }

    @Override
    public void setAllEquipment(Map<MCEquipmentSlot, MCItemStack> slots) {
        for (Map.Entry<MCEquipmentSlot, MCItemStack> entry : slots.entrySet()) {
            MCItemStack stack = entry.getValue();
            switch (entry.getKey()) {
                case WEAPON: {
                    this.setWeapon(stack);
                    break;
                }
                case OFF_HAND: {
                    this.setItemInOffHand(stack);
                    break;
                }
                case HELMET: {
                    this.setHelmet(stack);
                    break;
                }
                case CHESTPLATE: {
                    this.setChestplate(stack);
                    break;
                }
                case LEGGINGS: {
                    this.setLeggings(stack);
                    break;
                }
                case BOOTS: {
                    this.setBoots(stack);
                }
            }
        }
    }

    @Override
    public Map<MCEquipmentSlot, Float> getAllDropChances() {
        EnumMap<MCEquipmentSlot, Float> slots = new EnumMap<MCEquipmentSlot, Float>(MCEquipmentSlot.class);
        block8: for (MCEquipmentSlot key : MCEquipmentSlot.values()) {
            switch (key) {
                case WEAPON: {
                    slots.put(key, Float.valueOf(this.getWeaponDropChance()));
                    continue block8;
                }
                case OFF_HAND: {
                    slots.put(key, Float.valueOf(this.getOffHandDropChance()));
                    continue block8;
                }
                case HELMET: {
                    slots.put(key, Float.valueOf(this.getHelmetDropChance()));
                    continue block8;
                }
                case CHESTPLATE: {
                    slots.put(key, Float.valueOf(this.getChestplateDropChance()));
                    continue block8;
                }
                case LEGGINGS: {
                    slots.put(key, Float.valueOf(this.getLeggingsDropChance()));
                    continue block8;
                }
                case BOOTS: {
                    slots.put(key, Float.valueOf(this.getBootsDropChance()));
                }
            }
        }
        return slots;
    }

    @Override
    public void setAllDropChances(Map<MCEquipmentSlot, Float> slots) {
        for (Map.Entry<MCEquipmentSlot, Float> entry : slots.entrySet()) {
            float chance = entry.getValue().floatValue();
            switch (entry.getKey()) {
                case WEAPON: {
                    this.setWeaponDropChance(chance);
                    break;
                }
                case OFF_HAND: {
                    this.setOffHandDropChance(chance);
                    break;
                }
                case HELMET: {
                    this.setHelmetDropChance(chance);
                    break;
                }
                case CHESTPLATE: {
                    this.setChestplateDropChance(chance);
                    break;
                }
                case LEGGINGS: {
                    this.setLeggingsDropChance(chance);
                    break;
                }
                case BOOTS: {
                    this.setBootsDropChance(chance);
                }
            }
        }
    }

    @Override
    public MCItemStack getWeapon() {
        return new BukkitMCItemStack(this.ee.getItemInMainHand());
    }

    @Override
    public MCItemStack getItemInOffHand() {
        return new BukkitMCItemStack(this.ee.getItemInOffHand());
    }

    @Override
    public MCItemStack getHelmet() {
        return new BukkitMCItemStack(this.ee.getHelmet());
    }

    @Override
    public MCItemStack getChestplate() {
        return new BukkitMCItemStack(this.ee.getChestplate());
    }

    @Override
    public MCItemStack getLeggings() {
        return new BukkitMCItemStack(this.ee.getLeggings());
    }

    @Override
    public MCItemStack getBoots() {
        return new BukkitMCItemStack(this.ee.getBoots());
    }

    @Override
    public void setWeapon(MCItemStack stack) {
        this.ee.setItemInMainHand(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setItemInOffHand(MCItemStack stack) {
        this.ee.setItemInOffHand(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setHelmet(MCItemStack stack) {
        this.ee.setHelmet(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setChestplate(MCItemStack stack) {
        this.ee.setChestplate(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setLeggings(MCItemStack stack) {
        this.ee.setLeggings(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setBoots(MCItemStack stack) {
        this.ee.setBoots(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public float getWeaponDropChance() {
        return this.ee.getItemInMainHandDropChance();
    }

    @Override
    public float getOffHandDropChance() {
        return this.ee.getItemInOffHandDropChance();
    }

    @Override
    public float getHelmetDropChance() {
        return this.ee.getHelmetDropChance();
    }

    @Override
    public float getChestplateDropChance() {
        return this.ee.getChestplateDropChance();
    }

    @Override
    public float getLeggingsDropChance() {
        return this.ee.getLeggingsDropChance();
    }

    @Override
    public float getBootsDropChance() {
        return this.ee.getBootsDropChance();
    }

    @Override
    public void setWeaponDropChance(float chance) {
        this.ee.setItemInMainHandDropChance(chance);
    }

    @Override
    public void setOffHandDropChance(float chance) {
        this.ee.setItemInOffHandDropChance(chance);
    }

    @Override
    public void setHelmetDropChance(float chance) {
        this.ee.setHelmetDropChance(chance);
    }

    @Override
    public void setChestplateDropChance(float chance) {
        this.ee.setChestplateDropChance(chance);
    }

    @Override
    public void setLeggingsDropChance(float chance) {
        this.ee.setLeggingsDropChance(chance);
    }

    @Override
    public void setBootsDropChance(float chance) {
        this.ee.setBootsDropChance(chance);
    }
}

