/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCTagContainer;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCAttributeModifier;
import com.laytonsmith.abstraction.bukkit.BukkitMCTagContainer;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCItemFlag;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEnchantment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCItemFlag;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class BukkitMCItemMeta
implements MCItemMeta {
    ItemMeta im;

    public BukkitMCItemMeta(ItemMeta im) {
        this.im = im;
    }

    public BukkitMCItemMeta(AbstractionObject o) {
        this.im = (ItemMeta)o;
    }

    @Override
    public boolean hasDisplayName() {
        return this.im.hasDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.im.getDisplayName();
    }

    @Override
    public void setDisplayName(String name) {
        this.im.setDisplayName(name);
    }

    @Override
    public boolean hasLore() {
        return this.im.hasLore();
    }

    @Override
    public List<String> getLore() {
        return this.im.getLore();
    }

    @Override
    public void setLore(List<String> lore) {
        this.im.setLore(lore);
    }

    @Override
    public boolean hasEnchants() {
        return this.im.hasEnchants();
    }

    @Override
    public Map<MCEnchantment, Integer> getEnchants() {
        HashMap<MCEnchantment, Integer> map = new HashMap<MCEnchantment, Integer>();
        for (Map.Entry entry : this.im.getEnchants().entrySet()) {
            map.put(BukkitMCEnchantment.valueOfConcrete((Enchantment)entry.getKey()), (Integer)entry.getValue());
        }
        return map;
    }

    @Override
    public boolean addEnchant(MCEnchantment ench, int level, boolean ignoreLevelRestriction) {
        return this.im.addEnchant((Enchantment)ench.getConcrete(), level, ignoreLevelRestriction);
    }

    @Override
    public boolean removeEnchant(MCEnchantment ench) {
        return this.im.removeEnchant((Enchantment)ench.getConcrete());
    }

    @Override
    public Object getHandle() {
        return this.im;
    }

    public ItemMeta asItemMeta() {
        return this.im;
    }

    public boolean equals(Object obj) {
        return obj instanceof MCItemMeta && this.im.equals(((MCItemMeta)obj).getHandle());
    }

    public int hashCode() {
        return this.im.hashCode();
    }

    public String toString() {
        return this.im.toString();
    }

    @Override
    public boolean hasRepairCost() {
        return ((Repairable)this.im).hasRepairCost();
    }

    @Override
    public int getRepairCost() {
        return ((Repairable)this.im).getRepairCost();
    }

    @Override
    public void setRepairCost(int cost) {
        ((Repairable)this.im).setRepairCost(cost);
    }

    @Override
    public void addItemFlags(MCItemFlag ... flags) {
        for (MCItemFlag flag : flags) {
            this.im.addItemFlags(new ItemFlag[]{(ItemFlag)BukkitMCItemFlag.getConvertor().getConcreteEnum(flag)});
        }
    }

    @Override
    public Set<MCItemFlag> getItemFlags() {
        Set flags = this.im.getItemFlags();
        HashSet<MCItemFlag> ret = new HashSet<MCItemFlag>(flags.size());
        for (ItemFlag flag : flags) {
            ret.add(MCItemFlag.valueOf(flag.name()));
        }
        return ret;
    }

    @Override
    public boolean isUnbreakable() {
        return this.im.isUnbreakable();
    }

    @Override
    public void setUnbreakable(boolean unbreakable2) {
        this.im.setUnbreakable(unbreakable2);
    }

    @Override
    public int getDamage() {
        return ((Damageable)this.im).getDamage();
    }

    @Override
    public void setDamage(int damage) {
        ((Damageable)this.im).setDamage(damage);
    }

    @Override
    public boolean hasMaxDamage() {
        return ((Damageable)this.im).hasMaxDamage();
    }

    @Override
    public int getMaxDamage() {
        return ((Damageable)this.im).getMaxDamage();
    }

    @Override
    public void setMaxDamage(int damage) {
        ((Damageable)this.im).setMaxDamage(Integer.valueOf(damage));
    }

    @Override
    public MCBlockData getBlockData(MCMaterial material) {
        return new BukkitMCBlockData(((BlockDataMeta)this.im).getBlockData((Material)material.getHandle()));
    }

    @Override
    public Map<String, String> getExistingBlockData() {
        try {
            Class<?> clz = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".inventory.CraftMetaItem");
            return (Map)ReflectionUtils.get(clz, this.im, "blockData");
        }
        catch (ClassNotFoundException e) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Failed to get CraftMetaItem class.", Target.UNKNOWN);
            return null;
        }
        catch (ReflectionUtils.ReflectionException ex) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Failed to get blockData from CraftMetaItem.", Target.UNKNOWN);
            return null;
        }
    }

    @Override
    public boolean hasBlockData() {
        return ((BlockDataMeta)this.im).hasBlockData();
    }

    @Override
    public void setBlockData(MCBlockData blockData) {
        ((BlockDataMeta)this.im).setBlockData((BlockData)blockData.getHandle());
    }

    @Override
    public boolean hasCustomModelData() {
        return this.im.hasCustomModelData();
    }

    @Override
    public int getCustomModelData() {
        return this.im.getCustomModelData();
    }

    @Override
    public void setCustomModelData(int id) {
        this.im.setCustomModelData(Integer.valueOf(id));
    }

    @Override
    public List<MCAttributeModifier> getAttributeModifiers() {
        Multimap modifiers = this.im.getAttributeModifiers();
        if (modifiers == null) {
            return null;
        }
        ArrayList<MCAttributeModifier> ret = new ArrayList<MCAttributeModifier>();
        for (Map.Entry modifier : modifiers.entries()) {
            ret.add(new BukkitMCAttributeModifier((Attribute)modifier.getKey(), (AttributeModifier)modifier.getValue()));
        }
        return ret;
    }

    @Override
    public void setAttributeModifiers(List<MCAttributeModifier> modifiers) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (MCAttributeModifier m : modifiers) {
            map.put((Object)((Attribute)m.getAttribute().getConcrete()), (Object)((AttributeModifier)m.getHandle()));
        }
        this.im.setAttributeModifiers((Multimap)map);
    }

    @Override
    public boolean hasCustomTags() {
        return !this.im.getPersistentDataContainer().isEmpty();
    }

    @Override
    public MCTagContainer getCustomTags() {
        return new BukkitMCTagContainer(this.im.getPersistentDataContainer());
    }

    @Override
    public boolean hasItemName() {
        return this.im.hasItemName();
    }

    @Override
    public String getItemName() {
        return this.im.getItemName();
    }

    @Override
    public void setItemName(String name) {
        this.im.setItemName(name);
    }

    @Override
    public boolean isHideTooltip() {
        return this.im.isHideTooltip();
    }

    @Override
    public void setHideTooltip(boolean hide2) {
        this.im.setHideTooltip(hide2);
    }

    @Override
    public boolean hasEnchantmentGlintOverride() {
        return this.im.hasEnchantmentGlintOverride();
    }

    @Override
    public boolean getEnchantmentGlintOverride() {
        return this.im.getEnchantmentGlintOverride();
    }

    @Override
    public void setEnchantmentGlintOverride(boolean glint) {
        this.im.setEnchantmentGlintOverride(Boolean.valueOf(glint));
    }

    @Override
    public boolean isFireResistant() {
        return this.im.isFireResistant();
    }

    @Override
    public void setFireResistant(boolean fireResistant) {
        this.im.setFireResistant(fireResistant);
    }

    @Override
    public boolean hasMaxStackSize() {
        return this.im.hasMaxStackSize();
    }

    @Override
    public int getMaxStackSize() {
        return this.im.getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int size) {
        this.im.setMaxStackSize(Integer.valueOf(size));
    }
}

