/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.KeywordDocumentation;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.List;

public abstract class Keyword
implements KeywordDocumentation {
    protected Keyword() {
    }

    public abstract int process(List<ParseTree> var1, int var2) throws ConfigCompileException;

    @Override
    public final String getKeywordName() {
        keyword k = this.getClass().getAnnotation(keyword.class);
        return k == null ? null : k.value();
    }

    protected void validateCodeBlock(ParseTree node, String message) throws ConfigCompileException {
        if (node.getChildren().size() > 1) {
            throw new ConfigCompileException("Unexpected number of arguments in code block", node.getTarget());
        }
        if (!Keyword.isCodeBlock(node)) {
            throw new ConfigCompileException(message, node.getTarget());
        }
    }

    protected boolean isValidCodeBlock(ParseTree node) {
        return node.getChildren().size() <= 1 && Keyword.isCodeBlock(node);
    }

    protected static boolean isCodeBlock(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals("__cbrace__");
    }

    protected static ParseTree getArgumentOrNoop(ParseTree node) {
        if (node.getChildren().isEmpty()) {
            FileOptions options = node.getFileOptions();
            ParseTree statement = new ParseTree(new CFunction("__statements__", com.laytonsmith.core.constructs.Target.UNKNOWN), options, true);
            statement.addChild(new ParseTree(new CFunction("noop", com.laytonsmith.core.constructs.Target.UNKNOWN), options, true));
            return statement;
        }
        return node.getChildAt(0);
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return new Class[0];
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public String getName() {
        return this.getClass().getAnnotation(keyword.class).value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface keyword {
        public String value();
    }
}

