/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.exceptions;

import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.AbstractCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import java.io.File;
import java.util.Objects;

public class ConfigCompileException
extends AbstractCompileException
implements Comparable<ConfigCompileException> {
    final String message;
    final int lineNum;
    final File file;
    final int col;
    final Target t;

    public ConfigCompileException(String message, Target t) {
        this(message, t, null);
    }

    public ConfigCompileException(String message, Target t, Throwable cause) {
        super(cause);
        this.message = message;
        this.lineNum = t.line();
        this.file = t.file();
        this.col = t.col();
        this.t = t;
    }

    public ConfigCompileException(ConfigRuntimeException e) {
        this(e.getMessage(), e.getTarget(), e);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getLineNum() {
        return Integer.toString(this.lineNum);
    }

    public int getColumn() {
        return this.col;
    }

    public Target getTarget() {
        return this.t;
    }

    @Override
    public String toString() {
        if (this.lineNum != 0) {
            return "Configuration Compile Exception: " + this.message + " near line " + this.lineNum + ". Please check your code and try again. " + (String)(this.file != null ? "(" + this.file.getAbsolutePath() + ")" : "");
        }
        return "Configuration Compile Exception: " + this.message + ". Please check your code and try again. " + (String)(this.file != null ? "(" + this.file.getAbsolutePath() + ")" : "");
    }

    public File getFile() {
        return this.file;
    }

    public String getSimpleFile() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 31 * hash2 + Objects.hashCode(this.message);
        hash2 = 31 * hash2 + this.lineNum;
        hash2 = 31 * hash2 + Objects.hashCode(this.file);
        hash2 = 31 * hash2 + this.col;
        hash2 = 31 * hash2 + Objects.hashCode(this.t);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigCompileException other = (ConfigCompileException)obj;
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        if (this.lineNum != other.lineNum) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (this.col != other.col) {
            return false;
        }
        return Objects.equals(this.t, other.t);
    }

    @Override
    public int compareTo(ConfigCompileException cre) {
        int ret = this.t.compareTo(cre.t);
        if (ret != 0) {
            return ret;
        }
        return this.message.compareTo(cre.message);
    }
}

