/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core.v3;

import com.laytonsmith.libs.org.postgresql.copy.CopyOperation;
import com.laytonsmith.libs.org.postgresql.core.Field;
import com.laytonsmith.libs.org.postgresql.core.Logger;
import com.laytonsmith.libs.org.postgresql.core.Notification;
import com.laytonsmith.libs.org.postgresql.core.PGBindException;
import com.laytonsmith.libs.org.postgresql.core.PGStream;
import com.laytonsmith.libs.org.postgresql.core.ParameterList;
import com.laytonsmith.libs.org.postgresql.core.Parser;
import com.laytonsmith.libs.org.postgresql.core.Query;
import com.laytonsmith.libs.org.postgresql.core.QueryExecutor;
import com.laytonsmith.libs.org.postgresql.core.ResultCursor;
import com.laytonsmith.libs.org.postgresql.core.ResultHandler;
import com.laytonsmith.libs.org.postgresql.core.Utils;
import com.laytonsmith.libs.org.postgresql.core.v3.CompositeQuery;
import com.laytonsmith.libs.org.postgresql.core.v3.CopyInImpl;
import com.laytonsmith.libs.org.postgresql.core.v3.CopyOperationImpl;
import com.laytonsmith.libs.org.postgresql.core.v3.CopyOutImpl;
import com.laytonsmith.libs.org.postgresql.core.v3.Portal;
import com.laytonsmith.libs.org.postgresql.core.v3.ProtocolConnectionImpl;
import com.laytonsmith.libs.org.postgresql.core.v3.SimpleParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.SimpleQuery;
import com.laytonsmith.libs.org.postgresql.core.v3.V3ParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.V3Query;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import com.laytonsmith.libs.org.postgresql.util.PSQLWarning;
import com.laytonsmith.libs.org.postgresql.util.ServerErrorMessage;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class QueryExecutorImpl
implements QueryExecutor {
    private Object lockedFor = null;
    private static final int MAX_BUFFERED_QUERIES = 256;
    private final HashMap parsedQueryMap = new HashMap();
    private final ReferenceQueue parsedQueryCleanupQueue = new ReferenceQueue();
    private final HashMap openPortalMap = new HashMap();
    private final ReferenceQueue openPortalCleanupQueue = new ReferenceQueue();
    private final ArrayList pendingParseQueue = new ArrayList();
    private final ArrayList pendingBindQueue = new ArrayList();
    private final ArrayList pendingExecuteQueue = new ArrayList();
    private final ArrayList pendingDescribeStatementQueue = new ArrayList();
    private final ArrayList pendingDescribePortalQueue = new ArrayList();
    private long nextUniqueID = 1L;
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;
    private final boolean allowEncodingChanges;
    private int queryCount;
    private final SimpleQuery beginTransactionQuery = new SimpleQuery(new String[]{"BEGIN"}, null);
    private static final SimpleQuery EMPTY_QUERY = new SimpleQuery(new String[]{""}, null);

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream, Properties info, Logger logger) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
        this.logger = logger;
        this.allowEncodingChanges = info.getProperty("allowEncodingChanges") != null ? Boolean.valueOf(info.getProperty("allowEncodingChanges")) : false;
    }

    private void lock(Object obtainer) throws PSQLException {
        if (this.lockedFor == obtainer) {
            throw new PSQLException(GT.tr("Tried to obtain lock while already holding it"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.waitOnLock();
        this.lockedFor = obtainer;
    }

    private void unlock(Object holder) throws PSQLException {
        if (this.lockedFor != holder) {
            throw new PSQLException(GT.tr("Tried to break lock on database connection"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.lockedFor = null;
        this.notify();
    }

    private void waitOnLock() throws PSQLException {
        while (this.lockedFor != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new PSQLException(GT.tr("Interrupted while waiting to obtain lock on database connection"), PSQLState.OBJECT_NOT_IN_STATE, (Throwable)ie);
            }
        }
    }

    boolean hasLock(Object holder) {
        return this.lockedFor == holder;
    }

    @Override
    public Query createSimpleQuery(String sql) {
        return this.parseQuery(sql, false);
    }

    @Override
    public Query createParameterizedQuery(String sql) {
        return this.parseQuery(sql, true);
    }

    private Query parseQuery(String query2, boolean withParameters) {
        ArrayList<String[]> statementList = new ArrayList<String[]>();
        ArrayList<String> fragmentList = new ArrayList<String>(15);
        int fragmentStart = 0;
        int inParen = 0;
        boolean standardConformingStrings = this.protoConnection.getStandardConformingStrings();
        char[] aChars = query2.toCharArray();
        block11: for (int i = 0; i < aChars.length; ++i) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, standardConformingStrings);
                    continue block11;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    continue block11;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    continue block11;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    continue block11;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    continue block11;
                }
                case '(': {
                    ++inParen;
                    continue block11;
                }
                case ')': {
                    --inParen;
                    continue block11;
                }
                case '?': {
                    if (!withParameters) continue block11;
                    fragmentList.add(query2.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    continue block11;
                }
                case ';': {
                    if (inParen != 0) continue block11;
                    fragmentList.add(query2.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
                        statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
                    }
                    fragmentList.clear();
                    continue block11;
                }
            }
        }
        fragmentList.add(query2.substring(fragmentStart));
        if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
            statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
        }
        if (statementList.isEmpty()) {
            return EMPTY_QUERY;
        }
        if (statementList.size() == 1) {
            return new SimpleQuery((String[])statementList.get(0), this.protoConnection);
        }
        SimpleQuery[] subqueries = new SimpleQuery[statementList.size()];
        int[] offsets = new int[statementList.size()];
        int offset = 0;
        for (int i = 0; i < statementList.size(); ++i) {
            String[] fragments = (String[])statementList.get(i);
            offsets[i] = offset;
            subqueries[i] = new SimpleQuery(fragments, this.protoConnection);
            offset += fragments.length - 1;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    @Override
    public synchronized void execute(Query query2, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.waitOnLock();
        if (this.logger.logDebug()) {
            this.logger.debug("simple execute, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        boolean describeOnly = (0x20 & flags) != 0;
        ((V3ParameterList)parameters).convertFunctionOutParameters();
        if (!describeOnly) {
            ((V3ParameterList)parameters).checkAllParametersSet();
        }
        try {
            try {
                handler = this.sendQueryPreamble(handler, flags);
                ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
                this.queryCount = 0;
                this.sendQuery((V3Query)query2, (V3ParameterList)parameters, maxRows, fetchSize, flags, trackingHandler);
                this.sendSync();
                this.processResults(handler, flags);
            }
            catch (PGBindException se) {
                this.sendSync();
                this.processResults(handler, flags);
                handler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    @Override
    public synchronized void execute(Query[] queries, ParameterList[] parameterLists, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        boolean describeOnly;
        this.waitOnLock();
        if (this.logger.logDebug()) {
            this.logger.debug("batch execute " + queries.length + " queries, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        boolean bl = describeOnly = (0x20 & flags) != 0;
        if (!describeOnly) {
            for (int i = 0; i < parameterLists.length; ++i) {
                if (parameterLists[i] == null) continue;
                ((V3ParameterList)parameterLists[i]).checkAllParametersSet();
            }
        }
        try {
            handler = this.sendQueryPreamble(handler, flags);
            ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
            this.queryCount = 0;
            for (int i = 0; i < queries.length; ++i) {
                V3Query query2 = (V3Query)queries[i];
                V3ParameterList parameters = (V3ParameterList)parameterLists[i];
                if (parameters == null) {
                    parameters = SimpleQuery.NO_PARAMETERS;
                }
                this.sendQuery(query2, parameters, maxRows, fetchSize, flags, trackingHandler);
                if (trackingHandler.hasErrors()) break;
            }
            if (!trackingHandler.hasErrors()) {
                this.sendSync();
                this.processResults(handler, flags);
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private ResultHandler sendQueryPreamble(final ResultHandler delegateHandler, int flags) throws IOException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((flags & 0x10) != 0 || this.protoConnection.getTransactionState() != 0) {
            return delegateHandler;
        }
        this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
        return new ResultHandler(){
            private boolean sawBegin = false;

            @Override
            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                if (this.sawBegin) {
                    delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                }
            }

            @Override
            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                } else {
                    delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                }
            }

            @Override
            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            @Override
            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            @Override
            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
    }

    @Override
    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        this.waitOnLock();
        if (!suppressBegin) {
            this.doSubprotocolBegin();
        }
        try {
            this.sendFastpathCall(fnid, (SimpleParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            this.protoConnection.close();
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public void doSubprotocolBegin() throws SQLException {
        if (this.protoConnection.getTransactionState() == 0) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath or copy call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                @Override
                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                }

                @Override
                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                @Override
                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                @Override
                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                @Override
                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
                this.sendSync();
                this.processResults(handler, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    @Override
    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count, this.protoConnection);
    }

    private void sendFastpathCall(int fnid, SimpleParameterList params) throws SQLException, IOException {
        int i;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FunctionCall(" + fnid + ", " + params.getParameterCount() + " params)");
        }
        int paramCount = params.getParameterCount();
        int encodedSize = 0;
        for (i = 1; i <= paramCount; ++i) {
            if (params.isNull(i)) {
                encodedSize += 4;
                continue;
            }
            encodedSize += 4 + params.getV3Length(i);
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendInteger4(10 + 2 * paramCount + 2 + encodedSize + 2);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger2(paramCount);
        for (i = 1; i <= paramCount; ++i) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
        }
        this.pgStream.SendInteger2(paramCount);
        for (i = 1; i <= paramCount; ++i) {
            if (params.isNull(i)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i));
            params.writeV3Value(i, this.pgStream);
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void processNotifies() throws SQLException {
        this.waitOnLock();
        if (this.protoConnection.getTransactionState() != 0) {
            return;
        }
        try {
            int c;
            block7: while (this.pgStream.hasMessagePending()) {
                c = this.pgStream.ReceiveChar();
                switch (c) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block7;
                    }
                    case 69: {
                        throw this.receiveErrorResponse();
                    }
                    case 78: {
                        SQLWarning warning = this.receiveNoticeResponse();
                        this.protoConnection.addWarning(warning);
                        continue block7;
                    }
                }
            }
            return;
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        boolean endQuery = false;
        SQLException error = null;
        byte[] returnValue = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException newError = this.receiveErrorResponse();
                    if (error == null) {
                        error = newError;
                        continue block7;
                    }
                    error.setNextException(newError);
                    continue block7;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    this.protoConnection.addWarning(warning);
                    continue block7;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    continue block7;
                }
                case 86: {
                    int msgLen = this.pgStream.ReceiveInteger4();
                    int valueLen = this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FunctionCallResponse(" + valueLen + " bytes)");
                    }
                    if (valueLen == -1) continue block7;
                    byte[] buf = new byte[valueLen];
                    this.pgStream.Receive(buf, 0, valueLen);
                    returnValue = buf;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
        }
        if (error != null) {
            throw error;
        }
        return returnValue;
    }

    @Override
    public synchronized CopyOperation startCopy(String sql, boolean suppressBegin) throws SQLException {
        this.waitOnLock();
        if (!suppressBegin) {
            this.doSubprotocolBegin();
        }
        byte[] buf = Utils.encodeUTF8(sql);
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> Query(CopyStart)");
            }
            this.pgStream.SendChar(81);
            this.pgStream.SendInteger4(buf.length + 4 + 1);
            this.pgStream.Send(buf);
            this.pgStream.SendChar(0);
            this.pgStream.flush();
            return this.processCopyResults(null, true);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when starting copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private synchronized void initCopy(CopyOperationImpl op) throws SQLException, IOException {
        this.pgStream.ReceiveInteger4();
        int rowFormat = this.pgStream.ReceiveChar();
        int numFields = this.pgStream.ReceiveInteger2();
        int[] fieldFormats = new int[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldFormats[i] = this.pgStream.ReceiveInteger2();
        }
        this.lock(op);
        op.init(this, rowFormat, fieldFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCopy(CopyOperationImpl op) throws SQLException {
        int errors;
        SQLException error;
        block17: {
            if (!this.hasLock(op)) {
                throw new PSQLException(GT.tr("Tried to cancel an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
            }
            error = null;
            errors = 0;
            try {
                if (op instanceof CopyInImpl) {
                    QueryExecutorImpl queryExecutorImpl = this;
                    synchronized (queryExecutorImpl) {
                        if (this.logger.logDebug()) {
                            this.logger.debug("FE => CopyFail");
                        }
                        byte[] msg2 = Utils.encodeUTF8("Copy cancel requested");
                        this.pgStream.SendChar(102);
                        this.pgStream.SendInteger4(5 + msg2.length);
                        this.pgStream.Send(msg2);
                        this.pgStream.SendChar(0);
                        this.pgStream.flush();
                        do {
                            try {
                                this.processCopyResults(op, true);
                            }
                            catch (SQLException se) {
                                ++errors;
                                if (error != null) {
                                    SQLException next;
                                    SQLException e = se;
                                    while ((next = e.getNextException()) != null) {
                                        e = next;
                                    }
                                    e.setNextException(error);
                                }
                                error = se;
                            }
                        } while (this.hasLock(op));
                        break block17;
                    }
                }
                if (op instanceof CopyOutImpl) {
                    this.protoConnection.sendQueryCancel();
                }
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("Database connection failed when canceling copy operation"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        if (op instanceof CopyInImpl) {
            if (errors < 1) {
                throw new PSQLException(GT.tr("Missing expected error response to copy cancel request"), PSQLState.COMMUNICATION_ERROR);
            }
            if (errors > 1) {
                throw new PSQLException(GT.tr("Got {0} error responses to single copy cancel request", String.valueOf(errors)), PSQLState.COMMUNICATION_ERROR, error);
            }
        }
    }

    public synchronized long endCopy(CopyInImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to end inactive copy"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> CopyDone");
            }
            this.pgStream.SendChar(99);
            this.pgStream.SendInteger4(4);
            this.pgStream.flush();
            this.processCopyResults(op, true);
            return op.getHandledRowCount();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when ending copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void writeToCopy(CopyInImpl op, byte[] data, int off, int siz) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CopyData(" + siz + ")");
        }
        try {
            this.pgStream.SendChar(100);
            this.pgStream.SendInteger4(siz + 4);
            this.pgStream.Send(data, off, siz);
            this.processCopyResults(op, false);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void flushCopy(CopyInImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.pgStream.flush();
            this.processCopyResults(op, false);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    synchronized void readFromCopy(CopyOutImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to read from inactive copy"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.processCopyResults(op, true);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when reading from copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    CopyOperationImpl processCopyResults(CopyOperationImpl op, boolean block) throws SQLException, IOException {
        boolean endReceiving = false;
        SQLException error = null;
        SQLException errors = null;
        while (!endReceiving && (block || this.pgStream.hasMessagePending())) {
            int c;
            if (!block && (c = this.pgStream.PeekChar()) == 67) {
                if (!this.logger.logDebug()) break;
                this.logger.debug(" <=BE CommandStatus, Ignored until CopyDone");
                break;
            }
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE Asynchronous Notification while copying");
                    }
                    this.receiveAsyncNotify();
                    break;
                }
                case 78: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE Notification while copying");
                    }
                    this.protoConnection.addWarning(this.receiveNoticeResponse());
                    break;
                }
                case 67: {
                    String status = this.receiveCommandStatus();
                    try {
                        if (op == null) {
                            throw new PSQLException(GT.tr("Received CommandComplete ''{0}'' without an active copy operation", status), PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        op.handleCommandStatus(status);
                    }
                    catch (SQLException se) {
                        error = se;
                    }
                    block = true;
                    break;
                }
                case 69: {
                    error = this.receiveErrorResponse();
                    block = true;
                    break;
                }
                case 71: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyInResponse");
                    }
                    if (op != null) {
                        error = new PSQLException(GT.tr("Got CopyInResponse from server during an active {0}", op.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    op = new CopyInImpl();
                    this.initCopy(op);
                    endReceiving = true;
                    break;
                }
                case 72: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyOutResponse");
                    }
                    if (op != null) {
                        error = new PSQLException(GT.tr("Got CopyOutResponse from server during an active {0}", op.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    op = new CopyOutImpl();
                    this.initCopy(op);
                    endReceiving = true;
                    break;
                }
                case 100: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyData");
                    }
                    int len = this.pgStream.ReceiveInteger4() - 4;
                    byte[] buf = this.pgStream.Receive(len);
                    if (op == null) {
                        error = new PSQLException(GT.tr("Got CopyData without an active copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
                    } else if (!(op instanceof CopyOutImpl)) {
                        error = new PSQLException(GT.tr("Unexpected copydata from server for {0}", op.getClass().getName()), PSQLState.COMMUNICATION_ERROR);
                    } else {
                        ((CopyOutImpl)op).handleCopydata(buf);
                    }
                    endReceiving = true;
                    break;
                }
                case 99: {
                    int len;
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyDone");
                    }
                    if ((len = this.pgStream.ReceiveInteger4() - 4) > 0) {
                        this.pgStream.Receive(len);
                    }
                    if (!(op instanceof CopyOutImpl)) {
                        error = new PSQLException("Got CopyDone while not copying from server", PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    block = true;
                    break;
                }
                case 90: {
                    this.receiveRFQ();
                    if (this.hasLock(op)) {
                        this.unlock(op);
                    }
                    op = null;
                    endReceiving = true;
                    break;
                }
                case 84: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE RowDescription (during copy ignored)");
                    }
                    this.skipMessage();
                    break;
                }
                case 68: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE DataRow (during copy ignored)");
                    }
                    this.skipMessage();
                    break;
                }
                default: {
                    throw new IOException(GT.tr("Unexpected packet type during copy: {0}", Integer.toString(c)));
                }
            }
            if (error == null) continue;
            if (errors != null) {
                error.setNextException(errors);
            }
            errors = error;
            error = null;
        }
        if (errors != null) {
            throw errors;
        }
        return op;
    }

    private void sendQuery(V3Query query2, V3ParameterList parameters, int maxRows, int fetchSize, int flags, ErrorTrackingResultHandler trackingHandler) throws IOException, SQLException {
        boolean disallowBatching;
        SimpleQuery[] subqueries = query2.getSubqueries();
        SimpleParameterList[] subparams = parameters.getSubparams();
        boolean bl = disallowBatching = (flags & 0x80) != 0;
        if (subqueries == null) {
            ++this.queryCount;
            if (disallowBatching || this.queryCount >= 256) {
                this.sendSync();
                this.processResults(trackingHandler, flags);
                this.queryCount = 0;
            }
            if (!trackingHandler.hasErrors()) {
                this.sendOneQuery((SimpleQuery)query2, (SimpleParameterList)parameters, maxRows, fetchSize, flags);
            }
        } else {
            for (int i = 0; i < subqueries.length; ++i) {
                ++this.queryCount;
                if (disallowBatching || this.queryCount >= 256) {
                    this.sendSync();
                    this.processResults(trackingHandler, flags);
                    if (trackingHandler.hasErrors()) break;
                    this.queryCount = 0;
                }
                SimpleParameterList subparam = SimpleQuery.NO_PARAMETERS;
                if (subparams != null) {
                    subparam = subparams[i];
                }
                this.sendOneQuery(subqueries[i], subparam, maxRows, fetchSize, flags);
            }
        }
    }

    private void sendSync() throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Sync");
        }
        this.pgStream.SendChar(83);
        this.pgStream.SendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery query2, SimpleParameterList params, boolean oneShot) throws IOException {
        int i;
        int[] typeOIDs = params.getTypeOIDs();
        if (query2.isPreparedFor(typeOIDs)) {
            return;
        }
        query2.unprepare();
        this.processDeadParsedQueries();
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++;
            query2.setStatementName(statementName);
            query2.setStatementTypes((int[])typeOIDs.clone());
        }
        byte[] encodedStatementName = query2.getEncodedStatementName();
        String[] fragments = query2.getFragments();
        if (this.logger.logDebug()) {
            int i2;
            StringBuffer sbuf = new StringBuffer(" FE=> Parse(stmt=" + statementName + ",query=\"");
            for (i2 = 0; i2 < fragments.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append("$" + i2);
                }
                sbuf.append(fragments[i2]);
            }
            sbuf.append("\",oids={");
            for (i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                if (i2 != 1) {
                    sbuf.append(",");
                }
                sbuf.append("" + params.getTypeOID(i2));
            }
            sbuf.append("})");
            this.logger.debug(sbuf.toString());
        }
        byte[][] parts = new byte[fragments.length * 2 - 1][];
        int j = 0;
        int encodedSize = 0;
        for (i = 0; i < fragments.length; ++i) {
            if (i != 0) {
                parts[j] = Utils.encodeUTF8("$" + i);
                encodedSize += parts[j].length;
                ++j;
            }
            parts[j] = Utils.encodeUTF8(fragments[i]);
            encodedSize += parts[j].length;
            ++j;
        }
        encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + encodedSize + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.SendChar(80);
        this.pgStream.SendInteger4(encodedSize);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        for (i = 0; i < parts.length; ++i) {
            this.pgStream.Send(parts[i]);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger4(params.getTypeOID(i));
        }
        this.pendingParseQueue.add(new Object[]{query2, query2.getStatementName()});
    }

    private void sendBind(SimpleQuery query2, SimpleParameterList params, Portal portal) throws IOException {
        int i;
        byte[] encodedPortalName;
        String statementName = query2.getStatementName();
        byte[] encodedStatementName = query2.getEncodedStatementName();
        byte[] byArray = encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        if (this.logger.logDebug()) {
            StringBuffer sbuf = new StringBuffer(" FE=> Bind(stmt=" + statementName + ",portal=" + portal);
            for (int i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                sbuf.append(",$" + i2 + "=<" + params.toString(i2) + ">");
            }
            sbuf.append(")");
            this.logger.debug(sbuf.toString());
        }
        long encodedSize = 0L;
        for (i = 1; i <= params.getParameterCount(); ++i) {
            if (params.isNull(i)) {
                encodedSize += 4L;
                continue;
            }
            encodedSize += 4L + (long)params.getV3Length(i);
        }
        encodedSize = (long)(4 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + 2 + params.getParameterCount() * 2 + 2) + encodedSize + 2L;
        if (encodedSize > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", new Long(encodedSize))));
        }
        this.pgStream.SendChar(66);
        this.pgStream.SendInteger4((int)encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
        }
        this.pgStream.SendInteger2(params.getParameterCount());
        PGBindException bindException = null;
        for (int i3 = 1; i3 <= params.getParameterCount(); ++i3) {
            if (params.isNull(i3)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i3));
            try {
                params.writeV3Value(i3, this.pgStream);
                continue;
            }
            catch (PGBindException be) {
                bindException = be;
            }
        }
        this.pgStream.SendInteger2(0);
        this.pendingBindQueue.add(portal);
        if (bindException != null) {
            throw bindException;
        }
    }

    private void sendDescribePortal(SimpleQuery query2, Portal portal) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribePortalQueue.add(query2);
        query2.setPortalDescribed(true);
    }

    private void sendDescribeStatement(SimpleQuery query2, SimpleParameterList params, boolean describeOnly) throws IOException {
        byte[] encodedStatementName;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(statement=" + query2.getStatementName() + ")");
        }
        int encodedSize = 5 + ((encodedStatementName = query2.getEncodedStatementName()) == null ? 0 : encodedStatementName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(83);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribeStatementQueue.add(new Object[]{query2, params, new Boolean(describeOnly), query2.getStatementName()});
        this.pendingDescribePortalQueue.add(query2);
        query2.setStatementDescribed(true);
        query2.setPortalDescribed(true);
    }

    private void sendExecute(SimpleQuery query2, Portal portal, int limit) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Execute(portal=" + portal + ",limit=" + limit + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(69);
        this.pgStream.SendInteger4(5 + encodedSize + 4);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(limit);
        this.pendingExecuteQueue.add(new Object[]{query2, portal});
    }

    private void sendClosePortal(String portalName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> ClosePortal(" + portalName + ")");
        }
        byte[] encodedPortalName = portalName == null ? null : Utils.encodeUTF8(portalName);
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(6 + encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendCloseStatement(String statementName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CloseStatement(" + statementName + ")");
        }
        byte[] encodedStatementName = Utils.encodeUTF8(statementName);
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(5 + encodedStatementName.length + 1);
        this.pgStream.SendChar(83);
        this.pgStream.Send(encodedStatementName);
        this.pgStream.SendChar(0);
    }

    private void sendOneQuery(SimpleQuery query2, SimpleParameterList params, int maxRows, int fetchSize, int flags) throws IOException {
        boolean describeStatement;
        boolean oneShot;
        boolean noResults = (flags & 4) != 0;
        boolean noMeta = (flags & 2) != 0;
        boolean describeOnly = (flags & 0x20) != 0;
        boolean usePortal = (flags & 8) != 0 && !noResults && !noMeta && fetchSize > 0 && !describeOnly;
        boolean bl = oneShot = (flags & 1) != 0 && !usePortal;
        int rows = noResults ? 1 : (!usePortal ? maxRows : (maxRows != 0 && fetchSize > maxRows ? maxRows : fetchSize));
        this.sendParse(query2, params, oneShot);
        boolean queryHasUnknown = query2.hasUnresolvedTypes();
        boolean paramsHasUnknown = params.hasUnresolvedTypes();
        boolean bl2 = describeStatement = describeOnly || !oneShot && paramsHasUnknown && queryHasUnknown && !query2.isStatementDescribed();
        if (!describeStatement && paramsHasUnknown && !queryHasUnknown) {
            int[] queryOIDs = query2.getStatementTypes();
            int[] paramOIDs = params.getTypeOIDs();
            for (int i = 0; i < paramOIDs.length; ++i) {
                if (paramOIDs[i] != 0) continue;
                params.setResolvedType(i + 1, queryOIDs[i]);
            }
        }
        if (describeStatement) {
            this.sendDescribeStatement(query2, params, describeOnly);
            if (describeOnly) {
                return;
            }
        }
        Portal portal = null;
        if (usePortal) {
            String portalName = "C_" + this.nextUniqueID++;
            portal = new Portal(query2, portalName);
        }
        this.sendBind(query2, params, portal);
        if (!(noMeta || describeStatement || query2.isPortalDescribed())) {
            this.sendDescribePortal(query2, portal);
        }
        this.sendExecute(query2, portal, rows);
    }

    private void registerParsedQuery(SimpleQuery query2, String statementName) {
        if (statementName == null) {
            return;
        }
        PhantomReference<SimpleQuery> cleanupRef = new PhantomReference<SimpleQuery>(query2, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupRef, statementName);
        query2.setCleanupRef(cleanupRef);
    }

    private void processDeadParsedQueries() throws IOException {
        PhantomReference deadQuery;
        while ((deadQuery = (PhantomReference)this.parsedQueryCleanupQueue.poll()) != null) {
            String statementName = (String)this.parsedQueryMap.remove(deadQuery);
            this.sendCloseStatement(statementName);
            deadQuery.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == null) {
            return;
        }
        String portalName = portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(cleanupRef, portalName);
        portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        PhantomReference deadPortal;
        while ((deadPortal = (PhantomReference)this.openPortalCleanupQueue.poll()) != null) {
            String portalName = (String)this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(portalName);
            deadPortal.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(ResultHandler handler, int flags) throws IOException {
        noResults = (flags & 4) != 0;
        bothRowsAndStatus = (flags & 64) != 0;
        tuples = null;
        endQuery = false;
        doneAfterRowDescNoData = false;
        parseIndex = 0;
        describeIndex = 0;
        describePortalIndex = 0;
        bindIndex = 0;
        executeIndex = 0;
        block23: while (!endQuery) {
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 49: {
                    this.pgStream.ReceiveInteger4();
                    parsedQueryAndStatement = (Object[])this.pendingParseQueue.get(parseIndex++);
                    parsedQuery = (SimpleQuery)parsedQueryAndStatement[0];
                    parsedStatementName = (String)parsedQueryAndStatement[1];
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParseComplete [" + parsedStatementName + "]");
                    }
                    this.registerParsedQuery(parsedQuery, parsedStatementName);
                    break;
                }
                case 116: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterDescription");
                    }
                    describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex);
                    query = (SimpleQuery)describeData[0];
                    params = (SimpleParameterList)describeData[1];
                    describeOnly = (Boolean)describeData[2];
                    origStatementName = (String)describeData[3];
                    numParams = this.pgStream.ReceiveInteger2();
                    for (i = 1; i <= numParams; ++i) {
                        typeOid = this.pgStream.ReceiveInteger4();
                        params.setResolvedType(i, typeOid);
                    }
                    if (origStatementName == null && query.getStatementName() == null || origStatementName != null && origStatementName.equals(query.getStatementName())) {
                        query.setStatementTypes((int[])params.getTypeOIDs().clone());
                    }
                    if (describeOnly) {
                        doneAfterRowDescNoData = true;
                        break;
                    }
                    ++describeIndex;
                    break;
                }
                case 50: {
                    this.pgStream.ReceiveInteger4();
                    boundPortal = (Portal)this.pendingBindQueue.get(bindIndex++);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BindComplete [" + boundPortal + "]");
                    }
                    this.registerOpenPortal(boundPortal);
                    break;
                }
                case 51: {
                    this.pgStream.ReceiveInteger4();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CloseComplete");
                    break;
                }
                case 110: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE NoData");
                    }
                    ++describePortalIndex;
                    if (!doneAfterRowDescNoData || (fields = (currentQuery = (SimpleQuery)(describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex++))[0]).getFields()) == null) continue block23;
                    tuples = new Vector<E>();
                    handler.handleResultRows(currentQuery, fields, tuples, null);
                    tuples = null;
                    break;
                }
                case 115: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE PortalSuspended");
                    }
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    currentQuery = (SimpleQuery)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    fields = currentQuery.getFields();
                    if (fields != null && !noResults && tuples == null) {
                        tuples = new Vector<E>();
                    }
                    handler.handleResultRows(currentQuery, fields, tuples, currentPortal);
                    tuples = null;
                    break;
                }
                case 67: {
                    status = this.receiveCommandStatus();
                    doneAfterRowDescNoData = false;
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    currentQuery = (SimpleQuery)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    fields = currentQuery.getFields();
                    if (fields != null && !noResults && tuples == null) {
                        tuples = new Vector<E>();
                    }
                    if (fields != null || tuples != null) {
                        handler.handleResultRows(currentQuery, fields, tuples, null);
                        tuples = null;
                        if (bothRowsAndStatus) {
                            this.interpretCommandStatus(status, handler);
                        }
                    } else {
                        this.interpretCommandStatus(status, handler);
                    }
                    if (currentPortal == null) continue block23;
                    currentPortal.close();
                    break;
                }
                case 68: {
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV3();
                    }
                    catch (OutOfMemoryError oome) {
                        if (noResults) ** GOTO lbl115
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl115:
                    // 3 sources

                    if (!noResults) {
                        if (tuples == null) {
                            tuples = new Vector<E>();
                        }
                        tuples.addElement(tuple);
                    }
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE DataRow");
                    break;
                }
                case 69: {
                    error = this.receiveErrorResponse();
                    handler.handleError(error);
                    break;
                }
                case 73: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    currentQuery = (Query)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    handler.handleCommandStatus("EMPTY", 0, 0L);
                    if (currentPortal == null) continue block23;
                    currentPortal.close();
                    break;
                }
                case 78: {
                    warning = this.receiveNoticeResponse();
                    handler.handleWarning(warning);
                    break;
                }
                case 83: {
                    l_len = this.pgStream.ReceiveInteger4();
                    name = this.pgStream.ReceiveString();
                    value = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("client_encoding") && !value.equalsIgnoreCase("UTF8") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UTF8 for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (name.equals("DateStyle") && !value.startsWith("ISO,")) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (!name.equals("standard_conforming_strings")) continue block23;
                    if (value.equals("on")) {
                        this.protoConnection.setStandardConformingStrings(true);
                        break;
                    }
                    if (value.equals("off")) {
                        this.protoConnection.setStandardConformingStrings(false);
                        break;
                    }
                    this.protoConnection.close();
                    handler.handleError(new PSQLException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", value), PSQLState.CONNECTION_FAILURE));
                    endQuery = true;
                    break;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new Vector<byte[][]>();
                    query = (SimpleQuery)this.pendingDescribePortalQueue.get(describePortalIndex++);
                    query.setFields(fields);
                    if (!doneAfterRowDescNoData) continue block23;
                    describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex++);
                    currentQuery = (Query)describeData[0];
                    handler.handleResultRows(currentQuery, fields, tuples, null);
                    tuples = null;
                    break;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    while (parseIndex < this.pendingParseQueue.size()) {
                        failedQueryAndStatement = (Object[])this.pendingParseQueue.get(parseIndex++);
                        failedQuery = (SimpleQuery)failedQueryAndStatement[0];
                        failedQuery.unprepare();
                    }
                    this.pendingParseQueue.clear();
                    this.pendingDescribeStatementQueue.clear();
                    this.pendingDescribePortalQueue.clear();
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    break;
                }
                case 71: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyInResponse");
                        this.logger.debug(" FE=> CopyFail");
                    }
                    buf = Utils.encodeUTF8("The JDBC driver currently does not support COPY operations.");
                    this.pgStream.SendChar(102);
                    this.pgStream.SendInteger4(buf.length + 4 + 1);
                    this.pgStream.Send(buf);
                    this.pgStream.SendChar(0);
                    this.pgStream.flush();
                    this.sendSync();
                    this.skipMessage();
                    break;
                }
                case 72: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyOutResponse");
                    }
                    this.skipMessage();
                    handler.handleError(new PSQLException(GT.tr("The driver currently does not support COPY operations."), PSQLState.NOT_IMPLEMENTED));
                    break;
                }
                case 99: {
                    this.skipMessage();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CopyDone");
                    break;
                }
                case 100: {
                    this.skipMessage();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CopyData");
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + c);
                }
            }
        }
    }

    private void skipMessage() throws IOException {
        int l_len = this.pgStream.ReceiveInteger4();
        this.pgStream.Skip(l_len - 4);
    }

    @Override
    public synchronized void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize) throws SQLException {
        this.waitOnLock();
        final Portal portal = (Portal)cursor;
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            @Override
            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            @Override
            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                this.handleResultRows(portal.getQuery(), null, new Vector(), null);
            }

            @Override
            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            @Override
            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            @Override
            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(portal.getQuery(), portal, fetchSize);
            this.sendSync();
            this.processResults(handler, 0);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private Field[] receiveFields() throws IOException {
        int l_msgSize = this.pgStream.ReceiveInteger4();
        int size = this.pgStream.ReceiveInteger2();
        Field[] fields = new Field[size];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + size + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            String columnLabel = this.pgStream.ReceiveString();
            int tableOid = this.pgStream.ReceiveInteger4();
            short positionInTable = (short)this.pgStream.ReceiveInteger2();
            int typeOid = this.pgStream.ReceiveInteger4();
            int typeLength = this.pgStream.ReceiveInteger2();
            int typeModifier = this.pgStream.ReceiveInteger4();
            int formatType = this.pgStream.ReceiveInteger2();
            fields[i] = new Field(columnLabel, "", typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i].setFormat(formatType);
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        int msglen = this.pgStream.ReceiveInteger4();
        int pid = this.pgStream.ReceiveInteger4();
        String msg2 = this.pgStream.ReceiveString();
        String param = this.pgStream.ReceiveString();
        this.protoConnection.addNotification(new Notification(msg2, pid, param));
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(" + pid + "," + msg2 + "," + param + ")");
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        int elen = this.pgStream.ReceiveInteger4();
        String totalMessage = this.pgStream.ReceiveString(elen - 4);
        ServerErrorMessage errorMsg = new ServerErrorMessage(totalMessage, this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorMessage(" + errorMsg.toString() + ")");
        }
        return new PSQLException(errorMsg);
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        int nlen = this.pgStream.ReceiveInteger4();
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.pgStream.ReceiveString(nlen - 4), this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + warnMsg.toString() + ")");
        }
        return new PSQLWarning(warnMsg);
    }

    private String receiveCommandStatus() throws IOException {
        int l_len = this.pgStream.ReceiveInteger4();
        String status = this.pgStream.ReceiveString(l_len - 5);
        this.pgStream.Receive(1);
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE CommandStatus(" + status + ")");
        }
        return status;
    }

    private void interpretCommandStatus(String status, ResultHandler handler) {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException nfe) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    private void receiveRFQ() throws IOException {
        if (this.pgStream.ReceiveInteger4() != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char tStatus = (char)this.pgStream.ReceiveChar();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ReadyForQuery(" + tStatus + ")");
        }
        switch (tStatus) {
            case 'I': {
                this.protoConnection.setTransactionState(0);
                break;
            }
            case 'T': {
                this.protoConnection.setTransactionState(1);
                break;
            }
            case 'E': {
                this.protoConnection.setTransactionState(2);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + tStatus);
            }
        }
    }

    private static class ErrorTrackingResultHandler
    implements ResultHandler {
        private final ResultHandler delegateHandler;
        private boolean sawError = false;

        ErrorTrackingResultHandler(ResultHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.delegateHandler.handleCommandStatus(status, updateCount, insertOID);
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            this.delegateHandler.handleWarning(warning);
        }

        @Override
        public void handleError(SQLException error) {
            this.sawError = true;
            this.delegateHandler.handleError(error);
        }

        @Override
        public void handleCompletion() throws SQLException {
            this.delegateHandler.handleCompletion();
        }

        boolean hasErrors() {
            return this.sawError;
        }
    }
}

