/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.annotations.MEnum;

public final class Easings {
    private static final double C1 = 1.70158;
    private static final double C2 = 2.5949095;
    private static final double C3 = 2.70158;
    private static final double C4 = 2.0943951023931953;
    private static final double C5 = 1.3962634015954636;
    private static final double D1 = 2.75;
    private static final double N1 = 7.5625;

    private Easings() {
    }

    public static double GetEasing(EasingType type, double x) {
        if (x < 0.0) {
            x = 0.0;
        } else if (x > 1.0) {
            x = 1.0;
        }
        switch (type.ordinal()) {
            case 0: {
                return 1.0 - Math.cos(x * Math.PI / 2.0);
            }
            case 1: {
                return Math.sin(x * Math.PI / 2.0);
            }
            case 2: {
                return -(Math.cos(Math.PI * x) - 1.0) / 2.0;
            }
            case 3: {
                return x * x * x;
            }
            case 4: {
                return 1.0 - Math.pow(1.0 - x, 3.0);
            }
            case 5: {
                return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
            }
            case 6: {
                return x * x * x * x * x;
            }
            case 7: {
                return 1.0 - Math.pow(1.0 - x, 5.0);
            }
            case 8: {
                return x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0;
            }
            case 9: {
                return 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));
            }
            case 10: {
                return Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
            }
            case 11: {
                return x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0;
            }
            case 12: {
                return x - 1.0E-6 < 0.0 ? 0.0 : (x + 1.0E-6 > 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953));
            }
            case 13: {
                return x - 1.0E-6 < 0.0 ? 0.0 : (x + 1.0E-6 > 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0);
            }
            case 14: {
                return x - 1.0E-6 < 0.0 ? 0.0 : (x + 1.0E-6 > 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636) / 2.0 + 1.0));
            }
            case 15: {
                return x * x;
            }
            case 16: {
                return 1.0 - (1.0 - x) * (1.0 - x);
            }
            case 17: {
                return x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0;
            }
            case 18: {
                return x * x * x * x;
            }
            case 19: {
                return 1.0 - Math.pow(1.0 - x, 4.0);
            }
            case 20: {
                return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
            }
            case 21: {
                return x - 1.0E-6 < 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
            }
            case 22: {
                return x + 1.0E-6 > 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x);
            }
            case 23: {
                return x - 1.0E-6 < 0.0 ? 0.0 : (x + 1.0E-6 > 1.0 ? 1.0 : (x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0));
            }
            case 24: {
                return 2.70158 * x * x * x - 1.70158 * x * x;
            }
            case 25: {
                return 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0);
            }
            case 26: {
                return x < 0.5 ? Math.pow(2.0 * x, 2.0) * (7.189819 * x - 2.5949095) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * (3.5949095 * (x * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
            }
            case 27: {
                return 1.0 - Easings.GetEasing(EasingType.EASE_OUT_BOUNCE, 1.0 - x);
            }
            case 28: {
                if (x < 0.36363636363636365) {
                    return 7.5625 * x * x;
                }
                if (x < 0.7272727272727273) {
                    return 7.5625 * (x -= 0.5454545454545454) * x + 0.75;
                }
                if (x < 0.9090909090909091) {
                    return 7.5625 * (x -= 0.8181818181818182) * x + 0.9375;
                }
                return 7.5625 * (x -= 0.9545454545454546) * x + 0.984375;
            }
            case 29: {
                return x < 0.5 ? (1.0 - Easings.GetEasing(EasingType.EASE_OUT_BOUNCE, 1.0 - 2.0 * x)) / 2.0 : (1.0 + Easings.GetEasing(EasingType.EASE_OUT_BOUNCE, 2.0 * x - 1.0)) / 2.0;
            }
            case 30: {
                return x;
            }
        }
        throw new RuntimeException("Missing easing implementation.");
    }

    @MEnum(value="com.methodscript.EasingType")
    public static enum EasingType {
        EASE_IN_SINE,
        EASE_OUT_SINE,
        EASE_IN_OUT_SINE,
        EASE_IN_CUBIC,
        EASE_OUT_CUBIC,
        EASE_IN_OUT_CUBIC,
        EASE_IN_QUINT,
        EASE_OUT_QUINT,
        EASE_IN_OUT_QUINT,
        EASE_IN_CIRC,
        EASE_OUT_CIRC,
        EASE_IN_OUT_CIRC,
        EASE_IN_ELASTIC,
        EASE_OUT_ELASTIC,
        EASE_IN_OUT_ELASTIC,
        EASE_IN_QUAD,
        EASE_OUT_QUAD,
        EASE_IN_OUT_QUAD,
        EASE_IN_QUART,
        EASE_OUT_QUART,
        EASE_IN_OUT_QUART,
        EASE_IN_EXPO,
        EASE_OUT_EXPO,
        EASE_IN_OUT_EXPO,
        EASE_IN_BACK,
        EASE_OUT_BACK,
        EASE_IN_OUT_BACK,
        EASE_IN_BOUNCE,
        EASE_OUT_BOUNCE,
        EASE_IN_OUT_BOUNCE,
        LINEAR;

    }
}

