/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm.metadata;

import com.laytonsmith.core.asm.metadata.IRMetadata;
import com.laytonsmith.core.asm.metadata.IRMetadataDIBasicType;
import com.laytonsmith.core.asm.metadata.IRMetadataDIFile;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.environments.Environment;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LLVMMetadataRegistry {
    private final Set<IRMetadata> allMetadata = new LinkedHashSet<IRMetadata>();
    private final Map<File, IRMetadataDIFile> difile = new HashMap<File, IRMetadataDIFile>();
    private final Map<CClassType, IRMetadataDIBasicType> basicTypeMap = new HashMap<CClassType, IRMetadataDIBasicType>();
    private IRMetadata emptyTuple = null;

    public void addMetadata(IRMetadata data) {
        this.allMetadata.add(data);
    }

    public Set<IRMetadata> getAllMetadata() {
        return new LinkedHashSet<IRMetadata>(this.allMetadata);
    }

    public IRMetadataDIFile getFileMetadata(Environment env, File file, boolean release) throws IOException {
        if (!this.difile.containsKey(file)) {
            IRMetadataDIFile mdFile = new IRMetadataDIFile(env, file, release);
            this.difile.put(file, mdFile);
            return mdFile;
        }
        return this.difile.get(file);
    }

    public IRMetadataDIBasicType getBasicType(Environment env, CClassType type) {
        if (CNull.TYPE.equals(type) || CVoid.TYPE.equals(type)) {
            throw new RuntimeException("[Compiler Bug] Cannot get BasicType for null or void.");
        }
        if (!this.basicTypeMap.containsKey(type)) {
            IRMetadataDIBasicType bt = new IRMetadataDIBasicType(env, type);
            this.basicTypeMap.put(type, bt);
            return bt;
        }
        return this.basicTypeMap.get(type);
    }

    public IRMetadata getEmptyTuple(Environment env) {
        if (this.emptyTuple == null) {
            this.emptyTuple = IRMetadata.AsEmptyTuple(env);
        }
        return this.emptyTuple;
    }
}

