/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.javalog;

import com.laytonsmith.libs.org.perf4j.LoggingStopWatch;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLogStopWatch
extends LoggingStopWatch {
    private transient Logger logger;
    private Level normalPriority;
    private Level exceptionPriority;

    public JavaLogStopWatch() {
        this("", null, Logger.getLogger("com.laytonsmith.libs.org.perf4j.TimingLogger"), Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(Logger logger) {
        this("", null, logger, Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(Logger logger, Level normalPriority) {
        this("", null, logger, normalPriority, Level.WARNING);
    }

    public JavaLogStopWatch(Logger logger, Level normalPriority, Level exceptionPriority) {
        this("", null, logger, normalPriority, exceptionPriority);
    }

    public JavaLogStopWatch(String tag) {
        this(tag, null, Logger.getLogger("com.laytonsmith.libs.org.perf4j.TimingLogger"), Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, Logger logger) {
        this(tag, null, logger, Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, Logger logger, Level normalPriority) {
        this(tag, null, logger, normalPriority, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, Logger logger, Level normalPriority, Level exceptionPriority) {
        this(tag, null, logger, normalPriority, exceptionPriority);
    }

    public JavaLogStopWatch(String tag, String message) {
        this(tag, message, Logger.getLogger("com.laytonsmith.libs.org.perf4j.TimingLogger"), Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, String message, Logger logger) {
        this(tag, message, logger, Level.INFO, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, String message, Logger logger, Level normalPriority) {
        this(tag, message, logger, normalPriority, Level.WARNING);
    }

    public JavaLogStopWatch(String tag, String message, Logger logger, Level normalPriority, Level exceptionPriority) {
        this(System.currentTimeMillis(), -1L, tag, message, logger, normalPriority, exceptionPriority);
    }

    public JavaLogStopWatch(long startTime, long elapsedTime, String tag, String message, Logger logger, Level normalPriority, Level exceptionPriority) {
        super(startTime, elapsedTime, tag, message);
        this.logger = logger;
        this.normalPriority = normalPriority;
        this.exceptionPriority = exceptionPriority;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public JavaLogStopWatch setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Level getNormalPriority() {
        return this.normalPriority;
    }

    public JavaLogStopWatch setNormalPriority(Level normalPriority) {
        this.normalPriority = normalPriority;
        return this;
    }

    public Level getExceptionPriority() {
        return this.exceptionPriority;
    }

    public JavaLogStopWatch setExceptionPriority(Level exceptionPriority) {
        this.exceptionPriority = exceptionPriority;
        return this;
    }

    public JavaLogStopWatch setTimeThreshold(long timeThreshold) {
        super.setTimeThreshold(timeThreshold);
        return this;
    }

    public JavaLogStopWatch setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public JavaLogStopWatch setMessage(String message) {
        super.setMessage(message);
        return this;
    }

    public JavaLogStopWatch setNormalAndSlowSuffixesEnabled(boolean normalAndSlowSuffixesEnabled) {
        super.setNormalAndSlowSuffixesEnabled(normalAndSlowSuffixesEnabled);
        return this;
    }

    public JavaLogStopWatch setNormalSuffix(String normalSuffix) {
        super.setNormalSuffix(normalSuffix);
        return this;
    }

    public JavaLogStopWatch setSlowSuffix(String slowSuffix) {
        super.setSlowSuffix(slowSuffix);
        return this;
    }

    public boolean isLogging() {
        return this.logger.isLoggable(this.normalPriority);
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        this.logger.log(exception == null ? this.normalPriority : this.exceptionPriority, stopWatchAsString, exception);
    }

    public static Level mapLevelName(String levelName) {
        if ("TRACE".equals(levelName = levelName.toUpperCase())) {
            return Level.FINEST;
        }
        if ("DEBUG".equals(levelName)) {
            return Level.FINE;
        }
        if ("INFO".equals(levelName)) {
            return Level.INFO;
        }
        if ("WARN".equals(levelName)) {
            return Level.WARNING;
        }
        if ("ERROR".equals(levelName)) {
            return Level.SEVERE;
        }
        if ("FATAL".equals(levelName)) {
            return Level.SEVERE;
        }
        return Level.INFO;
    }

    public JavaLogStopWatch clone() {
        return (JavaLogStopWatch)super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeUTF(this.logger.getName());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.logger = Logger.getLogger(stream.readUTF());
    }
}

