/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class StreamUtils {
    public static void Copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    public static String GetString(InputStream in) {
        try {
            return StreamUtils.GetString(in, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String GetString(InputStream in, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(in), encoding);
        int charsPerPage = 5000;
        char[] buffer = new char[5000];
        StringBuilder output = new StringBuilder(5000);
        try {
            int read2 = input.read(buffer, 0, buffer.length);
            while (read2 != -1) {
                output.append(buffer, 0, read2);
                read2 = input.read(buffer, 0, buffer.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toString();
    }

    public static byte[] GetBytes(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int i;
            byte[] buffer = new byte[8192];
            while ((i = bis.read(buffer)) != -1) {
                out.write(buffer, 0, i);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static InputStream GetInputStream(String contents) {
        try {
            return StreamUtils.GetInputStream(contents, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static InputStream GetInputStream(String contents, String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(contents.getBytes(encoding));
    }

    public static InputStream GetInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static PrintStream GetSystemOut() {
        return new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8);
    }

    public static PrintStream GetSystemErr() {
        return new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8);
    }

    public static final String GetResource(String name, String encoding) throws UnsupportedEncodingException, IllegalArgumentException {
        InputStream is = StackTraceUtils.getCallingClass().getResourceAsStream(name);
        if (is == null) {
            throw new IllegalArgumentException("Could not find resource " + name);
        }
        return StreamUtils.GetString(is, encoding);
    }

    public static final String GetResource(String name) throws IllegalArgumentException {
        try {
            return StreamUtils.GetResource(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }
}

