/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.PublicSuffix;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Cookie
implements Comparable<Cookie> {
    private String name;
    private String value;
    private String domain;
    private String path;
    private long expiration = 0L;
    private boolean httpOnly = false;
    private boolean secureOnly = false;

    public Cookie(String unparsedValue, URL currentURL) {
        String[] parts = unparsedValue.split(";");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                String[] nameVal = part.split("=", 2);
                this.name = nameVal[0].trim();
                this.value = nameVal[1].trim();
                continue;
            }
            String[] keyval = part.split("=", 2);
            String key = keyval[0].trim().toLowerCase();
            String val = null;
            if (keyval.length >= 2) {
                val = keyval[1].trim();
            }
            if ("expires".equals(key)) {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy kk:mm:ss zzz");
                try {
                    this.expiration = formatter.parse(val).getTime();
                }
                catch (ParseException ex) {
                    Logger.getLogger(WebUtility.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if ("path".equals(key)) {
                this.path = val;
                continue;
            }
            if ("domain".equals(key)) {
                if (PublicSuffix.get().getEffectiveTLDLength(val) != -1) {
                    this.domain = val;
                    continue;
                }
                Logger.getLogger(WebUtility.class.getName()).log(Level.SEVERE, "Possible attack cookie being set from " + String.valueOf(currentURL) + ". Attempted to set " + val + " as the domain.");
                continue;
            }
            if ("httponly".equals(key)) {
                this.httpOnly = true;
                continue;
            }
            if (!"secureonly".equals(key)) continue;
            this.secureOnly = true;
        }
        if (this.domain == null) {
            this.domain = currentURL.getHost();
        }
        if (this.path == null) {
            this.path = currentURL.getPath();
        }
    }

    public Cookie(String name, String value, String domain, String path) {
        this(name, value, domain, path, 0L, false, false);
    }

    public Cookie(String name, String value, String domain, String path, long expiration, boolean httpOnly, boolean secureOnly) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.expiration = expiration;
        this.httpOnly = httpOnly;
        this.secureOnly = secureOnly;
    }

    @Override
    public int compareTo(Cookie o) {
        return (this.domain + this.name + this.path).compareTo(o.domain + o.name + o.path);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPath() {
        return this.path;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecureOnly() {
        return this.secureOnly;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isExpired(long time2) {
        return this.expiration != 0L && this.expiration < time2;
    }

    public String toString() {
        return this.domain + this.path + ": " + this.name + "=" + this.value;
    }
}

