/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCHumanEntity;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryHolder;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCDoubleChest;
import com.laytonsmith.abstraction.bukkit.BukkitMCInventoryHolder;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCVirtualInventoryHolder;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHumanEntity;
import com.laytonsmith.abstraction.enums.MCInventoryType;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.functions.InventoryManagement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Nameable;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BukkitMCInventory
implements MCInventory {
    private final Inventory i;

    public BukkitMCInventory(Inventory inventory) {
        this.i = inventory;
    }

    @Override
    public MCInventoryType getType() {
        return MCInventoryType.valueOf(this.i.getType().name());
    }

    @Override
    public int getSize() {
        return this.i.getSize();
    }

    @Override
    public MCItemStack getItem(int slot) {
        try {
            return new BukkitMCItemStack(this.i.getItem(slot));
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (slot <= 0 || slot >= this.getSize()) {
                throw new CRERangeException("No slot " + slot + " exists in the given inventory", Target.UNKNOWN);
            }
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.RUNTIME, LogLevel.WARNING, "The API claims that a particular slot is accessible, however the server implementation does not give access. This is the fault of the server and can't be helped by " + Implementation.GetServerType().getBranding() + ".", Target.UNKNOWN);
            return null;
        }
    }

    @Override
    public void setItem(int slot, MCItemStack stack) {
        try {
            this.i.setItem(slot, stack == null ? null : (ItemStack)stack.getHandle());
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (slot > 0 && slot < this.getSize()) {
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.RUNTIME, LogLevel.WARNING, "The API claims that a particular slot is accessible, however the server implementation does not give access. This is the fault of the server and can't be helped by " + Implementation.GetServerType().getBranding() + ".", Target.UNKNOWN);
            }
            throw new CRERangeException("No slot " + slot + " exists in the given inventory", Target.UNKNOWN);
        }
    }

    @Override
    public void clear() {
        this.i.clear();
    }

    @Override
    public void clear(int index) {
        this.i.clear(index);
    }

    @Override
    public Object getHandle() {
        return this.i;
    }

    public String toString() {
        return this.i.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BukkitMCInventory && this.i.equals((Object)((BukkitMCInventory)obj).i);
    }

    public int hashCode() {
        return this.i.hashCode();
    }

    @Override
    public Map<Integer, MCItemStack> addItem(MCItemStack stack) {
        HashMap h = this.i.addItem(new ItemStack[]{(ItemStack)stack.getHandle()});
        HashMap<Integer, MCItemStack> m = new HashMap<Integer, MCItemStack>();
        for (Map.Entry entry : h.entrySet()) {
            Integer key = (Integer)entry.getKey();
            ItemStack value = (ItemStack)entry.getValue();
            m.put(key, new BukkitMCItemStack(value));
        }
        return m;
    }

    @Override
    public List<MCHumanEntity> getViewers() {
        ArrayList<MCHumanEntity> retn = new ArrayList<MCHumanEntity>();
        for (HumanEntity human : this.i.getViewers()) {
            retn.add(new BukkitMCHumanEntity((Entity)human));
        }
        return retn;
    }

    @Override
    public void updateViewers() {
        for (HumanEntity human : this.i.getViewers()) {
            if (!(human instanceof Player)) continue;
            ((Player)human).updateInventory();
        }
    }

    @Override
    public MCInventoryHolder getHolder() {
        InventoryHolder ih = this.i.getHolder();
        if (ih instanceof BlockState) {
            return (MCInventoryHolder)((Object)BukkitConvertor.BukkitGetCorrectBlockState((BlockState)ih));
        }
        if (ih instanceof Entity) {
            return (MCInventoryHolder)((Object)BukkitConvertor.BukkitGetCorrectEntity((Entity)ih));
        }
        if (ih instanceof BukkitMCVirtualInventoryHolder.VirtualHolder) {
            return new BukkitMCVirtualInventoryHolder(ih);
        }
        if (ih instanceof DoubleChest) {
            return new BukkitMCDoubleChest((DoubleChest)ih);
        }
        if (ih == null) {
            for (Map.Entry<String, MCInventory> entry : InventoryManagement.VIRTUAL_INVENTORIES.entrySet()) {
                if (!entry.getValue().equals(this)) continue;
                return new BukkitMCVirtualInventoryHolder(entry.getKey(), this.getTitle());
            }
        }
        return new BukkitMCInventoryHolder(ih);
    }

    @Override
    public String getTitle() {
        InventoryHolder h = this.i.getHolder();
        if (h instanceof Nameable) {
            return ((Nameable)h).getCustomName();
        }
        if (h instanceof BukkitMCVirtualInventoryHolder.VirtualHolder) {
            return ((BukkitMCVirtualInventoryHolder.VirtualHolder)h).getTitle();
        }
        return null;
    }
}

