/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractMethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ConstructorMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.FieldMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.libs.org.objectweb.asm.AnnotationVisitor;
import com.laytonsmith.libs.org.objectweb.asm.ClassVisitor;
import com.laytonsmith.libs.org.objectweb.asm.FieldVisitor;
import com.laytonsmith.libs.org.objectweb.asm.Label;
import com.laytonsmith.libs.org.objectweb.asm.MethodVisitor;
import com.laytonsmith.libs.org.objectweb.asm.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ClassMirrorVisitor
extends ClassVisitor {
    private final ClassMirror.ClassInfo<Object> classInfo;
    private boolean done;
    private static final Pattern STATIC_INITIALIZER_PATTERN = Pattern.compile("<clinit>");

    ClassMirrorVisitor(ClassMirror.ClassInfo<Object> info) {
        super(589824);
        this.classInfo = info;
    }

    public ClassMirrorVisitor() {
        this(new ClassMirror.ClassInfo<Object>());
    }

    public ClassMirror<?> getMirror(URL source2) {
        if (!this.done) {
            throw new IllegalStateException(String.format("Not done visiting %s", this.classInfo.name == null ? "none" : this.classInfo.name));
        }
        return new ClassMirror<Object>(this.classInfo, source2);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.done) {
            throw new IllegalStateException(String.format("Can't visit %s, because we already visited %s", name, this.classInfo.name));
        }
        if ((access & 0x4000) == 16384) {
            this.classInfo.isEnum = true;
        }
        if ((access & 0x200) == 512) {
            this.classInfo.isInterface = true;
        }
        this.classInfo.modifiers = new ModifierMirror(ModifierMirror.Type.CLASS, access);
        this.classInfo.name = name;
        this.classInfo.classReferenceMirror = new ClassReferenceMirror(Type.getObjectType(name).getDescriptor());
        this.classInfo.superClass = superName;
        this.classInfo.interfaces = interfaces;
        if (signature != null) {
            boolean inGeneric = false;
            ClassReferenceMirror top = null;
            StringBuilder buffer = new StringBuilder();
            for (char c : signature.toCharArray()) {
                if (c == '<') {
                    inGeneric = true;
                    top = new ClassReferenceMirror(buffer.toString() + ";");
                    this.classInfo.genericParameters.put(top, new ArrayList());
                    buffer = new StringBuilder();
                    continue;
                }
                if (c == '>') {
                    inGeneric = false;
                    top = null;
                    buffer = new StringBuilder();
                    continue;
                }
                if (c == ';') {
                    if (buffer.toString().isEmpty()) continue;
                    if (inGeneric) {
                        this.classInfo.genericParameters.get(top).add(new ClassReferenceMirror(buffer.toString() + ";"));
                        buffer = new StringBuilder();
                        continue;
                    }
                    this.classInfo.genericParameters.put(new ClassReferenceMirror(buffer.toString() + ";"), new ArrayList());
                    continue;
                }
                buffer.append(c);
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        final AnnotationMirror mirror = new AnnotationMirror(new ClassReferenceMirror(desc), visible);
        return new AnnotationMirrorVisitor(super.visitAnnotation(desc, visible), mirror){

            @Override
            public void visitEnd() {
                ClassMirrorVisitor.this.classInfo.annotations.add(mirror);
                super.visitEnd();
            }
        };
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final FieldMirror fieldMirror = new FieldMirror(this.classInfo.classReferenceMirror, new ModifierMirror(ModifierMirror.Type.FIELD, access), new ClassReferenceMirror(desc), name, value, signature);
        return new FieldVisitor(589824, super.visitField(access, name, desc, signature, value)){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final AnnotationMirror annotationMirror = new AnnotationMirror(new ClassReferenceMirror(desc), visible);
                return new AnnotationMirrorVisitor(super.visitAnnotation(desc, visible), annotationMirror){

                    @Override
                    public void visitEnd() {
                        fieldMirror.addAnnotation(annotationMirror);
                        super.visitEnd();
                    }
                };
            }

            @Override
            public void visitEnd() {
                ClassMirrorVisitor.this.classInfo.fields.add(fieldMirror);
                super.visitEnd();
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (STATIC_INITIALIZER_PATTERN.matcher(name).matches()) {
            return null;
        }
        if ("<init>".matches(name)) {
            desc = StringUtils.replaceLast(desc, "V", this.classInfo.classReferenceMirror.getJVMName());
        }
        ArrayList<ClassReferenceMirror> parameterMirrors = new ArrayList<ClassReferenceMirror>();
        for (Type type : Type.getArgumentTypes(desc)) {
            parameterMirrors.add(new ClassReferenceMirror(type.getDescriptor()));
        }
        final AbstractMethodMirror methodMirror = "<init>".equals(name) ? new ConstructorMirror(this.classInfo.classReferenceMirror, new ModifierMirror(ModifierMirror.Type.METHOD, access), new ClassReferenceMirror(Type.getReturnType(desc).getDescriptor()), name, parameterMirrors, (access & 0x80) == 128, (access & 0x1000) == 4096, signature) : new MethodMirror(this.classInfo.classReferenceMirror, new ModifierMirror(ModifierMirror.Type.METHOD, access), new ClassReferenceMirror(Type.getReturnType(desc).getDescriptor()), name, parameterMirrors, (access & 0x80) == 128, (access & 0x1000) == 4096, signature);
        return new MethodVisitor(589824, super.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final AnnotationMirror annotationMirror = new AnnotationMirror(new ClassReferenceMirror(desc), visible);
                return new AnnotationMirrorVisitor(super.visitAnnotation(desc, visible), annotationMirror){

                    @Override
                    public void visitEnd() {
                        methodMirror.addAnnotation(annotationMirror);
                    }
                };
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                int lowest = methodMirror.getLineNumber();
                if (lowest == 0) {
                    methodMirror.setLineNumber(line);
                } else {
                    methodMirror.setLineNumber(Math.min(lowest, line));
                }
            }

            @Override
            public void visitEnd() {
                ClassMirrorVisitor.this.classInfo.methods.add(methodMirror);
                super.visitEnd();
            }
        };
    }

    @Override
    public void visitEnd() {
        this.done = true;
        super.visitEnd();
    }

    private static class ArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationMirror mirror;
        private final List<Object> types = new ArrayList<Object>();
        private final String name;
        private Class<?> type;

        public ArrayAnnotationVisitor(String name, AnnotationMirror mirror) {
            super(589824);
            this.name = name;
            this.mirror = mirror;
        }

        @Override
        public void visit(String name, Object value) {
            this.type = value.getClass();
            if (value instanceof Type) {
                value = ((Type)value).getClassName();
                this.type = String.class;
            }
            this.types.add(value);
            super.visit(name, value);
        }

        @Override
        public void visitEnd() {
            Object array2 = null;
            if (this.type != null) {
                array2 = ArrayUtils.cast(this.types.toArray(new Object[this.types.size()]), ClassUtils.getArrayClassFromType(this.type));
            }
            this.mirror.addAnnotationValue(this.name, array2);
            super.visitEnd();
        }
    }

    private static class AnnotationMirrorVisitor
    extends AnnotationVisitor {
        private final AnnotationMirror mirror;

        public AnnotationMirrorVisitor(AnnotationVisitor next, AnnotationMirror mirror) {
            super(589824, next);
            this.mirror = mirror;
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                value = ((Type)value).getClassName();
            }
            this.mirror.addAnnotationValue(name, value);
            super.visit(name, value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new ArrayAnnotationVisitor(name, this.mirror);
        }
    }
}

