/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core.v3;

import com.laytonsmith.libs.org.postgresql.core.Field;
import com.laytonsmith.libs.org.postgresql.core.ParameterList;
import com.laytonsmith.libs.org.postgresql.core.Utils;
import com.laytonsmith.libs.org.postgresql.core.v3.ProtocolConnectionImpl;
import com.laytonsmith.libs.org.postgresql.core.v3.SimpleParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.V3Query;
import java.lang.ref.PhantomReference;

class SimpleQuery
implements V3Query {
    private final String[] fragments;
    private final ProtocolConnectionImpl protoConnection;
    private String statementName;
    private byte[] encodedStatementName;
    private Field[] fields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private PhantomReference cleanupRef;
    private int[] preparedTypes;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(String[] fragments, ProtocolConnectionImpl protoConnection) {
        this.fragments = fragments;
        this.protoConnection = protoConnection;
    }

    @Override
    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.protoConnection);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        for (int i = 1; i < this.fragments.length; ++i) {
            if (parameters == null) {
                sbuf.append('?');
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        this.unprepare();
    }

    @Override
    public SimpleQuery[] getSubqueries() {
        return null;
    }

    String[] getFragments() {
        return this.fragments;
    }

    void setStatementName(String statementName) {
        this.statementName = statementName;
        this.encodedStatementName = Utils.encodeUTF8(statementName);
    }

    void setStatementTypes(int[] paramTypes) {
        this.preparedTypes = paramTypes;
    }

    int[] getStatementTypes() {
        return this.preparedTypes;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] paramTypes) {
        if (this.statementName == null) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == 0 || paramTypes[i] == this.preparedTypes[i]) continue;
            return false;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        for (int i = 0; i < this.preparedTypes.length; ++i) {
            if (this.preparedTypes[i] != 0) continue;
            return true;
        }
        return false;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
    }

    Field[] getFields() {
        return this.fields;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean portalDescribed) {
        this.portalDescribed = portalDescribed;
    }

    boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean statementDescribed) {
        this.statementDescribed = statementDescribed;
    }

    void setCleanupRef(PhantomReference cleanupRef) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = cleanupRef;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
    }
}

