/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CReal2dMatrix;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.AbstractMixedClass;
import com.laytonsmith.core.natives.interfaces.ArrayAccessSet;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashSet;
import java.util.Set;

@typeof(value="ms.lang.Real2dMatrixRow")
public class CReal2dMatrixRow
extends AbstractMixedClass
implements Iterable,
ArrayAccessSet {
    public static final CClassType TYPE = CClassType.get(CReal2dMatrixRow.class);
    CReal2dMatrix parent;
    int rowIndex;

    public CReal2dMatrixRow(CReal2dMatrix parent, int rowIndex) {
        this.parent = parent;
        this.rowIndex = rowIndex;
    }

    @Override
    public String docs() {
        return "This class is a reference to a row in a matrix. The underlying \"array\" is shallow, and changes to this data will be reflected in the parent matrix.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_5;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Iterable.TYPE, ArrayAccessSet.TYPE};
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        throw new CRECastException("Real2dMatrix only supports int keys.", t);
    }

    @Override
    public CDouble get(int index, Target t) throws ConfigRuntimeException {
        return new CDouble(this.getNative(index, t), t);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        return this.get(ArgumentValidation.getInt32(index, t), t);
    }

    @Override
    public Set<Mixed> keySet() {
        HashSet<Mixed> set = new HashSet<Mixed>();
        for (int i = 0; i < this.parent.columns; ++i) {
            set.add(new CInt(i, Target.UNKNOWN));
        }
        return set;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public boolean canBeAssociative() {
        return false;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        CArray ret = new CArray(t);
        int step = begin <= end ? 1 : -1;
        for (int i = begin; i != end; i += step) {
            CDouble d = this.get(i, t);
            ret.push(d, t);
        }
        return ret;
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return true;
    }

    @Override
    public long size() {
        return this.parent.columns;
    }

    @Override
    public void set(Mixed index, Mixed value, Target t) {
        int in = ArgumentValidation.getInt32(index, t);
        double d = ArgumentValidation.getDouble(value, t);
        this.setNative(in, d, t);
    }

    public String toString() {
        return "[Real2dMatrixRow]";
    }

    public void setNative(int index, double value, Target t) {
        this.parent.data[this.parent.columns * this.rowIndex + index] = value;
    }

    public double getNative(int index, Target t) {
        return this.parent.data[this.parent.columns * this.rowIndex + index];
    }
}

