/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.telemetry;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.JSONUtil;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.telemetry.ApplicationInsights.Envelope;
import com.laytonsmith.core.telemetry.ApplicationInsights.TelemetryUtil;
import com.laytonsmith.core.telemetry.DefaultTelemetry;
import com.laytonsmith.core.telemetry.LogTelemetryValue;
import com.laytonsmith.core.telemetry.MetricTelemetryValue;
import com.laytonsmith.core.telemetry.TelemetryCategory;
import com.laytonsmith.core.telemetry.TelemetryPrefs;
import com.laytonsmith.core.telemetry.TelemetryProxy;
import com.laytonsmith.core.telemetry.TelemetryType;
import com.laytonsmith.core.telemetry.TelemetryValue;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Telemetry {
    private static volatile Telemetry telemetry = null;
    private static final String INSTRUMENTATION_KEY = "28cb72ef-45fe-4634-b7e3-ea672db27cf0";
    private boolean enabled = false;
    private TelemetryChannel channel;
    private TelemetryUtil client;
    private static final TelemetryChannel STDOUT_CHANNEL = new TelemetryChannel(){

        @Override
        public void send(Envelope item) {
            JSONUtil.Options options = new JSONUtil.Options();
            options.skipNulls = true;
            StreamUtils.GetSystemOut().println("Telemetry data: " + new JSONUtil(options).serialize(item));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Telemetry GetDefault() {
        Telemetry telemetry = Telemetry.telemetry;
        if (telemetry != null) return telemetry;
        Class<Telemetry> clazz = Telemetry.class;
        synchronized (Telemetry.class) {
            telemetry = Telemetry.telemetry;
            if (telemetry != null) return telemetry;
            Telemetry.telemetry = telemetry = new Telemetry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return telemetry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void SetNoOpTelemetry() {
        Telemetry telemetry = Telemetry.telemetry;
        if (telemetry != null) return;
        Class<Telemetry> clazz = Telemetry.class;
        synchronized (Telemetry.class) {
            telemetry = Telemetry.telemetry;
            if (telemetry != null) return;
            Telemetry.telemetry = new Telemetry(){

                @Override
                public void initializeTelemetry() {
                }
            };
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String GetNagMessage() {
        return "Help make " + Implementation.GetServerType().getBranding() + " better! Enable telemetry (or disable this message) by changing the telemetry-on setting in preferences.ini to help us understand what features you're using and are most important to you. No personal information is collected.\n";
    }

    public void doNag() {
        try {
            if (Prefs.TelemetryOn() == null) {
                StreamUtils.GetSystemOut().print(Telemetry.GetNagMessage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace(StreamUtils.GetSystemErr());
        }
    }

    public void initializeTelemetry() {
        try {
            File config = MethodScriptFileLocations.getDefault().getTelemetryConfigFile();
            TelemetryPrefs.init(config);
        }
        catch (Throwable t) {
            StreamUtils.GetSystemErr().println("Could not initialize telemetry config!");
            t.printStackTrace(StreamUtils.GetSystemErr());
            return;
        }
        if (Objects.equals(Boolean.TRUE, Prefs.TelemetryOn())) {
            this.enabled = true;
        }
        if (this.enabled) {
            try {
                this.client = new TelemetryUtil(INSTRUMENTATION_KEY);
                this.channel = Prefs.TelemetryAudit() != false ? STDOUT_CHANNEL : new ProxyTelemetryChannel(new TelemetryProxy());
                String session = UUID.randomUUID().toString();
                this.client.setSessionName(session);
                this.client.setNewSession(true);
            }
            catch (Throwable t) {
                StreamUtils.GetSystemErr().println("Could not initialize telemetry!");
                t.printStackTrace(StreamUtils.GetSystemErr());
            }
        }
        this.metric(DefaultTelemetry.StartupMetric.class);
    }

    public String getSessionId() {
        if (this.client == null) {
            return null;
        }
        return this.client.getSessionName();
    }

    public void metric(Class<? extends MetricTelemetryValue> type) {
        if (this.client != null) {
            TelemetryCategory tc = TelemetryValue.Helper.GetCategory(type);
            if (tc.type() != TelemetryType.METRIC) {
                return;
            }
            if (!TelemetryPrefs.GetTelemetryLoggable(type)) {
                return;
            }
            this.channel.send(this.client.newEvent(tc.type().getPrefix() + "." + tc.name(), null, null));
        }
    }

    public void log(Class<? extends LogTelemetryValue> type, Map<String, String> properties, Map<String, Double> metrics) {
        if (this.client != null) {
            TelemetryCategory tc = TelemetryValue.Helper.GetCategory(type);
            if (tc.type() != TelemetryType.LOG) {
                return;
            }
            if (!TelemetryPrefs.GetTelemetryLoggable(type)) {
                return;
            }
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            if (metrics == null) {
                metrics = new HashMap<String, Double>();
            }
            this.channel.send(this.client.newEvent(tc.type().getPrefix() + "." + tc.name(), new ConcurrentHashMap<String, String>(properties), new ConcurrentHashMap<String, Double>(metrics)));
        }
    }

    private static interface TelemetryChannel {
        public void send(Envelope var1);
    }

    class ProxyTelemetryChannel
    implements TelemetryChannel {
        private final TelemetryProxy proxy;

        public ProxyTelemetryChannel(TelemetryProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public void send(Envelope item) {
            JSONUtil.Options options = new JSONUtil.Options();
            options.skipNulls = true;
            String body = new JSONUtil(options).serialize(item);
            this.proxy.submit(body);
        }
    }
}

